/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.mtg;

import de.grogra.mtg.MTGError;
import de.grogra.mtg.MTGKeys;
import de.grogra.mtg.MTGNode;
import de.grogra.mtg.MTGNodeDataClasses;
import de.grogra.mtg.MTGRoot;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class MTGGraphBuilderHeaderClasses {
    protected static final int MTG_CLASSES_STAGE_CLASSES = 0;
    protected static final int MTG_CLASSES_STAGE_COLUMN_NAMES = 1;
    protected static final int MTG_CLASSES_STAGE_INFO = 2;
    protected static final int MTG_CLASSES_STAGE_END = 3;
    int stage = 0;
    int classCount;
    MTGNode rootNode;

    public MTGGraphBuilderHeaderClasses(MTGNode mTGNode) {
        this.rootNode = mTGNode;
        this.classCount = 0;
    }

    private boolean isKeywordDecomposition(String string) {
        return string.equals("CONNECTED") || string.equals("LINEAR") || string.equals("<-LINEAR") || string.equals("+-LINEAR") || string.equals("FREE") || string.equals("NONE");
    }

    private boolean isKeywordDefinition(String string) {
        return string.equals("IMPLICIT") || string.equals("EXPLICIT");
    }

    private void processClasses(String[] stringArray) throws MTGError.MTGGraphBuildException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.equals("CLASSES") && !string.equals("CLASSES:")) continue;
            this.stage = 1;
        }
    }

    private void processColumnHeaders(String[] stringArray) throws MTGError.MTGGraphBuildException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("\t")) continue;
            if (!string.equals("SYMBOL")) {
                throw new MTGError.MTGGraphBuildException("Expected Identifier 'SYMBOL' in MTG File Header-Classes section not found.");
            }
            if (stringArray.length < i + 9) {
                throw new MTGError.MTGGraphBuildException("Incorrect number of column headers in MTG File Header-Classes section not found.");
            }
            if (!stringArray[i + 1].equals("\t")) {
                throw new MTGError.MTGGraphBuildException("Expected column tab in MTG File Header-Classes section not found.");
            }
            if (!stringArray[i + 2].equals("SCALE")) {
                throw new MTGError.MTGGraphBuildException("Expected Identifier 'SCALE' in MTG File Header-Classes section not found.");
            }
            if (!stringArray[i + 3].equals("\t")) {
                throw new MTGError.MTGGraphBuildException("Expected column tab in MTG File Header-Classes section not found.");
            }
            if (!stringArray[i + 4].equals("DECOMPOSITION")) {
                throw new MTGError.MTGGraphBuildException("Expected Identifier 'DECOMPOSITION' in MTG File Header-Classes section not found.");
            }
            if (!stringArray[i + 5].equals("\t")) {
                throw new MTGError.MTGGraphBuildException("Expected column tab in MTG File Header-Classes section not found.");
            }
            if (!stringArray[i + 6].equals("INDEXATION")) {
                throw new MTGError.MTGGraphBuildException("Expected Identifier 'INDEXATION' in MTG File Header-Classes section not found.");
            }
            if (!stringArray[i + 7].equals("\t")) {
                throw new MTGError.MTGGraphBuildException("Expected column tab in MTG File Header-Classes section not found.");
            }
            if (!stringArray[i + 8].equals("DEFINITION")) {
                throw new MTGError.MTGGraphBuildException("Expected Identifier 'DEFINITION' in MTG File Header-Classes section not found.");
            }
            this.stage = 2;
            return;
        }
    }

    private void processInfo(String[] stringArray) throws MTGError.MTGGraphBuildException {
        if (stringArray.length >= 1 && (stringArray[0].equals("DESCRIPTION") || stringArray[0].equals("DESCRIPTION:"))) {
            if (this.classCount <= 0) {
                throw new MTGError.MTGGraphBuildException("Missing class information in MTG File Header-Classes information Section.");
            }
            this.stage = 3;
            return;
        }
        if (stringArray.length < 9) {
            throw new MTGError.MTGGraphBuildException("Unexpected number of tokens in MTG File Header-Classes information Section.");
        }
        if (stringArray.length > 9) {
            for (int i = 9; i < stringArray.length; ++i) {
                if (stringArray[i].equals("\t")) continue;
                throw new MTGError.MTGGraphBuildException("Unexpected number of tokens in MTG File Header-Classes information Section.");
            }
        }
        if (!stringArray[0].matches("[a-zA-Z$]")) {
            throw new MTGError.MTGGraphBuildException("Unacceptable Symbol name in Column 'Symbol' in MTG File Header-Classes information Section.");
        }
        if (!stringArray[1].equals("\t")) {
            throw new MTGError.MTGGraphBuildException("Expected column tab in MTG File Header-Classes section not found.");
        }
        if (!Pattern.matches("[0-9]*", stringArray[2])) {
            throw new MTGError.MTGGraphBuildException("Unacceptable scale value in Column 'Scale' MTG File Header-Classes information Section.");
        }
        if (!stringArray[3].equals("\t")) {
            throw new MTGError.MTGGraphBuildException("Expected column tab in MTG File Header-Classes section not found.");
        }
        if (!this.isKeywordDecomposition(stringArray[4])) {
            throw new MTGError.MTGGraphBuildException("Unacceptable keyword in Column 'Decomposition' in MTG File Header-Classes information Section.");
        }
        if (!stringArray[5].equals("\t")) {
            throw new MTGError.MTGGraphBuildException("Expected column tab in MTG File Header-Classes section not found.");
        }
        if (!stringArray[7].equals("\t")) {
            throw new MTGError.MTGGraphBuildException("Expected column tab in MTG File Header-Classes section not found.");
        }
        if (!this.isKeywordDefinition(stringArray[8])) {
            throw new MTGError.MTGGraphBuildException("Unacceptable keyword in Column 'Definition' in MTG File Header-Classes information Section.");
        }
        Object object = ((MTGRoot)this.rootNode).getObject("CLASSES");
        if (object == null) {
            ((MTGRoot)this.rootNode).setObject("CLASSES", new ArrayList());
        }
        if ((object = ((MTGRoot)this.rootNode).getObject("CLASSES")) instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)((MTGRoot)this.rootNode).getObject("CLASSES");
            MTGNodeDataClasses mTGNodeDataClasses = new MTGNodeDataClasses(stringArray[0], Integer.parseInt(stringArray[2]), MTGKeys.keywordToCodeDecomposition(stringArray[4]), MTGKeys.keywordToCodeDefinition(stringArray[8]));
            arrayList.add(mTGNodeDataClasses);
            ++this.classCount;
        } else {
            throw new MTGError.MTGGraphBuildException("Unexpected data type in rootNode in MTG File Header-Classes section.");
        }
    }

    public int processTokensHeaderClasses(String[] stringArray) throws MTGError.MTGGraphBuildException {
        if (this.stage == 0) {
            this.processClasses(stringArray);
        } else if (this.stage == 1) {
            this.processColumnHeaders(stringArray);
        } else if (this.stage == 2) {
            this.processInfo(stringArray);
        } else {
            throw new MTGError.MTGGraphBuildException("Unexpected end stage parsing in MTG-Header Classes section.");
        }
        return this.stage;
    }
}

