/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.mtg;

import de.grogra.mtg.MTGKeys;
import de.grogra.mtg.MTGNode;
import de.grogra.mtg.MTGNodeDataClasses;
import de.grogra.mtg.MTGNodeDataFeature;
import de.grogra.mtg.MTGRoot;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.TypeItem;
import de.grogra.reflect.Type;
import de.grogra.rgg.model.XLFilter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;

public class MTGModuleBuilder {
    private MTGNode rootNode;
    private String systemId;
    private String errorMessage;
    private String xlFileNameWithoutExt;

    public MTGModuleBuilder() {
    }

    public MTGModuleBuilder(MTGNode mTGNode, String string, String string2) {
        this.rootNode = mTGNode;
        this.systemId = string;
        this.errorMessage = "";
        this.xlFileNameWithoutExt = string2;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int writeTypes(BufferedWriter bufferedWriter) {
        if (this.rootNode == null) {
            this.errorMessage = "Root node is null.";
            return 1;
        }
        if (bufferedWriter == null) {
            this.errorMessage = "BufferedWriter is null.";
            return 4;
        }
        try {
            Object object = ((MTGRoot)this.rootNode).getObject("CLASSES");
            if (object == null) {
                this.errorMessage = "Missing MTG classes information.";
                return 2;
            }
            ArrayList arrayList = (ArrayList)object;
            Object object2 = ((MTGRoot)this.rootNode).getObject("FEATURES");
            ArrayList arrayList2 = object2 == null ? new ArrayList() : (ArrayList)object2;
            bufferedWriter.write("/* \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* //This is a generated XL file.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* //NOTE: Do not edit the contents of this file\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* //NOTE: Invoke method 'has<standard attribute identifier>' to check if value is specified in MTG file.\t\t\t\t\t\t\n");
            bufferedWriter.write("* \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* //Standard MTG features in all generated nodes\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* //Triangular Coordinate System values\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* public double L1;\t\t\t\t\t//TR_X\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* public double L2;\t\t\t\t\t//TR_Y\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* public double L3;\t\t\t\t\t//TR_Z\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* public double DAB;\t\t\t\t//TR_DAB\t\t\t\t\t\t\t\t\t\t // Distance between points A and B.\t\t\n");
            bufferedWriter.write("* public double DAC;\t\t\t\t//TR_DAC\t\t\t\t\t\t\t\t\t\t // Distance between points A and C.\t\t\n");
            bufferedWriter.write("* public double DBC;\t\t\t\t//TR_DBC\t\t\t\t\t\t\t\t\t\t // Distance between points B and C.\t\t\n");
            bufferedWriter.write("* \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* // Attributes containing the coordinates in a Cartesian system of reference.\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* public double XX;\t\t\t\t\t//CA_X\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* public double YY;\t\t\t\t\t//CA_Y\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* public double ZZ;\t\t\t\t\t//CA_Z\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* //Attributes containing measures.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* public double Length;\t\t\t\t//ATT_LENGTH      //NOTE: super class F already contains attribute length\t\t\t\t\n");
            bufferedWriter.write("* public double Azimut;\t\t\t\t//ATT_AZIMUT\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* public double Alpha;\t\t\t\t//ATT_ALPHA\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* public double AA;\t\t\t\t\t//ATT_TETA\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* public double BB;\t\t\t\t\t//ATT_PHI\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* public double CC;\t\t\t\t\t//ATT_PSI\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* public double TopDia;\t\t\t\t//ATT_TOPDIA\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* public double BotDia;\t\t\t\t//ATT_BOTTOMDIA\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* public double Position;\t\t\t\t//ATT_POSITION\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* public int Category;\t\t\t\t//ATT_CATEGORY\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* public Vector3d DirectionPrimary;\t//ATT_DIRECTION_PRI\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* public int Order;\t\t\t\t\t//ATT_ORDER\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("* \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
            bufferedWriter.write("*/                                                                                                                            \n");
            bufferedWriter.write("import de.grogra.mtg.MTGNode;\n\n");
            for (int i = 0; i < arrayList.size(); ++i) {
                MTGNodeDataClasses mTGNodeDataClasses = (MTGNodeDataClasses)arrayList.get(i);
                String string = mTGNodeDataClasses.getSymbol();
                bufferedWriter.write("module " + MTGKeys.getGeneratedModuleName(string) + " extends MTGNode {\n");
                for (int j = 0; j < arrayList2.size(); ++j) {
                    MTGNodeDataFeature mTGNodeDataFeature = (MTGNodeDataFeature)arrayList2.get(j);
                    String string2 = mTGNodeDataFeature.getFeatureName();
                    if (MTGKeys.isStandardAttribute(string2)) continue;
                    String string3 = MTGKeys.codeToJavaTypeFeatureTypes(mTGNodeDataFeature.getFeatureTypeIndex());
                    if (string3 == null) {
                        this.errorMessage = "Feature value type with index " + mTGNodeDataFeature.getFeatureNameIndex() + " not recognized.";
                        return 3;
                    }
                    bufferedWriter.write("    public " + string3 + " " + string2 + ";\n\n");
                    bufferedWriter.write("    public boolean has" + string2 + ";\n\n");
                    bufferedWriter.write("    public void set" + string2 + "(" + string3 + " val)\n    {\n        this." + string2 + "=val;\n    }\n\n");
                    bufferedWriter.write("    public " + string3 + " get" + string2 + "()" + "\n    {\n        return this." + string2 + ";\n    }\n\n");
                    bufferedWriter.write("    public void setHas" + string2 + "(boolean val)\n    {\n        this.has" + string2 + "=val;\n    }\n\n");
                    bufferedWriter.write("    public boolean has" + string2 + "()" + "\n    {\n        return this.has" + string2 + ";\n    }\n\n");
                }
                bufferedWriter.write("}\n\n");
            }
            return 0;
        }
        catch (Throwable throwable) {
            this.errorMessage = throwable.getMessage();
            return -1;
        }
    }

    public int compileTypes(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            this.errorMessage = "BufferedReader is null.";
            return 1;
        }
        String string = "";
        String string2 = null;
        try {
            string2 = bufferedReader.readLine();
            while (string2 != null) {
                string = string + string2;
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            this.errorMessage = iOException.getMessage();
            return 2;
        }
        try {
            Type[] typeArray = XLFilter.compile(new StringReader(string), this.systemId);
            if (typeArray != null) {
                ((MTGRoot)this.rootNode).setObject("RGGModules", typeArray);
            }
            Registry registry = Registry.current();
            for (int i = 0; i < typeArray.length; ++i) {
                registry.getDirectory("/classes", null).add((Item)new TypeItem(typeArray[i]));
            }
        }
        catch (Throwable throwable) {
            this.errorMessage = throwable.getMessage();
            return 3;
        }
        return 0;
    }
}

