/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.mtg;

import java.util.StringTokenizer;

public class MTGTokenizer {
    private String lineString;
    private static final String delimiters = " \t\n\r\f#";
    private static final String delimitersTopo = ",";
    private static final String delimitersEntity = "+</.^*";
    boolean commentCharFound;

    public MTGTokenizer(String string) {
        this.lineString = string;
        this.commentCharFound = false;
    }

    public void setLineString(String string) {
        this.lineString = string;
    }

    public void setCommentCharFound(boolean bl) {
        this.commentCharFound = bl;
    }

    public String[] tokenizeLineString() {
        String[] stringArray;
        StringTokenizer stringTokenizer = new StringTokenizer(this.lineString, delimiters, true);
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            return null;
        }
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            if (this.commentCharFound && (stringArray.equalsIgnoreCase("\t") || stringArray.equalsIgnoreCase("#"))) {
                this.commentCharFound = false;
            }
            if (stringArray.equalsIgnoreCase("#")) {
                this.commentCharFound = true;
            }
            if (this.commentCharFound || stringArray.equalsIgnoreCase(" ")) continue;
            stringArray2[n2] = stringArray;
            ++n2;
        }
        if (n2 == n) {
            return stringArray2;
        }
        stringArray = new String[n2];
        System.arraycopy(stringArray2, 0, stringArray, 0, n2);
        return stringArray;
    }

    public static String[] tokenizeTopoRightClasses(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, delimitersTopo, false);
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    public static String[] tokenizeEntityNames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, delimitersEntity, true);
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }
}

