/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.rgg;

import de.grogra.pf.ui.Workbench;
import de.grogra.rgg.ConcurrentTask;
import de.grogra.rgg.model.LocalSolver;
import de.grogra.rgg.model.QueueSolver;
import de.grogra.rgg.model.RGGGraph;
import de.grogra.rgg.model.Runtime;
import de.grogra.task.PartialTask;
import de.grogra.task.Solver;
import de.grogra.task.Task;
import de.grogra.xl.impl.queues.QueueCollection;
import de.grogra.xl.util.ObjectList;
import java.util.TimerTask;

public final class ConcurrentTasks
extends Task {
    private ObjectList<ConcurrentTask> newTasks = new ObjectList();
    private ObjectList<ConcurrentTask> tasks = new ObjectList();
    private int taskCount;
    private int localSolverCount = java.lang.Runtime.getRuntime().availableProcessors();
    private TimerTask disposer;

    private void rescheduleDisposer() {
        if (this.disposer != null) {
            this.disposer.cancel();
        }
        this.disposer = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ConcurrentTasks concurrentTasks = ConcurrentTasks.this;
                synchronized (concurrentTasks) {
                    if (!ConcurrentTasks.this.isSolving()) {
                        ConcurrentTasks.this.removeSolvers();
                    }
                }
            }
        };
        Workbench.TIMER.schedule(this.disposer, 5000L);
    }

    public void setLocalSolverCount(int n) {
        this.localSolverCount = n;
    }

    public void add(ConcurrentTask concurrentTask) {
        this.newTasks.add((Object)concurrentTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PartialTask nextPartialTask(int n) {
        ObjectList<ConcurrentTask> objectList = this.tasks;
        synchronized (objectList) {
            return this.tasks.isEmpty() ? null : (ConcurrentTask)this.tasks.removeAt(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose(PartialTask partialTask) {
        if (((ConcurrentTask)partialTask).processed) {
            --this.taskCount;
        } else {
            ObjectList<ConcurrentTask> objectList = this.tasks;
            synchronized (objectList) {
                this.tasks.add((Object)((ConcurrentTask)partialTask));
            }
        }
    }

    protected boolean done() {
        return this.taskCount == 0;
    }

    protected void prepareSolve() {
        if (this.getSolverCount() == 0) {
            for (int i = 0; i < this.localSolverCount; ++i) {
                this.addSolver((Solver)new LocalSolver(Workbench.current()));
            }
        }
    }

    public void solve() {
        ObjectList<ConcurrentTask> objectList = this.newTasks;
        this.newTasks = this.tasks;
        this.tasks = objectList;
        this.newTasks.clear();
        this.taskCount = this.tasks.size();
        super.solve();
    }

    protected void finishSolve() {
        int n;
        this.rescheduleDisposer();
        RGGGraph rGGGraph = Runtime.INSTANCE.currentGraph();
        QueueCollection queueCollection = rGGGraph.getQueues();
        Solver[] solverArray = this.getSolvers();
        for (n = 0; n < solverArray.length; ++n) {
            ((QueueSolver)solverArray[n]).addQueuesTo(queueCollection);
        }
        rGGGraph.derive();
        for (n = 0; n < solverArray.length; ++n) {
            ((QueueSolver)solverArray[n]).clearQueues();
        }
    }
}

