/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.rgg.model;

import antlr.TokenStream;
import antlr.collections.AST;
import de.grogra.grammar.ASTWithToken;
import de.grogra.grammar.Tokenizer;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.ReaderSource;
import de.grogra.pf.io.ReaderSourceImpl;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ItemVisitor;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.TypeItem;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Console;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.Workbench;
import de.grogra.reflect.Field;
import de.grogra.reflect.Method;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.reflect.TypeLoader;
import de.grogra.rgg.Library;
import de.grogra.rgg.model.CompilationFilter;
import de.grogra.rgg.model.RGGFilter;
import de.grogra.rgg.model.Runtime;
import de.grogra.rgg.model.XLFilter;
import de.grogra.util.DelegatingClassLoader;
import de.grogra.util.DetailedException;
import de.grogra.util.Lockable;
import de.grogra.util.Map;
import de.grogra.util.MimeType;
import de.grogra.util.Utils;
import de.grogra.xl.compiler.CClass;
import de.grogra.xl.compiler.scope.ClassPath;
import de.grogra.xl.compiler.scope.CompilationUnitScope;
import de.grogra.xl.compiler.scope.Package;
import de.grogra.xl.compiler.scope.PackageImportOnDemand;
import de.grogra.xl.compiler.scope.Scope;
import de.grogra.xl.parser.Parser;
import de.grogra.xl.parser.XLParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;

public final class ShellFilter
extends RGGFilter {
    public static final String SHELL_PACKAGE = "$shell$";
    public static final String SHELL_CLASS = "Shell";
    private final ClassPath path;
    private final CompilationUnitScope last;

    public ShellFilter(Registry registry, ClassPath classPath, String string, CompilationUnitScope compilationUnitScope) {
        super(null, (ReaderSource)new ReaderSourceImpl((Reader)new StringReader(string), "console", MimeType.TEXT_PLAIN, registry, null));
        this.path = classPath;
        this.last = compilationUnitScope;
    }

    ClassPath getClassPath() {
        return this.path;
    }

    protected Scope getImports(ClassPath classPath) throws ClassNotFoundException {
        if (this.last == null) {
            return new PackageImportOnDemand(super.getImports(classPath), classPath.getPackage("", true));
        }
        for (CompilationUnitScope compilationUnitScope = this.last; compilationUnitScope != null; compilationUnitScope = compilationUnitScope.getEnclosingScope()) {
            if (!(compilationUnitScope.getEnclosingScope() instanceof Package)) continue;
            compilationUnitScope.insert(null);
            break;
        }
        return this.last.getEnclosingScope();
    }

    protected Parser createParser(Tokenizer tokenizer) {
        XLParser xLParser = new XLParser((TokenStream)tokenizer);
        xLParser.setShell((AST)new ASTWithToken(11, SHELL_PACKAGE), SHELL_CLASS);
        return xLParser;
    }

    public static Console createConsole(Context context, Map map) {
        final Workbench workbench = context.getWorkbench();
        final Console console = workbench.getToolkit().createConsole(context, map);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ConsoleRunnable
        implements Runnable,
        Command,
        ItemVisitor {
            static final String PROMPT = "> ";
            ClassPath path = new ClassPath(XLFilter.getLoaderForAll());
            CClass shell;
            ArrayList<ClassLoader> loaders = new ArrayList();
            private CompilationUnitScope lastScope;
            private Type lastShell;

            ConsoleRunnable() {
                this.shell = new CClass(ShellFilter.SHELL_CLASS, "$shell$.Shell", 1025, null, true);
                this.shell.initSupertype(Type.OBJECT);
                this.shell.initTypeLoader((TypeLoader)this.path);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                console.getOut().print(PROMPT);
                console.getOut().flush();
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    int n;
                    while ((n = console.getIn().read()) >= 0) {
                        if (n != 10) {
                            stringBuffer.append((char)n);
                            continue;
                        }
                        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == '\\') {
                            stringBuffer.setCharAt(stringBuffer.length() - 1, '\n');
                            continue;
                        }
                        UI.executeLockedly((Lockable)workbench.getRegistry().getProjectGraph(), (boolean)true, (Command)this, (Object)stringBuffer.toString(), (Context)workbench, (int)10000);
                        stringBuffer.setLength(0);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                ConsoleRunnable consoleRunnable = this;
                synchronized (consoleRunnable) {
                    this.path = null;
                    this.shell = null;
                }
            }

            public void visit(Item item, Object object) {
                Type type;
                if (item instanceof TypeItem && (type = (Type)((TypeItem)item).getObject()).getDeclaringType() == null) {
                    this.path.getPackage(type.getPackage(), true).declareType(type);
                    Class clazz = type.getImplementationClass();
                    if (!Reflection.canLoad((ClassLoader)this.path.getClassLoader(), (Class)clazz)) {
                        int n;
                        ClassLoader classLoader = clazz.getClassLoader();
                        for (n = this.loaders.size() - 1; n >= 0; --n) {
                            if (!Reflection.canLoad((ClassLoader)this.loaders.get(n), (Class)clazz)) continue;
                            return;
                        }
                        for (n = this.loaders.size() - 1; n >= 0; --n) {
                            if (!Reflection.isAncestorOrSame((ClassLoader)this.loaders.get(n), (ClassLoader)classLoader)) continue;
                            this.loaders.remove(n);
                        }
                        this.loaders.add(classLoader);
                    }
                }
            }

            public String getCommandName() {
                return console.getPanelId();
            }

            public synchronized void run(Object object, Context context) {
                String string = (String)object;
                Throwable throwable = null;
                if (this.shell != null && string.trim().length() > 0) {
                    Throwable throwable2;
                    Field field;
                    CompilationFilter compilationFilter;
                    Field field2;
                    for (int i = this.shell.getDeclaredMethodCount() - 1; i >= 0; --i) {
                        this.shell.removeMethod(this.shell.getDeclaredMethod(i));
                    }
                    Registry registry = context.getWorkbench().getRegistry();
                    this.loaders.clear();
                    Item.forAll((RegistryContext)registry, (String)"/classes", null, null, (ItemVisitor)this, null, (boolean)false);
                    ClassLoader classLoader = this.path.getClassLoader();
                    if (!this.loaders.isEmpty()) {
                        this.loaders.add(classLoader);
                        classLoader = new DelegatingClassLoader(this.loaders.toArray(new ClassLoader[this.loaders.size()]));
                    }
                    HashSet<String> hashSet = new HashSet<String>();
                    HashSet<Field> hashSet2 = new HashSet<Field>();
                    for (int i = this.shell.getDeclaredFieldCount() - 1; i >= 0; --i) {
                        field2 = this.shell.getDeclaredField(i);
                        if (!Reflection.isPrimitive((Type)field2.getType()) && !Reflection.canLoad((ClassLoader)classLoader, (Class)field2.getType().getImplementationClass())) {
                            this.shell.removeField(field2);
                            hashSet.add(field2.getDescriptor());
                            continue;
                        }
                        hashSet2.add(field2);
                    }
                    try {
                        if (string.charAt(string.length() - 1) != ';') {
                            string = string + "\n;";
                        }
                        compilationFilter = new CompilationFilter(null, (FilterSource)new ShellFilter(registry, this.path, string, this.lastScope));
                        field2 = compilationFilter.compile(this.shell, classLoader)[0];
                    }
                    catch (IOException iOException) {
                        for (int i = this.shell.getDeclaredFieldCount() - 1; i >= 0; --i) {
                            field = this.shell.getDeclaredField(i);
                            if (hashSet2.contains(field)) continue;
                            this.shell.removeField(field);
                        }
                        compilationFilter = null;
                        field2 = null;
                        throwable2 = Utils.getMainException((Throwable)iOException);
                        if (throwable2 instanceof DetailedException) {
                            console.getErr().println(((DetailedException)throwable2).getDetailedMessage(false));
                        }
                        throwable = throwable2;
                    }
                    if (compilationFilter != null) {
                        this.lastScope = compilationFilter.getCompilationUnit();
                        if (this.lastShell != null) {
                            for (int i = this.lastShell.getDeclaredFieldCount() - 1; i >= 0; --i) {
                                throwable2 = this.lastShell.getDeclaredField(i);
                                if ((throwable2.getModifiers() & 0x1001) != 1 || (field = Reflection.getDeclaredField((Type)field2, (String)throwable2.getDescriptor())) == null || hashSet.contains(throwable2.getDescriptor())) continue;
                                try {
                                    Object object2 = Reflection.get(null, (Field)throwable2);
                                    Reflection.set(null, (Field)field, (Object)object2);
                                    continue;
                                }
                                catch (Exception exception) {
                                    console.getErr().println(throwable2.getDescriptor() + " " + exception);
                                }
                            }
                        }
                        this.lastShell = field2;
                        Method method = Reflection.getDeclaredMethod((Type)field2, (String)"execute");
                        if (method != null) {
                            try {
                                if (Runtime.INSTANCE.currentGraph() != null) {
                                    throwable2 = Library.apply(1);
                                    try {
                                        while (throwable2.next()) {
                                            method.invoke(null, null);
                                        }
                                        throwable2.dispose(null);
                                    }
                                    catch (Throwable throwable3) {
                                        throwable2.dispose(throwable3);
                                        Utils.rethrow((Throwable)throwable3);
                                    }
                                } else {
                                    method.invoke(null, null);
                                }
                            }
                            catch (Exception exception) {
                                throwable = exception;
                            }
                        }
                    }
                }
                if (throwable != null) {
                    console.getErr().println(throwable);
                }
                console.getOut().print(PROMPT);
                console.getOut().flush();
                Utils.rethrow(throwable);
            }
        }
        new Thread((Runnable)new ConsoleRunnable(), "Console@" + context.getWorkbench()).start();
        return console;
    }
}

