/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath.geom;

import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.Variables;
import de.grogra.vecmath.geom.Volume;

public final class IntersectionList
extends Variables {
    public int size;
    public Intersection[] elements = new Intersection[16];
    private Intersection[] removeBuffer = new Intersection[16];

    public void setSize(int n) {
        if (this.elements.length < n) {
            Intersection[] intersectionArray = new Intersection[Math.max(this.elements.length * 2, n)];
            System.arraycopy(this.elements, 0, intersectionArray, 0, this.elements.length);
            this.elements = intersectionArray;
        }
        this.size = n;
        while (--n >= 0 && this.elements[n] == null) {
            this.elements[n] = new Intersection(this);
        }
    }

    public void clear() {
        this.size = 0;
        this.setISize(0);
    }

    public Intersection add(Volume volume, Line line, double d, int n) {
        Intersection intersection = this.add();
        intersection.volume = volume;
        intersection.solid = volume;
        intersection.line = line;
        intersection.parameter = d;
        intersection.type = n;
        return intersection;
    }

    public Intersection add(Volume volume, Line line, double d, int n, int n2) {
        Intersection intersection = this.add();
        intersection.volume = volume;
        intersection.solid = volume;
        intersection.line = line;
        intersection.parameter = d;
        intersection.type = n;
        intersection.face = n2;
        return intersection;
    }

    private Intersection add() {
        int n = this.size;
        this.setSize(n + 1);
        Intersection intersection = this.elements[n];
        intersection.reset();
        return intersection;
    }

    public void addSwap(int n) {
        Intersection intersection = this.add();
        this.elements[this.size - 1] = this.elements[n];
        this.elements[n] = intersection;
    }

    public void remove(int n, int n2) {
        int n3 = n2 - n;
        if (n3 == 0) {
            return;
        }
        if (this.removeBuffer.length < n3) {
            this.removeBuffer = new Intersection[Math.max(this.removeBuffer.length * 2, n3)];
        }
        System.arraycopy(this.elements, n, this.removeBuffer, 0, n3);
        System.arraycopy(this.elements, n2, this.elements, n, this.size - n2);
        this.size -= n3;
        System.arraycopy(this.removeBuffer, 0, this.elements, this.size, n3);
    }

    public int findClosestIntersection(double d, double d2, int n, int n2) {
        int n3 = -1;
        while (n < n2) {
            double d3 = Math.abs(this.elements[n].parameter - d);
            if (d3 < d2) {
                n3 = n;
                d2 = d3;
            }
            ++n;
        }
        return n3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("IntersectionList[");
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.elements[i]);
        }
        return stringBuffer.append(']').toString();
    }
}

