/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath.geom;

import de.grogra.vecmath.geom.BoundingBox;
import de.grogra.vecmath.geom.CellIterator;
import de.grogra.vecmath.geom.CompoundVolume;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.Variables;
import de.grogra.vecmath.geom.Volume;
import java.util.ArrayList;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public abstract class Octree {
    public static final int MAX_DEPTH = 9;
    public static final int MAX_GRID_SIZE = 512;
    final Point3d min = new Point3d();
    final Point3d max = new Point3d();
    final Vector3d minCellSize = new Vector3d();
    private Cell root;
    private int depth;
    private int cellCount;
    private int maxDepth;
    private int minObjects;
    private final Vector3d center = new Vector3d();
    private final BoundingBox cellBounds = new BoundingBox(new Point3d(), new Point3d());

    protected void initialize(int n, int n2, Tuple3d tuple3d, Tuple3d tuple3d2, Cell cell) {
        if (n < 0) {
            throw new IllegalArgumentException("maxDepth negative");
        }
        if (n > 9) {
            throw new IllegalArgumentException("maxDepth greater than MAX_DEPTH");
        }
        this.maxDepth = n;
        this.minObjects = n2;
        this.root = cell;
        this.min.set(tuple3d);
        this.max.set(tuple3d2);
        this.minCellSize.sub(tuple3d2, tuple3d);
        this.minCellSize.scale(0.001953125);
        this.depth = 0;
        this.cellCount = 1;
        this.recursivelyDivideNode(0, cell, this.createState());
        this.finishCells();
    }

    protected void finishCells() {
        this.root.finish(this);
    }

    private void recursivelyDivideNode(int n, Cell cell, State state) {
        int n2 = cell.getVolumeCount();
        if (n < this.maxDepth && n2 > this.minObjects) {
            cell.divide();
            boolean bl = false;
            for (int i = 0; i < 8; ++i) {
                Cell cell2 = cell.children[i];
                cell2.getExtent(this, this.cellBounds.min, this.cellBounds.max);
                this.center.sub(this.cellBounds.max, this.cellBounds.min);
                double d = 0.5 * this.center.length();
                this.center.add(this.cellBounds.min, this.cellBounds.max);
                this.center.scale(0.5);
                for (int j = 0; j < n2; ++j) {
                    Volume volume = cell.getVolume(j, state);
                    if (!volume.boxContainsBoundary(this.cellBounds, this.center, d, state)) continue;
                    cell2.addVolume(volume);
                }
                this.recursivelyDivideNode(n + 1, cell2, state);
                bl |= cell2.getVolumeCount() < n2;
            }
            if (bl) {
                this.depth = Math.max(this.depth, n + 1);
                this.cellCount += 8;
                cell.clearVolumes();
            } else {
                cell.children = null;
            }
        }
    }

    public Point3d getMin() {
        return this.min;
    }

    public Point3d getMax() {
        return this.max;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getCellCount() {
        return this.cellCount;
    }

    public Cell getRoot() {
        return this.root;
    }

    public abstract State createState();

    protected abstract ArrayList getInfiniteVolumes();

    public boolean computeIntersections(Line line, int n, IntersectionList intersectionList, Intersection intersection, Intersection intersection2, State state) {
        int n2;
        int n3;
        int n4 = intersectionList.size;
        int n5 = intersectionList.getISize();
        state.cellIterator.setLine(line);
        double d = line.end;
        boolean bl = false;
        ArrayList arrayList = this.getInfiniteVolumes();
        if (arrayList != null) {
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                Volume volume = (Volume)arrayList.get(n3);
                int n6 = intersectionList.size;
                bl |= volume.computeIntersections(line, n, intersectionList, intersection, intersection2);
                if (intersectionList.size <= n6) continue;
                if (n == 2) {
                    return bl;
                }
                intersectionList.ipush(0);
                intersectionList.ipush(n6);
                if (n != 1) continue;
                line.end = intersectionList.elements[n6].parameter;
            }
        }
        block1: while (state.cellIterator.hasNext()) {
            Cell cell = (Cell)state.cellIterator.next();
            if (n != 0 && state.cellIterator.getEnteringParameter() > line.end) break;
            for (int i = cell.getVolumeCount() - 1; i >= 0; --i) {
                Volume volume = cell.getVolume(i, state);
                n2 = volume.getId();
                if (!state.mark(n2)) continue;
                intersectionList.ipush(n2);
                int n7 = intersectionList.size;
                bl |= volume.computeIntersections(line, n, intersectionList, intersection, intersection2);
                if (intersectionList.size > n7) {
                    intersectionList.ipush(n7);
                    if (n == 2) break block1;
                    if (n != 1) continue;
                    line.end = intersectionList.elements[n7].parameter;
                    continue;
                }
                intersectionList.ipush(-1);
            }
        }
        line.end = d;
        n3 = intersectionList.getISize() - n5 >> 1;
        if (n3 > 0) {
            int n8;
            int n9 = n5;
            for (n8 = 0; n8 < n3; ++n8) {
                n2 = n5 + (n8 << 1);
                state.clear(intersectionList.istack[n2]);
                n2 = intersectionList.istack[n2 + 1];
                if (n2 < 0) continue;
                intersectionList.istack[n9++] = n2;
            }
            n3 = n9 - n5;
            if (n3 > 1) {
                n8 = n9;
                for (n2 = 1; n2 < n3; ++n2) {
                    intersectionList.istack[n8 + n2 - 1] = intersectionList.istack[n5 + n2];
                }
                intersectionList.istack[n8 + n3 - 1] = intersectionList.size;
                CompoundVolume.sortIntersections(n == 0, intersectionList, n4, n3, n5, n8);
            } else {
                intersectionList.setISize(n5);
            }
        }
        return bl;
    }

    public static int suggestDepth(int n) {
        int n2 = (int)(Math.log((double)(2 * n) / 0.1) / Math.log(8.0));
        if (n2 < 4) {
            return 4;
        }
        if (n2 >= 9) {
            return 9;
        }
        double d = 1 << n2;
        double d2 = (double)n / (d * d) + 0.1 * d;
        double d3 = (double)n / ((d = (double)(1 << n2 + 1)) * d) + 0.1 * d;
        return d2 < d3 ? n2 : n2 + 1;
    }

    public static abstract class State
    extends Variables {
        protected CellIterator cellIterator;

        public abstract boolean mark(int var1);

        public abstract void clear(int var1);
    }

    public static abstract class Cell {
        public static final int ROOT_POSITION = 9;
        static final int WIDTH_MASK = 15;
        static final int X_BIT = 5;
        static final int Y_BIT = 14;
        static final int Z_BIT = 23;
        static final int POS_MASK = 511;
        int position;
        public Cell[] children = null;
        public Cell front;
        public Cell back;
        public Cell top;
        public Cell bottom;
        public Cell left;
        public Cell right;

        public abstract int getVolumeCount();

        public abstract void clearVolumes();

        public abstract Volume getVolume(int var1, State var2);

        public abstract void addVolume(Volume var1);

        protected abstract Cell createChild(int var1);

        public Cell(int n) {
            this.position = n;
        }

        Cell getChild(int n) {
            if (this.children == null || n < 0 || n > 7) {
                return null;
            }
            return this.children[n];
        }

        public void getExtent(Octree octree, Tuple3d tuple3d, Tuple3d tuple3d2) {
            int n = this.position >> 5 & 0x1FF;
            int n2 = this.position >> 14 & 0x1FF;
            int n3 = this.position >> 23 & 0x1FF;
            Vector3d vector3d = octree.minCellSize;
            tuple3d.x = octree.min.x + vector3d.x * (double)n;
            tuple3d.y = octree.min.y + vector3d.y * (double)n2;
            tuple3d.z = octree.min.z + vector3d.z * (double)n3;
            int n4 = 1 << (this.position & 0xF);
            tuple3d2.x = octree.min.x + vector3d.x * (double)(n + n4);
            tuple3d2.y = octree.min.y + vector3d.y * (double)(n2 + n4);
            tuple3d2.z = octree.min.z + vector3d.z * (double)(n3 + n4);
        }

        void divide() {
            int n = this.position - 1;
            int n2 = 1 << (n & 0xF);
            this.children = new Cell[8];
            this.children[0] = this.createChild(n);
            this.children[1] = this.createChild(n + (n2 << 23));
            this.children[2] = this.createChild(n + (n2 << 14));
            this.children[3] = this.createChild(n + (n2 << 14) + (n2 << 23));
            this.children[4] = this.createChild(n + (n2 << 5));
            this.children[5] = this.createChild(n + (n2 << 5) + (n2 << 23));
            this.children[6] = this.createChild(n + (n2 << 5) + (n2 << 14));
            this.children[7] = this.createChild(n + (n2 << 5) + (n2 << 14) + (n2 << 23));
        }

        void finish(Octree octree) {
            if (this.children == null) {
                return;
            }
            for (int i = 0; i < 8; ++i) {
                Cell cell = this.children[i];
                if ((i & 3) < 2) {
                    cell.front = this.front;
                    if (this.front != null && this.front.children != null) {
                        cell.front = this.front.getChild(i + 2);
                    }
                    cell.back = this.getChild(i + 2);
                } else {
                    cell.back = this.back;
                    if (this.back != null && this.back.children != null) {
                        cell.back = this.back.getChild(i - 2);
                    }
                    cell.front = this.getChild(i - 2);
                }
                if (i < 4) {
                    cell.left = this.left;
                    if (this.left != null && this.left.children != null) {
                        cell.left = this.left.getChild(i + 4);
                    }
                    cell.right = this.getChild(i + 4);
                } else {
                    cell.right = this.right;
                    if (this.right != null && this.right.children != null) {
                        cell.right = this.right.getChild(i - 4);
                    }
                    cell.left = this.getChild(i - 4);
                }
                if ((i & 1) == 0) {
                    cell.bottom = this.bottom;
                    if (this.bottom != null && this.bottom.children != null) {
                        cell.bottom = this.bottom.getChild(i + 1);
                    }
                    cell.top = this.getChild(i + 1);
                } else {
                    cell.top = this.top;
                    if (this.top != null && this.top.children != null) {
                        cell.top = this.top.getChild(i - 1);
                    }
                    cell.bottom = this.getChild(i - 1);
                }
                cell.finish(octree);
            }
        }

        String toString(Octree octree) {
            Vector3d vector3d = new Vector3d();
            Vector3d vector3d2 = new Vector3d();
            this.getExtent(octree, vector3d, vector3d2);
            return this.getClass().getName() + '(' + vector3d + " - " + vector3d2 + ')';
        }
    }
}

