/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath.geom;

import de.grogra.vecmath.Math2;
import de.grogra.vecmath.geom.CellIterator;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.Octree;
import de.grogra.vecmath.geom.UnionBase;
import de.grogra.vecmath.geom.Variables;
import de.grogra.vecmath.geom.Volume;
import java.util.ArrayList;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class OctreeUnion
extends UnionBase {
    final ArrayList<Volume> infiniteObjects = new ArrayList();
    private CellIterator cellIterator;
    private int maxId;
    private final Octree octree = new Octree(){

        public Octree.State createState() {
            StateImpl stateImpl = new StateImpl();
            stateImpl.intersectedVolumes = new boolean[OctreeUnion.this.maxId + 1];
            stateImpl.cellIterator = OctreeUnion.this.cellIterator.dup();
            return stateImpl;
        }

        protected ArrayList getInfiniteVolumes() {
            return OctreeUnion.this.infiniteObjects;
        }
    };

    public Octree getOctree() {
        return this.octree;
    }

    public void initialize(int n, int n2, CellIterator cellIterator) {
        this.infiniteObjects.clear();
        this.cellIterator = cellIterator;
        Point3d point3d = new Point3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Point3d point3d2 = new Point3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        Point3d point3d3 = new Point3d();
        Point3d point3d4 = new Point3d();
        Variables variables = new Variables();
        ArrayList<Volume> arrayList = new ArrayList<Volume>();
        this.maxId = 0;
        for (int i = 0; i < this.volumes.size(); ++i) {
            Volume volume = (Volume)this.volumes.get(i);
            volume.getExtent(point3d3, point3d4, variables);
            if (point3d3.x == Double.NEGATIVE_INFINITY || point3d3.y == Double.NEGATIVE_INFINITY || point3d3.z == Double.NEGATIVE_INFINITY || point3d4.x == Double.POSITIVE_INFINITY || point3d4.y == Double.POSITIVE_INFINITY || point3d4.z == Double.POSITIVE_INFINITY) {
                this.infiniteObjects.add(volume);
                continue;
            }
            this.maxId = Math.max(this.maxId, volume.getId());
            arrayList.add(volume);
            Math2.min(point3d, point3d3);
            Math2.max(point3d2, point3d4);
        }
        if (arrayList.isEmpty()) {
            point3d.set(0.0, 0.0, 0.0);
            point3d2.set(1.0, 1.0, 1.0);
        }
        double d = point3d2.distanceLinf(point3d);
        point3d3.add(point3d, point3d2);
        point3d3.scale(0.5);
        point3d4.set(d, d, d);
        point3d.scaleAdd(-0.5001, point3d4, point3d3);
        point3d2.scaleAdd(0.5001, point3d4, point3d3);
        CellImpl cellImpl = new CellImpl(9);
        cellImpl.volumes = arrayList;
        this.octree.initialize(n, n2, point3d, point3d2, cellImpl);
        this.cellIterator.initialize(this.octree);
    }

    public void addInfiniteVolume(Volume volume) {
        this.infiniteObjects.add(volume);
    }

    public boolean computeIntersections(Line line, int n, IntersectionList intersectionList, Intersection intersection, Intersection intersection2) {
        Octree.State state = (Octree.State)intersectionList.cache.get(this);
        if (state == null) {
            state = this.octree.createState();
            intersectionList.cache.put(this, state);
        }
        return this.octree.computeIntersections(line, n, intersectionList, intersection, intersection2, state);
    }

    public void getExtent(Tuple3d tuple3d, Tuple3d tuple3d2, Variables variables) {
        tuple3d.set(this.octree.getMin());
        tuple3d2.set(this.octree.getMax());
    }

    static final class CellImpl
    extends Octree.Cell {
        ArrayList<Volume> volumes = new ArrayList();

        CellImpl(int n) {
            super(n);
        }

        protected Octree.Cell createChild(int n) {
            return new CellImpl(n);
        }

        public int getVolumeCount() {
            return this.volumes != null ? this.volumes.size() : 0;
        }

        public void clearVolumes() {
            this.volumes = null;
        }

        public Volume getVolume(int n, Octree.State state) {
            return this.volumes.get(n);
        }

        public void addVolume(Volume volume) {
            this.volumes.add(volume);
        }

        void finish(Octree octree) {
            super.finish(octree);
            if (this.volumes != null) {
                this.volumes.trimToSize();
            }
        }
    }

    static final class StateImpl
    extends Octree.State {
        boolean[] intersectedVolumes;

        StateImpl() {
        }

        public boolean mark(int n) {
            if (this.intersectedVolumes[n]) {
                return false;
            }
            this.intersectedVolumes[n] = true;
            return true;
        }

        public void clear(int n) {
            this.intersectedVolumes[n] = false;
        }
    }
}

