/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.GMatrix;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4d;
import javax.vecmath.Tuple4f;

public class GVector
implements Serializable {
    private int elementCount;
    private double[] elementData;

    public GVector(int n) {
        this.elementCount = n;
        this.elementData = new double[n];
    }

    public GVector(double[] dArray) {
        this(dArray.length);
        System.arraycopy(dArray, 0, this.elementData, 0, this.elementCount);
    }

    public GVector(GVector gVector) {
        this(gVector.elementCount);
        System.arraycopy(gVector.elementData, 0, this.elementData, 0, this.elementCount);
    }

    public GVector(Tuple2f tuple2f) {
        this(2);
        this.set(tuple2f);
    }

    public GVector(Tuple3f tuple3f) {
        this(3);
        this.set(tuple3f);
    }

    public GVector(Tuple3d tuple3d) {
        this(3);
        this.set(tuple3d);
    }

    public GVector(Tuple4f tuple4f) {
        this(4);
        this.set(tuple4f);
    }

    public GVector(Tuple4d tuple4d) {
        this(4);
        this.set(tuple4d);
    }

    public GVector(double[] dArray, int n) {
        this(n);
        System.arraycopy(dArray, 0, this.elementData, 0, this.elementCount);
    }

    public final double norm() {
        return Math.sqrt(this.normSquared());
    }

    public final double normSquared() {
        double d = 0.0;
        for (int i = 0; i < this.elementCount; ++i) {
            d += this.elementData[i] * this.elementData[i];
        }
        return d;
    }

    public final void normalize(GVector gVector) {
        this.set(gVector);
        this.normalize();
    }

    public final void normalize() {
        double d = this.norm();
        int n = 0;
        while (n < this.elementCount) {
            int n2 = n++;
            this.elementData[n2] = this.elementData[n2] / d;
        }
    }

    public final void scale(double d, GVector gVector) {
        this.set(gVector);
        this.scale(d);
    }

    public final void scale(double d) {
        int n = 0;
        while (n < this.elementCount) {
            int n2 = n++;
            this.elementData[n2] = this.elementData[n2] * d;
        }
    }

    public final void scaleAdd(double d, GVector gVector, GVector gVector2) {
        double[] dArray = gVector.elementData;
        double[] dArray2 = gVector2.elementData;
        if (this.elementCount != gVector.elementCount) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != v1's size:" + gVector.elementCount);
        }
        if (this.elementCount != gVector2.elementCount) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != v2's size:" + gVector2.elementCount);
        }
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = d * dArray[i] + dArray2[i];
        }
    }

    public final void add(GVector gVector) {
        double[] dArray = gVector.elementData;
        if (this.elementCount != gVector.elementCount) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != v2's size:" + gVector.elementCount);
        }
        for (int i = 0; i < this.elementCount; ++i) {
            int n = i;
            this.elementData[n] = this.elementData[n] + dArray[i];
        }
    }

    public final void add(GVector gVector, GVector gVector2) {
        this.set(gVector);
        this.add(gVector2);
    }

    public final void sub(GVector gVector) {
        double[] dArray = gVector.elementData;
        if (this.elementCount != gVector.elementCount) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != vector's size:" + gVector.elementCount);
        }
        for (int i = 0; i < this.elementCount; ++i) {
            int n = i;
            this.elementData[n] = this.elementData[n] - dArray[i];
        }
    }

    public final void sub(GVector gVector, GVector gVector2) {
        this.set(gVector);
        this.sub(gVector2);
    }

    public final void mul(GMatrix gMatrix, GVector gVector) {
        double[] dArray = gVector.elementData;
        int n = gVector.elementCount;
        int n2 = gMatrix.getNumCol();
        int n3 = gMatrix.getNumRow();
        if (n != n2) {
            throw new IllegalArgumentException("v1.size:" + n + " != m1.nCol:" + n2);
        }
        if (this.elementCount != n3) {
            throw new IllegalArgumentException("this.size:" + this.elementCount + " != m1.nRow:" + n3);
        }
        for (int i = 0; i < this.elementCount; ++i) {
            double d = 0.0;
            for (int j = 0; j < n2; ++j) {
                d += gMatrix.getElement(i, j) * dArray[j];
            }
            this.elementData[i] = d;
        }
    }

    public final void mul(GVector gVector, GMatrix gMatrix) {
        double[] dArray = gVector.elementData;
        int n = gVector.elementCount;
        int n2 = gMatrix.getNumCol();
        int n3 = gMatrix.getNumRow();
        if (n != n3) {
            throw new IllegalArgumentException("v1.size:" + n + " != m1.nRow:" + n3);
        }
        if (this.elementCount != n2) {
            throw new IllegalArgumentException("this.size:" + this.elementCount + " != m1.nCol:" + n2);
        }
        for (int i = 0; i < this.elementCount; ++i) {
            double d = 0.0;
            for (int j = 0; j < n3; ++j) {
                d += gMatrix.getElement(j, i) * dArray[j];
            }
            this.elementData[i] = d;
        }
    }

    public final void negate() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = -this.elementData[i];
        }
    }

    public final void zero() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = 0.0;
        }
    }

    public final void setSize(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("newSize:" + n + " < 0");
        }
        if (this.elementCount < n) {
            double[] dArray = this.elementData;
            this.elementData = new double[n];
            System.arraycopy(dArray, 0, this.elementData, 0, this.elementCount);
        }
        this.elementCount = n;
    }

    public final void set(double[] dArray) {
        System.arraycopy(dArray, 0, this.elementData, 0, this.elementCount);
    }

    public final void set(GVector gVector) {
        System.arraycopy(gVector.elementData, 0, this.elementData, 0, this.elementCount);
    }

    public final void set(Tuple2f tuple2f) {
        this.elementData[0] = tuple2f.x;
        this.elementData[1] = tuple2f.y;
    }

    public final void set(Tuple3f tuple3f) {
        this.elementData[0] = tuple3f.x;
        this.elementData[1] = tuple3f.y;
        this.elementData[2] = tuple3f.z;
    }

    public final void set(Tuple3d tuple3d) {
        this.elementData[0] = tuple3d.x;
        this.elementData[1] = tuple3d.y;
        this.elementData[2] = tuple3d.z;
    }

    public final void set(Tuple4f tuple4f) {
        this.elementData[0] = tuple4f.x;
        this.elementData[1] = tuple4f.y;
        this.elementData[2] = tuple4f.z;
        this.elementData[3] = tuple4f.w;
    }

    public final void set(Tuple4d tuple4d) {
        this.elementData[0] = tuple4d.x;
        this.elementData[1] = tuple4d.y;
        this.elementData[2] = tuple4d.z;
        this.elementData[3] = tuple4d.w;
    }

    public final int getSize() {
        return this.elementCount;
    }

    public final double getElement(int n) {
        try {
            return this.elementData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("index:" + n + "must be in [0, " + (this.elementCount - 1) + "]");
        }
    }

    public final void setElement(int n, double d) {
        try {
            this.elementData[n] = d;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("index:" + n + " must be in [0, " + (this.elementCount - 1) + "]");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i = 0; i < this.elementCount - 1; ++i) {
            stringBuffer.append(this.elementData[i]);
            stringBuffer.append(",");
        }
        stringBuffer.append(this.elementData[this.elementCount - 1]);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.elementCount; ++i) {
            long l = Double.doubleToLongBits(this.elementData[i]);
            n ^= (int)(l ^ l >> 32);
        }
        return n;
    }

    public boolean equals(GVector gVector) {
        if (gVector == null) {
            return false;
        }
        if (this.elementCount != gVector.elementCount) {
            return false;
        }
        double[] dArray = gVector.elementData;
        for (int i = 0; i < this.elementCount; ++i) {
            if (this.elementData[i] == dArray[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof GVector && this.equals((GVector)object);
    }

    public boolean epsilonEquals(GVector gVector, double d) {
        if (this.elementCount != gVector.elementCount) {
            return false;
        }
        double[] dArray = gVector.elementData;
        for (int i = 0; i < this.elementCount; ++i) {
            if (!(Math.abs(this.elementData[i] - dArray[i]) > d)) continue;
            return false;
        }
        return true;
    }

    public final double dot(GVector gVector) {
        double[] dArray = gVector.elementData;
        if (this.elementCount != gVector.elementCount) {
            throw new IllegalArgumentException("this.size:" + this.elementCount + " != v1.size:" + gVector.elementCount);
        }
        double d = 0.0;
        for (int i = 0; i < this.elementCount; ++i) {
            d += this.elementData[i] * dArray[i];
        }
        return d;
    }

    public final void SVDBackSolve(GMatrix gMatrix, GMatrix gMatrix2, GMatrix gMatrix3, GVector gVector) {
        double d;
        int n;
        if (this.elementCount != gMatrix.getNumRow() || this.elementCount != gMatrix.getNumCol()) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != U.nRow,nCol:" + gMatrix.getNumRow() + "," + gMatrix.getNumCol());
        }
        if (this.elementCount != gMatrix2.getNumRow()) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != W.nRow:" + gMatrix2.getNumRow());
        }
        if (gVector.elementCount != gMatrix2.getNumCol()) {
            throw new ArrayIndexOutOfBoundsException("b.size:" + gVector.elementCount + " != W.nCol:" + gMatrix2.getNumCol());
        }
        if (gVector.elementCount != gMatrix3.getNumRow() || gVector.elementCount != gMatrix3.getNumCol()) {
            throw new ArrayIndexOutOfBoundsException("b.size:" + this.elementCount + " != V.nRow,nCol:" + gMatrix3.getNumRow() + "," + gMatrix3.getNumCol());
        }
        int n2 = gMatrix.getNumRow();
        int n3 = gMatrix3.getNumRow();
        double[] dArray = new double[n3];
        for (n = 0; n < n3; ++n) {
            d = 0.0;
            double d2 = gMatrix2.getElement(n, n);
            if (d2 != 0.0) {
                for (int i = 0; i < n2; ++i) {
                    d += gMatrix.getElement(i, n) * gVector.elementData[i];
                }
                d /= d2;
            }
            dArray[n] = d;
        }
        for (n = 0; n < n3; ++n) {
            d = 0.0;
            for (int i = 0; i < n3; ++i) {
                d += gMatrix3.getElement(n, i) * dArray[i];
            }
            this.elementData[n] = d;
        }
    }

    public final void LUDBackSolve(GMatrix gMatrix, GVector gVector, GVector gVector2) {
        int n;
        double d;
        int n2;
        int n3;
        if (this.elementCount != gVector.elementCount) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != b.size:" + gVector.elementCount);
        }
        if (this.elementCount != gMatrix.getNumRow()) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != LU.nRow:" + gMatrix.getNumRow());
        }
        if (this.elementCount != gMatrix.getNumCol()) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != LU.nCol:" + gMatrix.getNumCol());
        }
        int n4 = this.elementCount;
        double[] dArray = gVector2.elementData;
        double[] dArray2 = this.elementData;
        double[] dArray3 = gVector.elementData;
        for (n3 = 0; n3 < n4; ++n3) {
            dArray2[n3] = dArray3[(int)dArray[n3]];
        }
        n3 = -1;
        for (n2 = 0; n2 < n4; ++n2) {
            d = dArray2[n2];
            if (0 <= n3) {
                for (n = n3; n <= n2 - 1; ++n) {
                    d -= gMatrix.getElement(n2, n) * dArray2[n];
                }
            } else if (d != 0.0) {
                n3 = n2;
            }
            dArray2[n2] = d;
        }
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            d = dArray2[n2];
            for (n = n2 + 1; n < n4; ++n) {
                d -= gMatrix.getElement(n2, n) * dArray2[n];
            }
            dArray2[n2] = d / gMatrix.getElement(n2, n2);
        }
    }

    public final double angle(GVector gVector) {
        return Math.acos(this.dot(gVector) / this.norm() / gVector.norm());
    }

    public final void interpolate(GVector gVector, GVector gVector2, float f) {
        this.interpolate(gVector, gVector2, (double)f);
    }

    public final void interpolate(GVector gVector, float f) {
        this.interpolate(gVector, (double)f);
    }

    public final void interpolate(GVector gVector, GVector gVector2, double d) {
        this.set(gVector);
        this.interpolate(gVector2, d);
    }

    public final void interpolate(GVector gVector, double d) {
        double[] dArray = gVector.elementData;
        if (this.elementCount != gVector.elementCount) {
            throw new IllegalArgumentException("this.size:" + this.elementCount + " != v1.size:" + gVector.elementCount);
        }
        double d2 = 1.0 - d;
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = d2 * this.elementData[i] + d * dArray[i];
        }
    }
}

