/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4d;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple4d;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Matrix4d
implements Serializable,
Cloneable {
    public double m00;
    public double m01;
    public double m02;
    public double m03;
    public double m10;
    public double m11;
    public double m12;
    public double m13;
    public double m20;
    public double m21;
    public double m22;
    public double m23;
    public double m30;
    public double m31;
    public double m32;
    public double m33;

    public Matrix4d(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16) {
        this.set(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15, d16);
    }

    public Matrix4d(double[] dArray) {
        this.set(dArray);
    }

    public Matrix4d(Quat4d quat4d, Vector3d vector3d, double d) {
        this.set(quat4d, vector3d, d);
    }

    public Matrix4d(Quat4f quat4f, Vector3d vector3d, double d) {
        this.set(quat4f, vector3d, d);
    }

    public Matrix4d(Matrix4d matrix4d) {
        this.set(matrix4d);
    }

    public Matrix4d(Matrix4f matrix4f) {
        this.set(matrix4f);
    }

    public Matrix4d(Matrix3f matrix3f, Vector3d vector3d, double d) {
        this.set(matrix3f);
        this.mulRotationScale(d);
        this.setTranslation(vector3d);
        this.m33 = 1.0;
    }

    public Matrix4d(Matrix3d matrix3d, Vector3d vector3d, double d) {
        this.set(matrix3d, vector3d, d);
    }

    public Matrix4d() {
        this.setZero();
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        return "[" + string + "  [" + this.m00 + "\t" + this.m01 + "\t" + this.m02 + "\t" + this.m03 + "]" + string + "  [" + this.m10 + "\t" + this.m11 + "\t" + this.m12 + "\t" + this.m13 + "]" + string + "  [" + this.m20 + "\t" + this.m21 + "\t" + this.m22 + "\t" + this.m23 + "]" + string + "  [" + this.m30 + "\t" + this.m31 + "\t" + this.m32 + "\t" + this.m33 + "] ]";
    }

    public final void setIdentity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setElement(int n, int n2, double d) {
        if (n == 0) {
            if (n2 == 0) {
                this.m00 = d;
                return;
            } else if (n2 == 1) {
                this.m01 = d;
                return;
            } else if (n2 == 2) {
                this.m02 = d;
                return;
            } else {
                if (n2 != 3) throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
                this.m03 = d;
            }
            return;
        } else if (n == 1) {
            if (n2 == 0) {
                this.m10 = d;
                return;
            } else if (n2 == 1) {
                this.m11 = d;
                return;
            } else if (n2 == 2) {
                this.m12 = d;
                return;
            } else {
                if (n2 != 3) throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
                this.m13 = d;
            }
            return;
        } else if (n == 2) {
            if (n2 == 0) {
                this.m20 = d;
                return;
            } else if (n2 == 1) {
                this.m21 = d;
                return;
            } else if (n2 == 2) {
                this.m22 = d;
                return;
            } else {
                if (n2 != 3) throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
                this.m23 = d;
            }
            return;
        } else {
            if (n != 3) throw new ArrayIndexOutOfBoundsException("row must be 0 to 2 and is " + n);
            if (n2 == 0) {
                this.m30 = d;
                return;
            } else if (n2 == 1) {
                this.m31 = d;
                return;
            } else if (n2 == 2) {
                this.m32 = d;
                return;
            } else {
                if (n2 != 3) throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
                this.m33 = d;
            }
        }
    }

    public final double getElement(int n, int n2) {
        if (n == 0) {
            if (n2 == 0) {
                return this.m00;
            }
            if (n2 == 1) {
                return this.m01;
            }
            if (n2 == 2) {
                return this.m02;
            }
            if (n2 == 3) {
                return this.m03;
            }
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
        }
        if (n == 1) {
            if (n2 == 0) {
                return this.m10;
            }
            if (n2 == 1) {
                return this.m11;
            }
            if (n2 == 2) {
                return this.m12;
            }
            if (n2 == 3) {
                return this.m13;
            }
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
        }
        if (n == 2) {
            if (n2 == 0) {
                return this.m20;
            }
            if (n2 == 1) {
                return this.m21;
            }
            if (n2 == 2) {
                return this.m22;
            }
            if (n2 == 3) {
                return this.m23;
            }
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
        }
        if (n == 3) {
            if (n2 == 0) {
                return this.m30;
            }
            if (n2 == 1) {
                return this.m31;
            }
            if (n2 == 2) {
                return this.m32;
            }
            if (n2 == 3) {
                return this.m33;
            }
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n2);
        }
        throw new ArrayIndexOutOfBoundsException("row must be 0 to 3 and is " + n);
    }

    public final List<Double> getElements() {
        ArrayList<Double> arrayList = new ArrayList<Double>(16);
        arrayList.add(this.m00);
        arrayList.add(this.m01);
        arrayList.add(this.m02);
        arrayList.add(this.m03);
        arrayList.add(this.m10);
        arrayList.add(this.m11);
        arrayList.add(this.m12);
        arrayList.add(this.m13);
        arrayList.add(this.m20);
        arrayList.add(this.m21);
        arrayList.add(this.m22);
        arrayList.add(this.m23);
        arrayList.add(this.m30);
        arrayList.add(this.m31);
        arrayList.add(this.m32);
        arrayList.add(this.m33);
        return arrayList;
    }

    public final void get(Matrix3d matrix3d) {
        this.SVD(matrix3d, null);
    }

    public final void get(Matrix3f matrix3f) {
        this.SVD(matrix3f);
    }

    public final double get(Matrix3d matrix3d, Vector3d vector3d) {
        this.get(vector3d);
        return this.SVD(matrix3d, null);
    }

    public final double get(Matrix3f matrix3f, Vector3d vector3d) {
        this.get(vector3d);
        return this.SVD(matrix3f);
    }

    public final void get(Quat4f quat4f) {
        quat4f.set(this);
        quat4f.normalize();
    }

    public final void get(Quat4d quat4d) {
        quat4d.set(this);
        quat4d.normalize();
    }

    public final void get(Vector3d vector3d) {
        vector3d.x = this.m03;
        vector3d.y = this.m13;
        vector3d.z = this.m23;
    }

    public final void getRotationScale(Matrix3f matrix3f) {
        matrix3f.m00 = (float)this.m00;
        matrix3f.m01 = (float)this.m01;
        matrix3f.m02 = (float)this.m02;
        matrix3f.m10 = (float)this.m10;
        matrix3f.m11 = (float)this.m11;
        matrix3f.m12 = (float)this.m12;
        matrix3f.m20 = (float)this.m20;
        matrix3f.m21 = (float)this.m21;
        matrix3f.m22 = (float)this.m22;
    }

    public final void getRotationScale(Matrix3d matrix3d) {
        matrix3d.m00 = this.m00;
        matrix3d.m01 = this.m01;
        matrix3d.m02 = this.m02;
        matrix3d.m10 = this.m10;
        matrix3d.m11 = this.m11;
        matrix3d.m12 = this.m12;
        matrix3d.m20 = this.m20;
        matrix3d.m21 = this.m21;
        matrix3d.m22 = this.m22;
    }

    public final double getScale() {
        return this.SVD(null);
    }

    public final void setRotationScale(Matrix3d matrix3d) {
        this.m00 = matrix3d.m00;
        this.m01 = matrix3d.m01;
        this.m02 = matrix3d.m02;
        this.m10 = matrix3d.m10;
        this.m11 = matrix3d.m11;
        this.m12 = matrix3d.m12;
        this.m20 = matrix3d.m20;
        this.m21 = matrix3d.m21;
        this.m22 = matrix3d.m22;
    }

    public final void setRotationScale(Matrix3f matrix3f) {
        this.m00 = matrix3f.m00;
        this.m01 = matrix3f.m01;
        this.m02 = matrix3f.m02;
        this.m10 = matrix3f.m10;
        this.m11 = matrix3f.m11;
        this.m12 = matrix3f.m12;
        this.m20 = matrix3f.m20;
        this.m21 = matrix3f.m21;
        this.m22 = matrix3f.m22;
    }

    public final void setScale(double d) {
        this.SVD(null, this);
        this.mulRotationScale(d);
    }

    public final void setRow(int n, double d, double d2, double d3, double d4) {
        if (n == 0) {
            this.m00 = d;
            this.m01 = d2;
            this.m02 = d3;
            this.m03 = d4;
        } else if (n == 1) {
            this.m10 = d;
            this.m11 = d2;
            this.m12 = d3;
            this.m13 = d4;
        } else if (n == 2) {
            this.m20 = d;
            this.m21 = d2;
            this.m22 = d3;
            this.m23 = d4;
        } else if (n == 3) {
            this.m30 = d;
            this.m31 = d2;
            this.m32 = d3;
            this.m33 = d4;
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 3 and is " + n);
        }
    }

    public final void setRow(int n, Vector4d vector4d) {
        if (n == 0) {
            this.m00 = vector4d.x;
            this.m01 = vector4d.y;
            this.m02 = vector4d.z;
            this.m03 = vector4d.w;
        } else if (n == 1) {
            this.m10 = vector4d.x;
            this.m11 = vector4d.y;
            this.m12 = vector4d.z;
            this.m13 = vector4d.w;
        } else if (n == 2) {
            this.m20 = vector4d.x;
            this.m21 = vector4d.y;
            this.m22 = vector4d.z;
            this.m23 = vector4d.w;
        } else if (n == 3) {
            this.m30 = vector4d.x;
            this.m31 = vector4d.y;
            this.m32 = vector4d.z;
            this.m33 = vector4d.w;
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 3 and is " + n);
        }
    }

    public final void setRow(int n, double[] dArray) {
        if (n == 0) {
            this.m00 = dArray[0];
            this.m01 = dArray[1];
            this.m02 = dArray[2];
            this.m03 = dArray[3];
        } else if (n == 1) {
            this.m10 = dArray[0];
            this.m11 = dArray[1];
            this.m12 = dArray[2];
            this.m13 = dArray[3];
        } else if (n == 2) {
            this.m20 = dArray[0];
            this.m21 = dArray[1];
            this.m22 = dArray[2];
            this.m23 = dArray[3];
        } else if (n == 3) {
            this.m30 = dArray[0];
            this.m31 = dArray[1];
            this.m32 = dArray[2];
            this.m33 = dArray[3];
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 3 and is " + n);
        }
    }

    public final void getRow(int n, Vector4d vector4d) {
        if (n == 0) {
            vector4d.x = this.m00;
            vector4d.y = this.m01;
            vector4d.z = this.m02;
            vector4d.w = this.m03;
        } else if (n == 1) {
            vector4d.x = this.m10;
            vector4d.y = this.m11;
            vector4d.z = this.m12;
            vector4d.w = this.m13;
        } else if (n == 2) {
            vector4d.x = this.m20;
            vector4d.y = this.m21;
            vector4d.z = this.m22;
            vector4d.w = this.m23;
        } else if (n == 3) {
            vector4d.x = this.m30;
            vector4d.y = this.m31;
            vector4d.z = this.m32;
            vector4d.w = this.m33;
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 3 and is " + n);
        }
    }

    public final void getRow(int n, double[] dArray) {
        if (n == 0) {
            dArray[0] = this.m00;
            dArray[1] = this.m01;
            dArray[2] = this.m02;
            dArray[3] = this.m03;
        } else if (n == 1) {
            dArray[0] = this.m10;
            dArray[1] = this.m11;
            dArray[2] = this.m12;
            dArray[3] = this.m13;
        } else if (n == 2) {
            dArray[0] = this.m20;
            dArray[1] = this.m21;
            dArray[2] = this.m22;
            dArray[3] = this.m23;
        } else if (n == 3) {
            dArray[0] = this.m30;
            dArray[1] = this.m31;
            dArray[2] = this.m32;
            dArray[3] = this.m33;
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 3 and is " + n);
        }
    }

    public final void setColumn(int n, double d, double d2, double d3, double d4) {
        if (n == 0) {
            this.m00 = d;
            this.m10 = d2;
            this.m20 = d3;
            this.m30 = d4;
        } else if (n == 1) {
            this.m01 = d;
            this.m11 = d2;
            this.m21 = d3;
            this.m31 = d4;
        } else if (n == 2) {
            this.m02 = d;
            this.m12 = d2;
            this.m22 = d3;
            this.m32 = d4;
        } else if (n == 3) {
            this.m03 = d;
            this.m13 = d2;
            this.m23 = d3;
            this.m33 = d4;
        } else {
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n);
        }
    }

    public final void setColumn(int n, Vector4d vector4d) {
        if (n == 0) {
            this.m00 = vector4d.x;
            this.m10 = vector4d.y;
            this.m20 = vector4d.z;
            this.m30 = vector4d.w;
        } else if (n == 1) {
            this.m01 = vector4d.x;
            this.m11 = vector4d.y;
            this.m21 = vector4d.z;
            this.m31 = vector4d.w;
        } else if (n == 2) {
            this.m02 = vector4d.x;
            this.m12 = vector4d.y;
            this.m22 = vector4d.z;
            this.m32 = vector4d.w;
        } else if (n == 3) {
            this.m03 = vector4d.x;
            this.m13 = vector4d.y;
            this.m23 = vector4d.z;
            this.m33 = vector4d.w;
        } else {
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n);
        }
    }

    public final void setColumn(int n, double[] dArray) {
        if (n == 0) {
            this.m00 = dArray[0];
            this.m10 = dArray[1];
            this.m20 = dArray[2];
            this.m30 = dArray[3];
        } else if (n == 1) {
            this.m01 = dArray[0];
            this.m11 = dArray[1];
            this.m21 = dArray[2];
            this.m31 = dArray[3];
        } else if (n == 2) {
            this.m02 = dArray[0];
            this.m12 = dArray[1];
            this.m22 = dArray[2];
            this.m32 = dArray[3];
        } else if (n == 3) {
            this.m03 = dArray[0];
            this.m13 = dArray[1];
            this.m23 = dArray[2];
            this.m33 = dArray[3];
        } else {
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n);
        }
    }

    public final void getColumn(int n, Vector4d vector4d) {
        if (n == 0) {
            vector4d.x = this.m00;
            vector4d.y = this.m10;
            vector4d.z = this.m20;
            vector4d.w = this.m30;
        } else if (n == 1) {
            vector4d.x = this.m01;
            vector4d.y = this.m11;
            vector4d.z = this.m21;
            vector4d.w = this.m31;
        } else if (n == 2) {
            vector4d.x = this.m02;
            vector4d.y = this.m12;
            vector4d.z = this.m22;
            vector4d.w = this.m32;
        } else if (n == 3) {
            vector4d.x = this.m03;
            vector4d.y = this.m13;
            vector4d.z = this.m23;
            vector4d.w = this.m33;
        } else {
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n);
        }
    }

    public final void getColumn(int n, double[] dArray) {
        if (n == 0) {
            dArray[0] = this.m00;
            dArray[1] = this.m10;
            dArray[2] = this.m20;
            dArray[3] = this.m30;
        } else if (n == 1) {
            dArray[0] = this.m01;
            dArray[1] = this.m11;
            dArray[2] = this.m21;
            dArray[3] = this.m31;
        } else if (n == 2) {
            dArray[0] = this.m02;
            dArray[1] = this.m12;
            dArray[2] = this.m22;
            dArray[3] = this.m32;
        } else if (n == 3) {
            dArray[0] = this.m03;
            dArray[1] = this.m13;
            dArray[2] = this.m23;
            dArray[3] = this.m33;
        } else {
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 3 and is " + n);
        }
    }

    public final void add(double d) {
        this.m00 += d;
        this.m01 += d;
        this.m02 += d;
        this.m03 += d;
        this.m10 += d;
        this.m11 += d;
        this.m12 += d;
        this.m13 += d;
        this.m20 += d;
        this.m21 += d;
        this.m22 += d;
        this.m23 += d;
        this.m30 += d;
        this.m31 += d;
        this.m32 += d;
        this.m33 += d;
    }

    public final void add(double d, Matrix4d matrix4d) {
        this.set(matrix4d);
        this.add(d);
    }

    public final void add(Matrix4d matrix4d, Matrix4d matrix4d2) {
        this.set(matrix4d.m00 + matrix4d2.m00, matrix4d.m01 + matrix4d2.m01, matrix4d.m02 + matrix4d2.m02, matrix4d.m03 + matrix4d2.m03, matrix4d.m10 + matrix4d2.m10, matrix4d.m11 + matrix4d2.m11, matrix4d.m12 + matrix4d2.m12, matrix4d.m13 + matrix4d2.m13, matrix4d.m20 + matrix4d2.m20, matrix4d.m21 + matrix4d2.m21, matrix4d.m22 + matrix4d2.m22, matrix4d.m23 + matrix4d2.m23, matrix4d.m30 + matrix4d2.m30, matrix4d.m31 + matrix4d2.m31, matrix4d.m32 + matrix4d2.m32, matrix4d.m33 + matrix4d2.m33);
    }

    public final void add(Matrix4d matrix4d) {
        this.m00 += matrix4d.m00;
        this.m01 += matrix4d.m01;
        this.m02 += matrix4d.m02;
        this.m03 += matrix4d.m03;
        this.m10 += matrix4d.m10;
        this.m11 += matrix4d.m11;
        this.m12 += matrix4d.m12;
        this.m13 += matrix4d.m13;
        this.m20 += matrix4d.m20;
        this.m21 += matrix4d.m21;
        this.m22 += matrix4d.m22;
        this.m23 += matrix4d.m23;
        this.m30 += matrix4d.m30;
        this.m31 += matrix4d.m31;
        this.m32 += matrix4d.m32;
        this.m33 += matrix4d.m33;
    }

    public final void sub(Matrix4d matrix4d, Matrix4d matrix4d2) {
        this.set(matrix4d.m00 - matrix4d2.m00, matrix4d.m01 - matrix4d2.m01, matrix4d.m02 - matrix4d2.m02, matrix4d.m03 - matrix4d2.m03, matrix4d.m10 - matrix4d2.m10, matrix4d.m11 - matrix4d2.m11, matrix4d.m12 - matrix4d2.m12, matrix4d.m13 - matrix4d2.m13, matrix4d.m20 - matrix4d2.m20, matrix4d.m21 - matrix4d2.m21, matrix4d.m22 - matrix4d2.m22, matrix4d.m23 - matrix4d2.m23, matrix4d.m30 - matrix4d2.m30, matrix4d.m31 - matrix4d2.m31, matrix4d.m32 - matrix4d2.m32, matrix4d.m33 - matrix4d2.m33);
    }

    public final void sub(Matrix4d matrix4d) {
        this.m00 -= matrix4d.m00;
        this.m01 -= matrix4d.m01;
        this.m02 -= matrix4d.m02;
        this.m03 -= matrix4d.m03;
        this.m10 -= matrix4d.m10;
        this.m11 -= matrix4d.m11;
        this.m12 -= matrix4d.m12;
        this.m13 -= matrix4d.m13;
        this.m20 -= matrix4d.m20;
        this.m21 -= matrix4d.m21;
        this.m22 -= matrix4d.m22;
        this.m23 -= matrix4d.m23;
        this.m30 -= matrix4d.m30;
        this.m31 -= matrix4d.m31;
        this.m32 -= matrix4d.m32;
        this.m33 -= matrix4d.m33;
    }

    public final void transpose() {
        double d = this.m01;
        this.m01 = this.m10;
        this.m10 = d;
        d = this.m02;
        this.m02 = this.m20;
        this.m20 = d;
        d = this.m03;
        this.m03 = this.m30;
        this.m30 = d;
        d = this.m12;
        this.m12 = this.m21;
        this.m21 = d;
        d = this.m13;
        this.m13 = this.m31;
        this.m31 = d;
        d = this.m23;
        this.m23 = this.m32;
        this.m32 = d;
    }

    public final void transpose(Matrix4d matrix4d) {
        this.set(matrix4d);
        this.transpose();
    }

    public final void set(double[] dArray) {
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m03 = dArray[3];
        this.m10 = dArray[4];
        this.m11 = dArray[5];
        this.m12 = dArray[6];
        this.m13 = dArray[7];
        this.m20 = dArray[8];
        this.m21 = dArray[9];
        this.m22 = dArray[10];
        this.m23 = dArray[11];
        this.m30 = dArray[12];
        this.m31 = dArray[13];
        this.m32 = dArray[14];
        this.m33 = dArray[15];
    }

    public final void set(Double[] doubleArray) {
        this.m00 = doubleArray[0];
        this.m01 = doubleArray[1];
        this.m02 = doubleArray[2];
        this.m03 = doubleArray[3];
        this.m10 = doubleArray[4];
        this.m11 = doubleArray[5];
        this.m12 = doubleArray[6];
        this.m13 = doubleArray[7];
        this.m20 = doubleArray[8];
        this.m21 = doubleArray[9];
        this.m22 = doubleArray[10];
        this.m23 = doubleArray[11];
        this.m30 = doubleArray[12];
        this.m31 = doubleArray[13];
        this.m32 = doubleArray[14];
        this.m33 = doubleArray[15];
    }

    public final void set(Matrix3f matrix3f) {
        this.m00 = matrix3f.m00;
        this.m01 = matrix3f.m01;
        this.m02 = matrix3f.m02;
        this.m03 = 0.0;
        this.m10 = matrix3f.m10;
        this.m11 = matrix3f.m11;
        this.m12 = matrix3f.m12;
        this.m13 = 0.0;
        this.m20 = matrix3f.m20;
        this.m21 = matrix3f.m21;
        this.m22 = matrix3f.m22;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void set(Matrix3d matrix3d) {
        this.m00 = matrix3d.m00;
        this.m01 = matrix3d.m01;
        this.m02 = matrix3d.m02;
        this.m03 = 0.0;
        this.m10 = matrix3d.m10;
        this.m11 = matrix3d.m11;
        this.m12 = matrix3d.m12;
        this.m13 = 0.0;
        this.m20 = matrix3d.m20;
        this.m21 = matrix3d.m21;
        this.m22 = matrix3d.m22;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void set(Quat4d quat4d) {
        this.setFromQuat(quat4d.x, quat4d.y, quat4d.z, quat4d.w);
    }

    public final void set(AxisAngle4d axisAngle4d) {
        this.setFromAxisAngle(axisAngle4d.x, axisAngle4d.y, axisAngle4d.z, axisAngle4d.angle);
    }

    public final void set(Quat4f quat4f) {
        this.setFromQuat(quat4f.x, quat4f.y, quat4f.z, quat4f.w);
    }

    public final void set(AxisAngle4f axisAngle4f) {
        this.setFromAxisAngle(axisAngle4f.x, axisAngle4f.y, axisAngle4f.z, axisAngle4f.angle);
    }

    public final void set(Quat4d quat4d, Vector3d vector3d, double d) {
        this.set(quat4d);
        this.mulRotationScale(d);
        this.m03 = vector3d.x;
        this.m13 = vector3d.y;
        this.m23 = vector3d.z;
    }

    public final void set(Quat4f quat4f, Vector3d vector3d, double d) {
        this.set(quat4f);
        this.mulRotationScale(d);
        this.m03 = vector3d.x;
        this.m13 = vector3d.y;
        this.m23 = vector3d.z;
    }

    public final void set(Quat4f quat4f, Vector3f vector3f, float f) {
        this.set(quat4f);
        this.mulRotationScale(f);
        this.m03 = vector3f.x;
        this.m13 = vector3f.y;
        this.m23 = vector3f.z;
    }

    public final void set(Matrix4d matrix4d) {
        this.m00 = matrix4d.m00;
        this.m01 = matrix4d.m01;
        this.m02 = matrix4d.m02;
        this.m03 = matrix4d.m03;
        this.m10 = matrix4d.m10;
        this.m11 = matrix4d.m11;
        this.m12 = matrix4d.m12;
        this.m13 = matrix4d.m13;
        this.m20 = matrix4d.m20;
        this.m21 = matrix4d.m21;
        this.m22 = matrix4d.m22;
        this.m23 = matrix4d.m23;
        this.m30 = matrix4d.m30;
        this.m31 = matrix4d.m31;
        this.m32 = matrix4d.m32;
        this.m33 = matrix4d.m33;
    }

    public final void set(Matrix4f matrix4f) {
        this.m00 = matrix4f.m00;
        this.m01 = matrix4f.m01;
        this.m02 = matrix4f.m02;
        this.m03 = matrix4f.m03;
        this.m10 = matrix4f.m10;
        this.m11 = matrix4f.m11;
        this.m12 = matrix4f.m12;
        this.m13 = matrix4f.m13;
        this.m20 = matrix4f.m20;
        this.m21 = matrix4f.m21;
        this.m22 = matrix4f.m22;
        this.m23 = matrix4f.m23;
        this.m30 = matrix4f.m30;
        this.m31 = matrix4f.m31;
        this.m32 = matrix4f.m32;
        this.m33 = matrix4f.m33;
    }

    public final void invert(Matrix4d matrix4d) {
        this.set(matrix4d);
        this.invert();
    }

    public final void invert() {
        double d = this.determinant();
        if (d == 0.0) {
            return;
        }
        d = 1.0 / d;
        this.set(this.m11 * (this.m22 * this.m33 - this.m23 * this.m32) + this.m12 * (this.m23 * this.m31 - this.m21 * this.m33) + this.m13 * (this.m21 * this.m32 - this.m22 * this.m31), this.m21 * (this.m02 * this.m33 - this.m03 * this.m32) + this.m22 * (this.m03 * this.m31 - this.m01 * this.m33) + this.m23 * (this.m01 * this.m32 - this.m02 * this.m31), this.m31 * (this.m02 * this.m13 - this.m03 * this.m12) + this.m32 * (this.m03 * this.m11 - this.m01 * this.m13) + this.m33 * (this.m01 * this.m12 - this.m02 * this.m11), this.m01 * (this.m13 * this.m22 - this.m12 * this.m23) + this.m02 * (this.m11 * this.m23 - this.m13 * this.m21) + this.m03 * (this.m12 * this.m21 - this.m11 * this.m22), this.m12 * (this.m20 * this.m33 - this.m23 * this.m30) + this.m13 * (this.m22 * this.m30 - this.m20 * this.m32) + this.m10 * (this.m23 * this.m32 - this.m22 * this.m33), this.m22 * (this.m00 * this.m33 - this.m03 * this.m30) + this.m23 * (this.m02 * this.m30 - this.m00 * this.m32) + this.m20 * (this.m03 * this.m32 - this.m02 * this.m33), this.m32 * (this.m00 * this.m13 - this.m03 * this.m10) + this.m33 * (this.m02 * this.m10 - this.m00 * this.m12) + this.m30 * (this.m03 * this.m12 - this.m02 * this.m13), this.m02 * (this.m13 * this.m20 - this.m10 * this.m23) + this.m03 * (this.m10 * this.m22 - this.m12 * this.m20) + this.m00 * (this.m12 * this.m23 - this.m13 * this.m22), this.m13 * (this.m20 * this.m31 - this.m21 * this.m30) + this.m10 * (this.m21 * this.m33 - this.m23 * this.m31) + this.m11 * (this.m23 * this.m30 - this.m20 * this.m33), this.m23 * (this.m00 * this.m31 - this.m01 * this.m30) + this.m20 * (this.m01 * this.m33 - this.m03 * this.m31) + this.m21 * (this.m03 * this.m30 - this.m00 * this.m33), this.m33 * (this.m00 * this.m11 - this.m01 * this.m10) + this.m30 * (this.m01 * this.m13 - this.m03 * this.m11) + this.m31 * (this.m03 * this.m10 - this.m00 * this.m13), this.m03 * (this.m11 * this.m20 - this.m10 * this.m21) + this.m00 * (this.m13 * this.m21 - this.m11 * this.m23) + this.m01 * (this.m10 * this.m23 - this.m13 * this.m20), this.m10 * (this.m22 * this.m31 - this.m21 * this.m32) + this.m11 * (this.m20 * this.m32 - this.m22 * this.m30) + this.m12 * (this.m21 * this.m30 - this.m20 * this.m31), this.m20 * (this.m02 * this.m31 - this.m01 * this.m32) + this.m21 * (this.m00 * this.m32 - this.m02 * this.m30) + this.m22 * (this.m01 * this.m30 - this.m00 * this.m31), this.m30 * (this.m02 * this.m11 - this.m01 * this.m12) + this.m31 * (this.m00 * this.m12 - this.m02 * this.m10) + this.m32 * (this.m01 * this.m10 - this.m00 * this.m11), this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) + this.m01 * (this.m12 * this.m20 - this.m10 * this.m22) + this.m02 * (this.m10 * this.m21 - this.m11 * this.m20));
        this.mul(d);
    }

    public final double determinant() {
        return (this.m00 * this.m11 - this.m01 * this.m10) * (this.m22 * this.m33 - this.m23 * this.m32) - (this.m00 * this.m12 - this.m02 * this.m10) * (this.m21 * this.m33 - this.m23 * this.m31) + (this.m00 * this.m13 - this.m03 * this.m10) * (this.m21 * this.m32 - this.m22 * this.m31) + (this.m01 * this.m12 - this.m02 * this.m11) * (this.m20 * this.m33 - this.m23 * this.m30) - (this.m01 * this.m13 - this.m03 * this.m11) * (this.m20 * this.m32 - this.m22 * this.m30) + (this.m02 * this.m13 - this.m03 * this.m12) * (this.m20 * this.m31 - this.m21 * this.m30);
    }

    public final void set(double d) {
        this.m00 = d;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = d;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = d;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void set(Vector3d vector3d) {
        this.setIdentity();
        this.setTranslation(vector3d);
    }

    public final void set(double d, Vector3d vector3d) {
        this.set(d);
        this.setTranslation(vector3d);
    }

    public final void set(Vector3d vector3d, double d) {
        this.m00 = d;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = d * vector3d.x;
        this.m10 = 0.0;
        this.m11 = d;
        this.m12 = 0.0;
        this.m13 = d * vector3d.y;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = d;
        this.m23 = d * vector3d.z;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void set(Matrix3f matrix3f, Vector3f vector3f, float f) {
        this.setRotationScale(matrix3f);
        this.mulRotationScale(f);
        this.setTranslation(vector3f);
        this.m33 = 1.0;
    }

    public final void set(Matrix3d matrix3d, Vector3d vector3d, double d) {
        this.setRotationScale(matrix3d);
        this.mulRotationScale(d);
        this.setTranslation(vector3d);
        this.m33 = 1.0;
    }

    public final void setTranslation(Vector3d vector3d) {
        this.m03 = vector3d.x;
        this.m13 = vector3d.y;
        this.m23 = vector3d.z;
    }

    public final void rotX(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = d2;
        this.m12 = -d3;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = d3;
        this.m22 = d2;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void rotY(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.m00 = d2;
        this.m01 = 0.0;
        this.m02 = d3;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = -d3;
        this.m21 = 0.0;
        this.m22 = d2;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void rotZ(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.m00 = d2;
        this.m01 = -d3;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = d3;
        this.m11 = d2;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void mul(double d) {
        this.m00 *= d;
        this.m01 *= d;
        this.m02 *= d;
        this.m03 *= d;
        this.m10 *= d;
        this.m11 *= d;
        this.m12 *= d;
        this.m13 *= d;
        this.m20 *= d;
        this.m21 *= d;
        this.m22 *= d;
        this.m23 *= d;
        this.m30 *= d;
        this.m31 *= d;
        this.m32 *= d;
        this.m33 *= d;
    }

    public final void mul(double d, Matrix4d matrix4d) {
        this.set(matrix4d);
        this.mul(d);
    }

    public final void mul(Matrix4d matrix4d) {
        this.mul(this, matrix4d);
    }

    public final void mul(Matrix4d matrix4d, Matrix4d matrix4d2) {
        this.set(matrix4d.m00 * matrix4d2.m00 + matrix4d.m01 * matrix4d2.m10 + matrix4d.m02 * matrix4d2.m20 + matrix4d.m03 * matrix4d2.m30, matrix4d.m00 * matrix4d2.m01 + matrix4d.m01 * matrix4d2.m11 + matrix4d.m02 * matrix4d2.m21 + matrix4d.m03 * matrix4d2.m31, matrix4d.m00 * matrix4d2.m02 + matrix4d.m01 * matrix4d2.m12 + matrix4d.m02 * matrix4d2.m22 + matrix4d.m03 * matrix4d2.m32, matrix4d.m00 * matrix4d2.m03 + matrix4d.m01 * matrix4d2.m13 + matrix4d.m02 * matrix4d2.m23 + matrix4d.m03 * matrix4d2.m33, matrix4d.m10 * matrix4d2.m00 + matrix4d.m11 * matrix4d2.m10 + matrix4d.m12 * matrix4d2.m20 + matrix4d.m13 * matrix4d2.m30, matrix4d.m10 * matrix4d2.m01 + matrix4d.m11 * matrix4d2.m11 + matrix4d.m12 * matrix4d2.m21 + matrix4d.m13 * matrix4d2.m31, matrix4d.m10 * matrix4d2.m02 + matrix4d.m11 * matrix4d2.m12 + matrix4d.m12 * matrix4d2.m22 + matrix4d.m13 * matrix4d2.m32, matrix4d.m10 * matrix4d2.m03 + matrix4d.m11 * matrix4d2.m13 + matrix4d.m12 * matrix4d2.m23 + matrix4d.m13 * matrix4d2.m33, matrix4d.m20 * matrix4d2.m00 + matrix4d.m21 * matrix4d2.m10 + matrix4d.m22 * matrix4d2.m20 + matrix4d.m23 * matrix4d2.m30, matrix4d.m20 * matrix4d2.m01 + matrix4d.m21 * matrix4d2.m11 + matrix4d.m22 * matrix4d2.m21 + matrix4d.m23 * matrix4d2.m31, matrix4d.m20 * matrix4d2.m02 + matrix4d.m21 * matrix4d2.m12 + matrix4d.m22 * matrix4d2.m22 + matrix4d.m23 * matrix4d2.m32, matrix4d.m20 * matrix4d2.m03 + matrix4d.m21 * matrix4d2.m13 + matrix4d.m22 * matrix4d2.m23 + matrix4d.m23 * matrix4d2.m33, matrix4d.m30 * matrix4d2.m00 + matrix4d.m31 * matrix4d2.m10 + matrix4d.m32 * matrix4d2.m20 + matrix4d.m33 * matrix4d2.m30, matrix4d.m30 * matrix4d2.m01 + matrix4d.m31 * matrix4d2.m11 + matrix4d.m32 * matrix4d2.m21 + matrix4d.m33 * matrix4d2.m31, matrix4d.m30 * matrix4d2.m02 + matrix4d.m31 * matrix4d2.m12 + matrix4d.m32 * matrix4d2.m22 + matrix4d.m33 * matrix4d2.m32, matrix4d.m30 * matrix4d2.m03 + matrix4d.m31 * matrix4d2.m13 + matrix4d.m32 * matrix4d2.m23 + matrix4d.m33 * matrix4d2.m33);
    }

    public final void mulTransposeBoth(Matrix4d matrix4d, Matrix4d matrix4d2) {
        this.mul(matrix4d2, matrix4d);
        this.transpose();
    }

    public final void mulTransposeRight(Matrix4d matrix4d, Matrix4d matrix4d2) {
        this.set(matrix4d.m00 * matrix4d2.m00 + matrix4d.m01 * matrix4d2.m01 + matrix4d.m02 * matrix4d2.m02 + matrix4d.m03 * matrix4d2.m03, matrix4d.m00 * matrix4d2.m10 + matrix4d.m01 * matrix4d2.m11 + matrix4d.m02 * matrix4d2.m12 + matrix4d.m03 * matrix4d2.m13, matrix4d.m00 * matrix4d2.m20 + matrix4d.m01 * matrix4d2.m21 + matrix4d.m02 * matrix4d2.m22 + matrix4d.m03 * matrix4d2.m23, matrix4d.m00 * matrix4d2.m30 + matrix4d.m01 * matrix4d2.m31 + matrix4d.m02 * matrix4d2.m32 + matrix4d.m03 * matrix4d2.m33, matrix4d.m10 * matrix4d2.m00 + matrix4d.m11 * matrix4d2.m01 + matrix4d.m12 * matrix4d2.m02 + matrix4d.m13 * matrix4d2.m03, matrix4d.m10 * matrix4d2.m10 + matrix4d.m11 * matrix4d2.m11 + matrix4d.m12 * matrix4d2.m12 + matrix4d.m13 * matrix4d2.m13, matrix4d.m10 * matrix4d2.m20 + matrix4d.m11 * matrix4d2.m21 + matrix4d.m12 * matrix4d2.m22 + matrix4d.m13 * matrix4d2.m23, matrix4d.m10 * matrix4d2.m30 + matrix4d.m11 * matrix4d2.m31 + matrix4d.m12 * matrix4d2.m32 + matrix4d.m13 * matrix4d2.m33, matrix4d.m20 * matrix4d2.m00 + matrix4d.m21 * matrix4d2.m01 + matrix4d.m22 * matrix4d2.m02 + matrix4d.m23 * matrix4d2.m03, matrix4d.m20 * matrix4d2.m10 + matrix4d.m21 * matrix4d2.m11 + matrix4d.m22 * matrix4d2.m12 + matrix4d.m23 * matrix4d2.m13, matrix4d.m20 * matrix4d2.m20 + matrix4d.m21 * matrix4d2.m21 + matrix4d.m22 * matrix4d2.m22 + matrix4d.m23 * matrix4d2.m23, matrix4d.m20 * matrix4d2.m30 + matrix4d.m21 * matrix4d2.m31 + matrix4d.m22 * matrix4d2.m32 + matrix4d.m23 * matrix4d2.m33, matrix4d.m30 * matrix4d2.m00 + matrix4d.m31 * matrix4d2.m01 + matrix4d.m32 * matrix4d2.m02 + matrix4d.m33 * matrix4d2.m03, matrix4d.m30 * matrix4d2.m10 + matrix4d.m31 * matrix4d2.m11 + matrix4d.m32 * matrix4d2.m12 + matrix4d.m33 * matrix4d2.m13, matrix4d.m30 * matrix4d2.m20 + matrix4d.m31 * matrix4d2.m21 + matrix4d.m32 * matrix4d2.m22 + matrix4d.m33 * matrix4d2.m23, matrix4d.m30 * matrix4d2.m30 + matrix4d.m31 * matrix4d2.m31 + matrix4d.m32 * matrix4d2.m32 + matrix4d.m33 * matrix4d2.m33);
    }

    public final void mulTransposeLeft(Matrix4d matrix4d, Matrix4d matrix4d2) {
        this.set(matrix4d.m00 * matrix4d2.m00 + matrix4d.m10 * matrix4d2.m10 + matrix4d.m20 * matrix4d2.m20 + matrix4d.m30 * matrix4d2.m30, matrix4d.m00 * matrix4d2.m01 + matrix4d.m10 * matrix4d2.m11 + matrix4d.m20 * matrix4d2.m21 + matrix4d.m30 * matrix4d2.m31, matrix4d.m00 * matrix4d2.m02 + matrix4d.m10 * matrix4d2.m12 + matrix4d.m20 * matrix4d2.m22 + matrix4d.m30 * matrix4d2.m32, matrix4d.m00 * matrix4d2.m03 + matrix4d.m10 * matrix4d2.m13 + matrix4d.m20 * matrix4d2.m23 + matrix4d.m30 * matrix4d2.m33, matrix4d.m01 * matrix4d2.m00 + matrix4d.m11 * matrix4d2.m10 + matrix4d.m21 * matrix4d2.m20 + matrix4d.m31 * matrix4d2.m30, matrix4d.m01 * matrix4d2.m01 + matrix4d.m11 * matrix4d2.m11 + matrix4d.m21 * matrix4d2.m21 + matrix4d.m31 * matrix4d2.m31, matrix4d.m01 * matrix4d2.m02 + matrix4d.m11 * matrix4d2.m12 + matrix4d.m21 * matrix4d2.m22 + matrix4d.m31 * matrix4d2.m32, matrix4d.m01 * matrix4d2.m03 + matrix4d.m11 * matrix4d2.m13 + matrix4d.m21 * matrix4d2.m23 + matrix4d.m31 * matrix4d2.m33, matrix4d.m02 * matrix4d2.m00 + matrix4d.m12 * matrix4d2.m10 + matrix4d.m22 * matrix4d2.m20 + matrix4d.m32 * matrix4d2.m30, matrix4d.m02 * matrix4d2.m01 + matrix4d.m12 * matrix4d2.m11 + matrix4d.m22 * matrix4d2.m21 + matrix4d.m32 * matrix4d2.m31, matrix4d.m02 * matrix4d2.m02 + matrix4d.m12 * matrix4d2.m12 + matrix4d.m22 * matrix4d2.m22 + matrix4d.m32 * matrix4d2.m32, matrix4d.m02 * matrix4d2.m03 + matrix4d.m12 * matrix4d2.m13 + matrix4d.m22 * matrix4d2.m23 + matrix4d.m32 * matrix4d2.m33, matrix4d.m03 * matrix4d2.m00 + matrix4d.m13 * matrix4d2.m10 + matrix4d.m23 * matrix4d2.m20 + matrix4d.m33 * matrix4d2.m30, matrix4d.m03 * matrix4d2.m01 + matrix4d.m13 * matrix4d2.m11 + matrix4d.m23 * matrix4d2.m21 + matrix4d.m33 * matrix4d2.m31, matrix4d.m03 * matrix4d2.m02 + matrix4d.m13 * matrix4d2.m12 + matrix4d.m23 * matrix4d2.m22 + matrix4d.m33 * matrix4d2.m32, matrix4d.m03 * matrix4d2.m03 + matrix4d.m13 * matrix4d2.m13 + matrix4d.m23 * matrix4d2.m23 + matrix4d.m33 * matrix4d2.m33);
    }

    public boolean equals(Matrix4d matrix4d) {
        return matrix4d != null && this.m00 == matrix4d.m00 && this.m01 == matrix4d.m01 && this.m02 == matrix4d.m02 && this.m03 == matrix4d.m03 && this.m10 == matrix4d.m10 && this.m11 == matrix4d.m11 && this.m12 == matrix4d.m12 && this.m13 == matrix4d.m13 && this.m20 == matrix4d.m20 && this.m21 == matrix4d.m21 && this.m22 == matrix4d.m22 && this.m23 == matrix4d.m23 && this.m30 == matrix4d.m30 && this.m31 == matrix4d.m31 && this.m32 == matrix4d.m32 && this.m33 == matrix4d.m33;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Matrix4d && this.equals((Matrix4d)object);
    }

    public boolean epsilonEquals(Matrix4d matrix4d, float f) {
        return Math.abs(this.m00 - matrix4d.m00) <= (double)f && Math.abs(this.m01 - matrix4d.m01) <= (double)f && Math.abs(this.m02 - matrix4d.m02) <= (double)f && Math.abs(this.m03 - matrix4d.m03) <= (double)f && Math.abs(this.m10 - matrix4d.m10) <= (double)f && Math.abs(this.m11 - matrix4d.m11) <= (double)f && Math.abs(this.m12 - matrix4d.m12) <= (double)f && Math.abs(this.m13 - matrix4d.m13) <= (double)f && Math.abs(this.m20 - matrix4d.m20) <= (double)f && Math.abs(this.m21 - matrix4d.m21) <= (double)f && Math.abs(this.m22 - matrix4d.m22) <= (double)f && Math.abs(this.m23 - matrix4d.m23) <= (double)f && Math.abs(this.m30 - matrix4d.m30) <= (double)f && Math.abs(this.m31 - matrix4d.m31) <= (double)f && Math.abs(this.m32 - matrix4d.m32) <= (double)f && Math.abs(this.m33 - matrix4d.m33) <= (double)f;
    }

    public boolean epsilonEquals(Matrix4d matrix4d, double d) {
        return Math.abs(this.m00 - matrix4d.m00) <= d && Math.abs(this.m01 - matrix4d.m01) <= d && Math.abs(this.m02 - matrix4d.m02) <= d && Math.abs(this.m03 - matrix4d.m03) <= d && Math.abs(this.m10 - matrix4d.m10) <= d && Math.abs(this.m11 - matrix4d.m11) <= d && Math.abs(this.m12 - matrix4d.m12) <= d && Math.abs(this.m13 - matrix4d.m13) <= d && Math.abs(this.m20 - matrix4d.m20) <= d && Math.abs(this.m21 - matrix4d.m21) <= d && Math.abs(this.m22 - matrix4d.m22) <= d && Math.abs(this.m23 - matrix4d.m23) <= d && Math.abs(this.m30 - matrix4d.m30) <= d && Math.abs(this.m31 - matrix4d.m31) <= d && Math.abs(this.m32 - matrix4d.m32) <= d && Math.abs(this.m33 - matrix4d.m33) <= d;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.m00);
        int n = (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m01);
        n ^= (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m02);
        n ^= (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m03);
        n ^= (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m10);
        n ^= (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m11);
        n ^= (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m12);
        n ^= (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m13);
        n ^= (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m20);
        n ^= (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m21);
        n ^= (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m22);
        n ^= (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m23);
        n ^= (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m30);
        n ^= (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m31);
        n ^= (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m32);
        n ^= (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m33);
        return n ^= (int)(l ^ l >> 32);
    }

    public final void transform(Tuple4d tuple4d, Tuple4d tuple4d2) {
        tuple4d2.set(this.m00 * tuple4d.x + this.m01 * tuple4d.y + this.m02 * tuple4d.z + this.m03 * tuple4d.w, this.m10 * tuple4d.x + this.m11 * tuple4d.y + this.m12 * tuple4d.z + this.m13 * tuple4d.w, this.m20 * tuple4d.x + this.m21 * tuple4d.y + this.m22 * tuple4d.z + this.m23 * tuple4d.w, this.m30 * tuple4d.x + this.m31 * tuple4d.y + this.m32 * tuple4d.z + this.m33 * tuple4d.w);
    }

    public final void transform(Tuple4d tuple4d) {
        this.transform(tuple4d, tuple4d);
    }

    public final void transform(Tuple4f tuple4f, Tuple4f tuple4f2) {
        tuple4f2.set((float)(this.m00 * (double)tuple4f.x + this.m01 * (double)tuple4f.y + this.m02 * (double)tuple4f.z + this.m03 * (double)tuple4f.w), (float)(this.m10 * (double)tuple4f.x + this.m11 * (double)tuple4f.y + this.m12 * (double)tuple4f.z + this.m13 * (double)tuple4f.w), (float)(this.m20 * (double)tuple4f.x + this.m21 * (double)tuple4f.y + this.m22 * (double)tuple4f.z + this.m23 * (double)tuple4f.w), (float)(this.m30 * (double)tuple4f.x + this.m31 * (double)tuple4f.y + this.m32 * (double)tuple4f.z + this.m33 * (double)tuple4f.w));
    }

    public final void transform(Tuple4f tuple4f) {
        this.transform(tuple4f, tuple4f);
    }

    public final void transform(Point3d point3d, Point3d point3d2) {
        point3d2.set(this.m00 * point3d.x + this.m01 * point3d.y + this.m02 * point3d.z + this.m03, this.m10 * point3d.x + this.m11 * point3d.y + this.m12 * point3d.z + this.m13, this.m20 * point3d.x + this.m21 * point3d.y + this.m22 * point3d.z + this.m23);
    }

    public final void transform(Point3d point3d) {
        this.transform(point3d, point3d);
    }

    public final void transform(Point3f point3f, Point3f point3f2) {
        point3f2.set((float)(this.m00 * (double)point3f.x + this.m01 * (double)point3f.y + this.m02 * (double)point3f.z + this.m03), (float)(this.m10 * (double)point3f.x + this.m11 * (double)point3f.y + this.m12 * (double)point3f.z + this.m13), (float)(this.m20 * (double)point3f.x + this.m21 * (double)point3f.y + this.m22 * (double)point3f.z + this.m23));
    }

    public final void transform(Point3f point3f) {
        this.transform(point3f, point3f);
    }

    public final void transform(Vector3d vector3d, Vector3d vector3d2) {
        vector3d2.set(this.m00 * vector3d.x + this.m01 * vector3d.y + this.m02 * vector3d.z, this.m10 * vector3d.x + this.m11 * vector3d.y + this.m12 * vector3d.z, this.m20 * vector3d.x + this.m21 * vector3d.y + this.m22 * vector3d.z);
    }

    public final void transform(Vector3d vector3d) {
        this.transform(vector3d, vector3d);
    }

    public final void transform(Vector3f vector3f, Vector3f vector3f2) {
        vector3f2.set((float)(this.m00 * (double)vector3f.x + this.m01 * (double)vector3f.y + this.m02 * (double)vector3f.z), (float)(this.m10 * (double)vector3f.x + this.m11 * (double)vector3f.y + this.m12 * (double)vector3f.z), (float)(this.m20 * (double)vector3f.x + this.m21 * (double)vector3f.y + this.m22 * (double)vector3f.z));
    }

    public final void transform(Vector3f vector3f) {
        this.transform(vector3f, vector3f);
    }

    public final void setRotation(Matrix3d matrix3d) {
        double d = this.SVD(null, null);
        this.setRotationScale(matrix3d);
        this.mulRotationScale(d);
    }

    public final void setRotation(Matrix3f matrix3f) {
        double d = this.SVD(null, null);
        this.setRotationScale(matrix3f);
        this.mulRotationScale(d);
    }

    public final void setRotation(Quat4f quat4f) {
        double d = this.SVD(null, null);
        double d2 = this.m03;
        double d3 = this.m13;
        double d4 = this.m23;
        double d5 = this.m30;
        double d6 = this.m31;
        double d7 = this.m32;
        double d8 = this.m33;
        this.set(quat4f);
        this.mulRotationScale(d);
        this.m03 = d2;
        this.m13 = d3;
        this.m23 = d4;
        this.m30 = d5;
        this.m31 = d6;
        this.m32 = d7;
        this.m33 = d8;
    }

    public final void setRotation(Quat4d quat4d) {
        double d = this.SVD(null, null);
        double d2 = this.m03;
        double d3 = this.m13;
        double d4 = this.m23;
        double d5 = this.m30;
        double d6 = this.m31;
        double d7 = this.m32;
        double d8 = this.m33;
        this.set(quat4d);
        this.mulRotationScale(d);
        this.m03 = d2;
        this.m13 = d3;
        this.m23 = d4;
        this.m30 = d5;
        this.m31 = d6;
        this.m32 = d7;
        this.m33 = d8;
    }

    public final void setRotation(AxisAngle4d axisAngle4d) {
        double d = this.SVD(null, null);
        double d2 = this.m03;
        double d3 = this.m13;
        double d4 = this.m23;
        double d5 = this.m30;
        double d6 = this.m31;
        double d7 = this.m32;
        double d8 = this.m33;
        this.set(axisAngle4d);
        this.mulRotationScale(d);
        this.m03 = d2;
        this.m13 = d3;
        this.m23 = d4;
        this.m30 = d5;
        this.m31 = d6;
        this.m32 = d7;
        this.m33 = d8;
    }

    public final void setZero() {
        this.m00 = 0.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 0.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 0.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 0.0;
    }

    public final void negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m02 = -this.m02;
        this.m03 = -this.m03;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
        this.m12 = -this.m12;
        this.m13 = -this.m13;
        this.m20 = -this.m20;
        this.m21 = -this.m21;
        this.m22 = -this.m22;
        this.m23 = -this.m23;
        this.m30 = -this.m30;
        this.m31 = -this.m31;
        this.m32 = -this.m32;
        this.m33 = -this.m33;
    }

    public final void negate(Matrix4d matrix4d) {
        this.set(matrix4d);
        this.negate();
    }

    private void set(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16) {
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m03 = d4;
        this.m10 = d5;
        this.m11 = d6;
        this.m12 = d7;
        this.m13 = d8;
        this.m20 = d9;
        this.m21 = d10;
        this.m22 = d11;
        this.m23 = d12;
        this.m30 = d13;
        this.m31 = d14;
        this.m32 = d15;
        this.m33 = d16;
    }

    private double SVD(Matrix3d matrix3d, Matrix4d matrix4d) {
        double d;
        double d2 = Math.sqrt((this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20 + this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21 + this.m02 * this.m02 + this.m12 * this.m12 + this.m22 * this.m22) / 3.0);
        if (matrix3d != null) {
            this.getRotationScale(matrix3d);
            d = 1.0 / Math.sqrt(this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20);
            matrix3d.m00 *= d;
            matrix3d.m10 *= d;
            matrix3d.m20 *= d;
            d = 1.0 / Math.sqrt(this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21);
            matrix3d.m01 *= d;
            matrix3d.m11 *= d;
            matrix3d.m21 *= d;
            d = 1.0 / Math.sqrt(this.m02 * this.m02 + this.m12 * this.m12 + this.m22 * this.m22);
            matrix3d.m02 *= d;
            matrix3d.m12 *= d;
            matrix3d.m22 *= d;
        }
        if (matrix4d != null) {
            if (matrix4d != this) {
                matrix4d.setRotationScale(this);
            }
            d = 1.0 / Math.sqrt(this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20);
            matrix4d.m00 *= d;
            matrix4d.m10 *= d;
            matrix4d.m20 *= d;
            d = 1.0 / Math.sqrt(this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21);
            matrix4d.m01 *= d;
            matrix4d.m11 *= d;
            matrix4d.m21 *= d;
            d = 1.0 / Math.sqrt(this.m02 * this.m02 + this.m12 * this.m12 + this.m22 * this.m22);
            matrix4d.m02 *= d;
            matrix4d.m12 *= d;
            matrix4d.m22 *= d;
        }
        return d2;
    }

    private float SVD(Matrix3f matrix3f) {
        double d;
        double d2 = Math.sqrt((this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20 + this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21 + this.m02 * this.m02 + this.m12 * this.m12 + this.m22 * this.m22) / 3.0);
        double d3 = d = d2 == 0.0 ? 0.0 : 1.0 / d2;
        if (matrix3f != null) {
            this.getRotationScale(matrix3f);
            matrix3f.mul((float)d);
        }
        return (float)d2;
    }

    private void mulRotationScale(double d) {
        this.m00 *= d;
        this.m01 *= d;
        this.m02 *= d;
        this.m10 *= d;
        this.m11 *= d;
        this.m12 *= d;
        this.m20 *= d;
        this.m21 *= d;
        this.m22 *= d;
    }

    private void setRotationScale(Matrix4d matrix4d) {
        this.m00 = matrix4d.m00;
        this.m01 = matrix4d.m01;
        this.m02 = matrix4d.m02;
        this.m10 = matrix4d.m10;
        this.m11 = matrix4d.m11;
        this.m12 = matrix4d.m12;
        this.m20 = matrix4d.m20;
        this.m21 = matrix4d.m21;
        this.m22 = matrix4d.m22;
    }

    private void setTranslation(Vector3f vector3f) {
        this.m03 = vector3f.x;
        this.m13 = vector3f.y;
        this.m23 = vector3f.z;
    }

    private void setFromQuat(double d, double d2, double d3, double d4) {
        double d5 = d * d + d2 * d2 + d3 * d3 + d4 * d4;
        double d6 = d5 > 0.0 ? 2.0 / d5 : 0.0;
        double d7 = d * d6;
        double d8 = d2 * d6;
        double d9 = d3 * d6;
        double d10 = d4 * d7;
        double d11 = d4 * d8;
        double d12 = d4 * d9;
        double d13 = d * d7;
        double d14 = d * d8;
        double d15 = d * d9;
        double d16 = d2 * d8;
        double d17 = d2 * d9;
        double d18 = d3 * d9;
        this.setIdentity();
        this.m00 = 1.0 - (d16 + d18);
        this.m01 = d14 - d12;
        this.m02 = d15 + d11;
        this.m10 = d14 + d12;
        this.m11 = 1.0 - (d13 + d18);
        this.m12 = d17 - d10;
        this.m20 = d15 - d11;
        this.m21 = d17 + d10;
        this.m22 = 1.0 - (d13 + d16);
    }

    private void setFromAxisAngle(double d, double d2, double d3, double d4) {
        double d5 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        d5 = 1.0 / d5;
        d *= d5;
        d2 *= d5;
        d3 *= d5;
        double d6 = Math.cos(d4);
        double d7 = Math.sin(d4);
        double d8 = 1.0 - d6;
        this.m00 = d6 + d * d * d8;
        this.m11 = d6 + d2 * d2 * d8;
        this.m22 = d6 + d3 * d3 * d8;
        double d9 = d * d2 * d8;
        double d10 = d3 * d7;
        this.m01 = d9 - d10;
        this.m10 = d9 + d10;
        d9 = d * d3 * d8;
        d10 = d2 * d7;
        this.m02 = d9 + d10;
        this.m20 = d9 - d10;
        d9 = d2 * d3 * d8;
        d10 = d * d7;
        this.m12 = d9 - d10;
        this.m21 = d9 + d10;
        this.m32 = 0.0;
        this.m31 = 0.0;
        this.m30 = 0.0;
        this.m23 = 0.0;
        this.m13 = 0.0;
        this.m03 = 0.0;
        this.m33 = 1.0;
    }

    public Object clone() {
        return new Matrix4d(this);
    }
}

