/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.Tuple3d;

public abstract class Tuple3f
implements Serializable,
Cloneable {
    public float x;
    public float y;
    public float z;

    public Tuple3f(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public Tuple3f(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
    }

    public Tuple3f(Tuple3f tuple3f) {
        this.x = tuple3f.x;
        this.y = tuple3f.y;
        this.z = tuple3f.z;
    }

    public Tuple3f(Tuple3d tuple3d) {
        this.x = (float)tuple3d.x;
        this.y = (float)tuple3d.y;
        this.z = (float)tuple3d.z;
    }

    public Tuple3f() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public final void set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public final void set(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
    }

    public final void set(Tuple3f tuple3f) {
        this.x = tuple3f.x;
        this.y = tuple3f.y;
        this.z = tuple3f.z;
    }

    public final void set(Tuple3d tuple3d) {
        this.x = (float)tuple3d.x;
        this.y = (float)tuple3d.y;
        this.z = (float)tuple3d.z;
    }

    public final void get(float[] fArray) {
        fArray[0] = this.x;
        fArray[1] = this.y;
        fArray[2] = this.z;
    }

    public final void get(Tuple3f tuple3f) {
        tuple3f.x = this.x;
        tuple3f.y = this.y;
        tuple3f.z = this.z;
    }

    public final void add(Tuple3f tuple3f, Tuple3f tuple3f2) {
        this.x = tuple3f.x + tuple3f2.x;
        this.y = tuple3f.y + tuple3f2.y;
        this.z = tuple3f.z + tuple3f2.z;
    }

    public final void add(Tuple3f tuple3f) {
        this.x += tuple3f.x;
        this.y += tuple3f.y;
        this.z += tuple3f.z;
    }

    public final void sub(Tuple3f tuple3f, Tuple3f tuple3f2) {
        this.x = tuple3f.x - tuple3f2.x;
        this.y = tuple3f.y - tuple3f2.y;
        this.z = tuple3f.z - tuple3f2.z;
    }

    public final void sub(Tuple3f tuple3f) {
        this.x -= tuple3f.x;
        this.y -= tuple3f.y;
        this.z -= tuple3f.z;
    }

    public final void negate(Tuple3f tuple3f) {
        this.x = -tuple3f.x;
        this.y = -tuple3f.y;
        this.z = -tuple3f.z;
    }

    public final void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public final void scale(float f, Tuple3f tuple3f) {
        this.x = f * tuple3f.x;
        this.y = f * tuple3f.y;
        this.z = f * tuple3f.z;
    }

    public final void scale(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
    }

    public final void scaleAdd(float f, Tuple3f tuple3f, Tuple3f tuple3f2) {
        this.x = f * tuple3f.x + tuple3f2.x;
        this.y = f * tuple3f.y + tuple3f2.y;
        this.z = f * tuple3f.z + tuple3f2.z;
    }

    public final void scaleAdd(float f, Tuple3f tuple3f) {
        this.x = f * this.x + tuple3f.x;
        this.y = f * this.y + tuple3f.y;
        this.z = f * this.z + tuple3f.z;
    }

    public int hashCode() {
        int n = Float.floatToIntBits(this.x);
        int n2 = Float.floatToIntBits(this.y);
        int n3 = Float.floatToIntBits(this.z);
        return n ^ n2 ^ n3;
    }

    public boolean equals(Tuple3f tuple3f) {
        return tuple3f != null && this.x == tuple3f.x && this.y == tuple3f.y && this.z == tuple3f.z;
    }

    public boolean equals(Object object) {
        return object instanceof Tuple3f && this.equals((Tuple3f)object);
    }

    public boolean epsilonEquals(Tuple3f tuple3f, float f) {
        return Math.abs(tuple3f.x - this.x) <= f && Math.abs(tuple3f.y - this.y) <= f && Math.abs(tuple3f.z - this.z) <= f;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public final void clamp(float f, float f2, Tuple3f tuple3f) {
        this.set(tuple3f);
        this.clamp(f, f2);
    }

    public final void clampMin(float f, Tuple3f tuple3f) {
        this.set(tuple3f);
        this.clampMin(f);
    }

    public final void clampMax(float f, Tuple3f tuple3f) {
        this.set(tuple3f);
        this.clampMax(f);
    }

    public final void absolute(Tuple3f tuple3f) {
        this.set(tuple3f);
        this.absolute();
    }

    public final void clamp(float f, float f2) {
        this.clampMin(f);
        this.clampMax(f2);
    }

    public final void clampMin(float f) {
        if (this.x < f) {
            this.x = f;
        }
        if (this.y < f) {
            this.y = f;
        }
        if (this.z < f) {
            this.z = f;
        }
    }

    public final void clampMax(float f) {
        if (this.x > f) {
            this.x = f;
        }
        if (this.y > f) {
            this.y = f;
        }
        if (this.z > f) {
            this.z = f;
        }
    }

    public final void absolute() {
        if ((double)this.x < 0.0) {
            this.x = -this.x;
        }
        if ((double)this.y < 0.0) {
            this.y = -this.y;
        }
        if ((double)this.z < 0.0) {
            this.z = -this.z;
        }
    }

    public final void interpolate(Tuple3f tuple3f, Tuple3f tuple3f2, float f) {
        float f2 = 1.0f - f;
        this.x = f2 * tuple3f.x + f * tuple3f2.x;
        this.y = f2 * tuple3f.y + f * tuple3f2.y;
        this.z = f2 * tuple3f.z + f * tuple3f2.z;
    }

    public final void interpolate(Tuple3f tuple3f, float f) {
        float f2 = 1.0f - f;
        this.x = f2 * this.x + f * tuple3f.x;
        this.y = f2 * this.y + f * tuple3f.y;
        this.z = f2 * this.z + f * tuple3f.z;
    }

    public abstract Object clone();
}

