/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler;

import de.grogra.reflect.Annotation;
import de.grogra.reflect.AnnotationImpl;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Field;
import de.grogra.reflect.Member;
import de.grogra.reflect.Method;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.XField;
import de.grogra.util.Utils;
import de.grogra.util.WrapException;
import de.grogra.vfs.FileSystem;
import de.grogra.vfs.MemoryFileSystem;
import de.grogra.xl.compiler.AccessMethod;
import de.grogra.xl.compiler.CClass;
import de.grogra.xl.compiler.CompilerOptions;
import de.grogra.xl.compiler.InheritedField;
import de.grogra.xl.compiler.InheritedMethod;
import de.grogra.xl.compiler.XMethod;
import de.grogra.xl.compiler.scope.CompilationUnitScope;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.util.XHashMap;
import de.grogra.xl.vmx.Authorization;
import de.grogra.xl.vmx.VMXState;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public strictfp class BytecodeWriter
extends MethodAdapter
implements Opcodes {
    private final CompilerOptions opts;
    private boolean fpStrict;
    private CClass currentType;
    private XMethod currentMethod;
    private int currentLine;
    private HashMap<String, Field> classConstants = new HashMap();
    private HashMap<String, de.grogra.reflect.Type> innerClasses = new HashMap();
    private static final String VMX_DESCR = ClassAdapter.wrap(VMXState.class).getDescriptor();
    public static final String AUTH_DESCR = ClassAdapter.wrap(Authorization.class).getDescriptor();
    private static final int INNER_CLASS_MODS = 1567;
    private Label unreachable;
    private static final int[] LOAD_OPCODES = new int[]{21, 22, 23, 24, 25};
    private static final int[] STORE_OPCODES = new int[]{54, 55, 56, 57, 58};
    private static final int[] RETURN_OPCODES = new int[]{172, 173, 174, 175, 176};
    private static final int[] CONST = new int[]{3, 9, 11, 14, 1};
    private static final int FLOAT_0_BITS = Float.floatToIntBits(0.0f);
    private static final long DOUBLE_0_BITS = Double.doubleToLongBits(0.0);

    private static String toNameImpl(de.grogra.reflect.Type type) {
        return type.getBinaryName().replace('.', '/');
    }

    public String toName(de.grogra.reflect.Type type) {
        if ((type = Reflection.getBinaryType((de.grogra.reflect.Type)type)) == null) {
            return null;
        }
        if (type.getTypeId() != 0) {
            throw new IllegalArgumentException(type.getName());
        }
        String string = BytecodeWriter.toNameImpl(type);
        while (Reflection.isArray((de.grogra.reflect.Type)type)) {
            type = type.getComponentType();
        }
        if (type.getDeclaringType() != null) {
            this.addInnerClass(type);
        }
        return string;
    }

    private void addInnerClass(de.grogra.reflect.Type type) {
        this.innerClasses.put(type.getBinaryName(), type);
    }

    public static String getDescriptor(Method method) {
        Object object;
        if (method instanceof XMethod && (((XMethod)(object = (XMethod)method)).getModifiersEx() & 0x400000000L) != 0L) {
            return "(" + VMX_DESCR + ")" + ((XMethod)object).getReturnType().getDescriptor();
        }
        object = method.getDescriptor();
        return ((String)object).substring(((String)object).indexOf(40));
    }

    public String[] toNames(de.grogra.reflect.Type[] typeArray) {
        if (typeArray.length == 0) {
            return Utils.STRING_0;
        }
        String[] stringArray = new String[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            stringArray[i] = this.toName(typeArray[i]);
        }
        return stringArray;
    }

    public BytecodeWriter(CompilerOptions compilerOptions) {
        super(null);
        this.opts = compilerOptions;
    }

    public boolean isFPStrict() {
        return this.fpStrict;
    }

    public int getVersion() {
        return this.opts.javaVersion;
    }

    public boolean supportsVersion(int n) {
        return CompilerOptions.isVersionGE(this.opts.javaVersion, n);
    }

    public byte[] toByteArray(String string, CClass cClass) {
        Annotation annotation;
        int n;
        this.innerClasses.clear();
        ClassWriter classWriter = new ClassWriter(1);
        int n2 = cClass.getModifiers() & 0x1FFD;
        if ((n2 & 4) != 0) {
            n2 = n2 & 0xFFFFFFFB | 1;
        }
        if ((n2 & 0x200) == 0) {
            n2 |= 0x20;
        }
        classWriter.visit(this.opts.javaVersion, n2, this.toName((de.grogra.reflect.Type)cClass), null, this.toName(cClass.getSupertype()), this.toNames(Reflection.getDeclaredInterfaces((de.grogra.reflect.Type)cClass)));
        if (string != null && this.opts.sourceInfo) {
            classWriter.visitSource(string, null);
        }
        boolean bl = false;
        for (CClass cClass2 = cClass; cClass2 != null && !bl; cClass2 = cClass2.getSupertype()) {
            bl = (cClass2.getModifiers() & 0x800) != 0;
        }
        this.classConstants.clear();
        this.currentType = cClass;
        for (n = 0; n < cClass.getDeclaredMethodCount(); ++n) {
            ((XMethod)cClass.getDeclaredMethod(n)).linkGraph(true);
        }
        for (n = 0; n < cClass.getDeclaredMethodCount(); ++n) {
            int n3;
            XMethod object3 = (XMethod)cClass.getDeclaredMethod(n);
            if (object3.getSimpleName().equals("<clinit>") && object3.hasEmptyBytecode()) continue;
            int n4 = object3.getModifiers() & 0x1FFF;
            this.mv = classWriter.visitMethod(n4, object3.getSimpleName(), BytecodeWriter.getDescriptor(object3), null, this.toNames(Reflection.getExceptions((Method)object3)));
            if (this.mv == null) continue;
            for (n3 = 0; n3 < object3.getDeclaredAnnotationCount(); ++n3) {
                Annotation annotation2 = object3.getDeclaredAnnotation(n3);
                BytecodeWriter.writeAnnotation(this.mv.visitAnnotation(annotation2.annotationType().getDescriptor(), true), annotation2);
            }
            for (n3 = 0; n3 < object3.getParameterCount(); ++n3) {
                for (int i = 0; i < object3.getParameterAnnotationCount(n3); ++i) {
                    annotation = object3.getParameterAnnotation(n3, i);
                    BytecodeWriter.writeAnnotation(this.mv.visitParameterAnnotation(n3, annotation.annotationType().getDescriptor(), true), annotation);
                }
            }
            if (!Reflection.isAbstract((Member)object3)) {
                this.mv.visitCode();
                this.fpStrict = bl || (object3.getModifiers() & 0x800) != 0;
                this.currentMethod = object3;
                this.currentLine = 0;
                this.unreachable = null;
                object3.write(this, true);
                this.currentMethod = null;
                this.mv.visitMaxs(0, 0);
            }
            this.mv.visitEnd();
            this.mv = null;
        }
        for (n = 0; n < cClass.getDeclaredFieldCount(); ++n) {
            FieldVisitor fieldVisitor;
            XField xField = (XField)cClass.getDeclaredField(n);
            Object object = null;
            if ((xField.getModifiers() & 0x40000) != 0) {
                switch (xField.getType().getTypeId()) {
                    case 2: {
                        object = xField.getBoolean(null) ? 1 : 0;
                        break;
                    }
                    case 3: {
                        object = (int)xField.getByte(null);
                        break;
                    }
                    case 4: {
                        object = (int)xField.getShort(null);
                        break;
                    }
                    case 5: {
                        object = (int)xField.getChar(null);
                        break;
                    }
                    case 6: {
                        object = xField.getInt(null);
                        break;
                    }
                    case 7: {
                        object = xField.getLong(null);
                        break;
                    }
                    case 8: {
                        object = Float.valueOf(xField.getFloat(null));
                        break;
                    }
                    case 9: {
                        object = xField.getDouble(null);
                        break;
                    }
                    case 0: {
                        object = (String)xField.getObject(null);
                    }
                }
            }
            if ((fieldVisitor = classWriter.visitField(xField.getModifiers() & 0x1FFF, xField.getSimpleName(), xField.getType().getDescriptor(), null, object)) == null) continue;
            for (int i = 0; i < xField.getDeclaredAnnotationCount(); ++i) {
                annotation = xField.getDeclaredAnnotation(i);
                BytecodeWriter.writeAnnotation(fieldVisitor.visitAnnotation(annotation.annotationType().getDescriptor(), true), annotation);
            }
            fieldVisitor.visitEnd();
        }
        Iterator iterator = cClass.getAccessMethods();
        while (iterator.hasNext()) {
            AccessMethod accessMethod = (AccessMethod)iterator.next();
            this.mv = classWriter.visitMethod("<init>".equals(accessMethod.getName()) ? 4096 : 4104, accessMethod.getName(), accessMethod.getDescriptor(), null, Utils.STRING_0);
            if (this.mv == null) continue;
            this.mv.visitCode();
            accessMethod.write(this);
            this.mv.visitMaxs(0, 0);
            this.mv.visitEnd();
            this.mv = null;
        }
        this.classConstants.clear();
        for (int i = 0; i < cClass.getDeclaredTypeCount(); ++i) {
            this.addInnerClass(cClass.getDeclaredType(i));
        }
        for (de.grogra.reflect.Type type : this.innerClasses.values()) {
            if ((type.getModifiers() & 0x80000) != 0) {
                String string2 = type.getSimpleName();
                classWriter.visitInnerClass(BytecodeWriter.toNameImpl(type), null, "".equals(string2) ? null : string2, type.getModifiers() & 0x61F);
                continue;
            }
            classWriter.visitInnerClass(BytecodeWriter.toNameImpl(type), BytecodeWriter.toNameImpl(type.getDeclaringType()), type.getSimpleName(), type.getModifiers() & 0x61F);
        }
        this.innerClasses.clear();
        this.currentType = null;
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static void writeAnnotation(AnnotationVisitor annotationVisitor, Annotation annotation) {
        String[] stringArray = ((AnnotationImpl)annotation).elements();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = annotation.value(stringArray[i]);
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                AnnotationVisitor annotationVisitor2 = annotationVisitor.visitArray(stringArray[i]);
                for (int j = 0; j < objectArray.length; ++j) {
                    BytecodeWriter.visitElement(annotationVisitor2, null, objectArray[j]);
                }
                annotationVisitor2.visitEnd();
                continue;
            }
            BytecodeWriter.visitElement(annotationVisitor, stringArray[i], object);
        }
        annotationVisitor.visitEnd();
    }

    private static void visitElement(AnnotationVisitor annotationVisitor, String string, Object object) {
        if (object instanceof de.grogra.reflect.Type) {
            annotationVisitor.visit(string, (Object)Type.getType((String)((de.grogra.reflect.Type)object).getDescriptor()));
        } else {
            annotationVisitor.visit(string, object);
        }
    }

    public void visitInsn(int n) {
        this.mv.visitInsn(n);
        switch (n) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: {
                this.unreachable = new Label();
                this.mv.visitLabel(this.unreachable);
            }
        }
    }

    public void visitVarInsn(int n, int n2) {
        this.mv.visitVarInsn(n, n2);
        if (n == 169) {
            this.unreachable = new Label();
            this.mv.visitLabel(this.unreachable);
        }
    }

    public void visitJumpInsn(int n, Label label) {
        this.mv.visitJumpInsn(n, label);
        if (n == 167) {
            this.unreachable = new Label();
            this.mv.visitLabel(this.unreachable);
        }
    }

    public void visitLabel(Label label) {
        this.mv.visitLabel(label);
        this.unreachable = null;
    }

    public boolean isUnreachable() {
        if (this.unreachable == null) {
            return false;
        }
        Label label = new Label();
        this.mv.visitLabel(label);
        return label.getOffset() == this.unreachable.getOffset();
    }

    public void visitLineNumber(int n) {
        if (n > 0 && n != this.currentLine && this.opts.lineNumberInfo) {
            Label label = new Label();
            this.mv.visitLabel(label);
            this.mv.visitLineNumber(n, label);
            this.currentLine = n;
        }
    }

    private de.grogra.reflect.Type qualifyingType(Member member, de.grogra.reflect.Type type) {
        type = Reflection.getBinaryType((de.grogra.reflect.Type)type);
        return Reflection.isSupertypeOrSame((de.grogra.reflect.Type)member.getDeclaringType(), (de.grogra.reflect.Type)type) ? type : member.getDeclaringType();
    }

    public void visitFieldInsn(int n, Field field, AccessMethod accessMethod) {
        if (Reflection.isArray((de.grogra.reflect.Type)field.getDeclaringType())) {
            assert (n == 180 && field.getSimpleName().equals("length"));
            this.mv.visitInsn(190);
        } else if (accessMethod != null) {
            this.mv.visitMethodInsn(184, this.toName((de.grogra.reflect.Type)accessMethod.getDeclaringClass()), accessMethod.getName(), accessMethod.getDescriptor());
        } else {
            this.mv.visitFieldInsn(n, this.toName(this.qualifyingType((Member)field, InheritedField.getQualifyingType(field))), field.getSimpleName(), field.getType().getDescriptor());
        }
    }

    public void visitFieldInsn(int n, Class clazz, String string, String string2) {
        ClassAdapter classAdapter = ClassAdapter.wrap((Class)clazz);
        Field field = classAdapter.getLookup().getField(string);
        int n2 = field.getDescriptor().indexOf(59);
        if (field.getDescriptor().regionMatches(n2 + 1, string2, 0, string2.length())) {
            this.visitFieldInsn(n, this.toName((de.grogra.reflect.Type)classAdapter), string, string2);
            return;
        }
        throw new NoSuchFieldError(clazz + " " + string + " " + string2);
    }

    public void visitMethodInsn(int n, Method method) {
        de.grogra.reflect.Type type = this.qualifyingType((Member)method, InheritedMethod.getQualifyingType(method));
        if (Reflection.isInterface((de.grogra.reflect.Type)type) && Reflection.equal((de.grogra.reflect.Type)de.grogra.reflect.Type.OBJECT, (de.grogra.reflect.Type)method.getDeclaringType())) {
            type = de.grogra.reflect.Type.OBJECT;
        }
        if (n == 185 && !Reflection.isInterface((de.grogra.reflect.Type)type)) {
            n = 182;
        }
        this.mv.visitMethodInsn(n, this.toName(type), method.getSimpleName(), BytecodeWriter.getDescriptor(method));
    }

    public void visitMethodInsn(Method method) {
        this.visitMethodInsn(Reflection.isStatic((Member)method) ? 184 : (Reflection.isInterface((de.grogra.reflect.Type)method.getDeclaringType()) ? 185 : (method.getSimpleName().equals("<init>") || Reflection.isPrivate((Member)method) ? 183 : 182)), method);
    }

    public void visitMethodInsn(de.grogra.reflect.Type type, String string) {
        this.visitMethodInsn(type, string, null);
    }

    public void visitMethodInsn(Class clazz, String string, String string2) {
        this.visitMethodInsn((de.grogra.reflect.Type)ClassAdapter.wrap((Class)clazz), string, string2);
    }

    public void visitMethodInsn(Class clazz, String string) {
        this.visitMethodInsn((de.grogra.reflect.Type)ClassAdapter.wrap((Class)clazz), string, null);
    }

    public void visitMethodInsn(de.grogra.reflect.Type type, String string, String string2) {
        if (!this.visitMethodInsnImpl(type, string, string2)) {
            throw new NoSuchMethodError(type + " " + string + " " + string2);
        }
    }

    private boolean visitMethodInsnImpl(de.grogra.reflect.Type type, String string, String string2) {
        while (type != null) {
            for (XHashMap.Entry entry = type.getLookup().getMethods(string); entry != null; entry = entry.next()) {
                Method method = (Method)entry.getValue();
                if (string2 == null) {
                    if (entry.next() != null) {
                        throw new AssertionError((Object)("Method " + string + " is overloaded"));
                    }
                    string2 = BytecodeWriter.getDescriptor(method);
                } else if (!method.getDescriptor().endsWith(string2)) continue;
                this.visitMethodInsn(method);
                return true;
            }
            for (int i = 0; i < type.getDeclaredInterfaceCount(); ++i) {
                if (!this.visitMethodInsnImpl(type.getDeclaredInterface(i), string, string2)) continue;
                return true;
            }
            type = type.getSupertype();
        }
        return false;
    }

    public void visitTypeInsn(int n, de.grogra.reflect.Type type) {
        this.mv.visitTypeInsn(n, this.toName(type));
    }

    public void visitCheckCast(de.grogra.reflect.Type type) {
        if (type.getTypeId() == 0 && !Reflection.equal((de.grogra.reflect.Type)de.grogra.reflect.Type.OBJECT, (de.grogra.reflect.Type)type)) {
            this.visitTypeInsn(192, type);
        }
    }

    public void visitNewArray(de.grogra.reflect.Type type) {
        switch (type.getTypeId()) {
            case 2: {
                this.mv.visitIntInsn(188, 4);
                break;
            }
            case 3: {
                this.mv.visitIntInsn(188, 8);
                break;
            }
            case 4: {
                this.mv.visitIntInsn(188, 9);
                break;
            }
            case 5: {
                this.mv.visitIntInsn(188, 5);
                break;
            }
            case 6: {
                this.mv.visitIntInsn(188, 10);
                break;
            }
            case 7: {
                this.mv.visitIntInsn(188, 11);
                break;
            }
            case 8: {
                this.mv.visitIntInsn(188, 6);
                break;
            }
            case 9: {
                this.mv.visitIntInsn(188, 7);
                break;
            }
            case 0: {
                this.visitTypeInsn(189, type);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public void visitVMX() {
        Local local = this.currentMethod.getLocalForVMX();
        this.visitLoad(local.createVMXLocal(), local.getType());
    }

    public void visitLoad(VMXState.Local local, de.grogra.reflect.Type type) {
        if (local.isJavaLocal()) {
            this.visitLoad(local.getIndex(), type.getTypeId());
        } else {
            this.visitVMX();
            this.visiticonst(local.getNesting());
            this.visiticonst(local.getIndex());
            this.visitaconst(null);
            this.visitMethodInsn(VMXState.class, Reflection.getJVMPrefix((de.grogra.reflect.Type)type) + "get", '(' + VMX_DESCR + "II" + AUTH_DESCR + ')' + Reflection.getType((int)Reflection.getJVMTypeId((de.grogra.reflect.Type)type)).getDescriptor());
            this.visitCheckCast(type);
        }
    }

    public void visitLoad(int n, int n2) {
        this.mv.visitVarInsn(Expression.opcode(n2, LOAD_OPCODES), n);
    }

    public void visitStore(VMXState.Local local, de.grogra.reflect.Type type) {
        if (local.isJavaLocal()) {
            this.mv.visitVarInsn(Expression.opcode(type.getTypeId(), STORE_OPCODES), local.getIndex());
        } else {
            this.visitVMX();
            this.visiticonst(local.getNesting());
            this.visiticonst(local.getIndex());
            this.visitaconst(null);
            this.visitMethodInsn(VMXState.class, Reflection.getJVMPrefix((de.grogra.reflect.Type)type) + "set", '(' + Reflection.getType((int)Reflection.getJVMTypeId((de.grogra.reflect.Type)type)).getDescriptor() + VMX_DESCR + "II" + AUTH_DESCR + ")V");
        }
    }

    public void visitReturn(int n) {
        this.visitInsn(n == 1 ? 177 : Expression.opcode(n, RETURN_OPCODES));
    }

    public void visitNull(int n) {
        if (n != 1) {
            this.visitInsn(Expression.opcode(n, CONST));
        }
    }

    public void visitPop(int n) {
        if (n != 1) {
            this.visitInsn(Reflection.hasCategory2((int)n) ? 88 : 87);
        }
    }

    public void visitALoad(int n) {
        switch (n) {
            case 2: 
            case 3: {
                n = 51;
                break;
            }
            case 4: {
                n = 53;
                break;
            }
            case 5: {
                n = 52;
                break;
            }
            case 6: {
                n = 46;
                break;
            }
            case 7: {
                n = 47;
                break;
            }
            case 8: {
                n = 48;
                break;
            }
            case 9: {
                n = 49;
                break;
            }
            case 0: {
                n = 50;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.mv.visitInsn(n);
    }

    public void visitAStore(int n) {
        switch (n) {
            case 2: 
            case 3: {
                n = 84;
                break;
            }
            case 4: {
                n = 86;
                break;
            }
            case 5: {
                n = 85;
                break;
            }
            case 6: {
                n = 79;
                break;
            }
            case 7: {
                n = 80;
                break;
            }
            case 8: {
                n = 81;
                break;
            }
            case 9: {
                n = 82;
                break;
            }
            case 0: {
                n = 83;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.mv.visitInsn(n);
    }

    public void visitDup(int n) {
        this.mv.visitInsn(Reflection.hasCategory2((int)n) ? 92 : 89);
    }

    public void visitDupX1(int n) {
        this.mv.visitInsn(Reflection.hasCategory2((int)n) ? 93 : 90);
    }

    public void visitDupX2(int n) {
        this.mv.visitInsn(Reflection.hasCategory2((int)n) ? 94 : 91);
    }

    public void visitSwap(int n, int n2) {
        if (n != 1 && n2 != 1) {
            if (Reflection.hasCategory2((int)n)) {
                if (Reflection.hasCategory2((int)n2)) {
                    this.visitInsn(94);
                    this.visitInsn(88);
                } else {
                    this.visitInsn(91);
                    this.visitInsn(87);
                }
            } else if (Reflection.hasCategory2((int)n2)) {
                this.visitInsn(93);
                this.visitInsn(88);
            } else {
                this.visitInsn(95);
            }
        }
    }

    public void visitVM2T(int n) {
        switch (n) {
            case 2: {
                this.mv.visitInsn(4);
                this.mv.visitInsn(126);
                break;
            }
            case 3: {
                this.mv.visitInsn(145);
                break;
            }
            case 4: {
                this.mv.visitInsn(147);
                break;
            }
            case 5: {
                this.mv.visitInsn(146);
            }
        }
    }

    public void visitClass2Type() {
        this.mv.visitInsn(3);
        this.visitMethodInsn(ClassAdapter.class, "wrap", "(Ljava/lang/Class;Z)Lde/grogra/reflect/ClassAdapter;");
    }

    public void visiticonst(int n) {
        switch (n) {
            case -1: {
                this.mv.visitInsn(2);
                break;
            }
            case 0: {
                this.mv.visitInsn(3);
                break;
            }
            case 1: {
                this.mv.visitInsn(4);
                break;
            }
            case 2: {
                this.mv.visitInsn(5);
                break;
            }
            case 3: {
                this.mv.visitInsn(6);
                break;
            }
            case 4: {
                this.mv.visitInsn(7);
                break;
            }
            case 5: {
                this.mv.visitInsn(8);
                break;
            }
            default: {
                if (-128 <= n && n <= 127) {
                    this.mv.visitIntInsn(16, n);
                    break;
                }
                if (Short.MIN_VALUE <= n && n <= Short.MAX_VALUE) {
                    this.mv.visitIntInsn(17, n);
                    break;
                }
                this.mv.visitLdcInsn((Object)n);
            }
        }
    }

    public void visitlconst(long l) {
        if (l == 0L) {
            this.mv.visitInsn(9);
        } else if (l == 1L) {
            this.mv.visitInsn(10);
        } else {
            this.mv.visitLdcInsn((Object)l);
        }
    }

    public void visitfconst(float f) {
        if (Float.floatToIntBits(f) == FLOAT_0_BITS) {
            this.mv.visitInsn(11);
        } else if (f == 1.0f) {
            this.mv.visitInsn(12);
        } else if (f == 2.0f) {
            this.mv.visitInsn(13);
        } else {
            this.mv.visitLdcInsn((Object)Float.valueOf(f));
        }
    }

    public void visitdconst(double d) {
        if (Double.doubleToLongBits(d) == DOUBLE_0_BITS) {
            this.mv.visitInsn(14);
        } else if (d == 1.0) {
            this.mv.visitInsn(15);
        } else {
            this.mv.visitLdcInsn((Object)d);
        }
    }

    private void visitClassFromArray(de.grogra.reflect.Type type) {
        this.mv.visitInsn(3);
        this.visitTypeInsn(189, type);
        this.mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
        this.mv.visitMethodInsn(182, "java/lang/Class", "getComponentType", "()Ljava/lang/Class;");
    }

    public void visitaconst(Object object) {
        if (object == null) {
            this.mv.visitInsn(1);
        } else if (object instanceof String) {
            this.mv.visitLdcInsn(object);
        } else if (object instanceof Class || object instanceof de.grogra.reflect.Type) {
            de.grogra.reflect.Type type = object instanceof de.grogra.reflect.Type ? (de.grogra.reflect.Type)object : ClassAdapter.wrap((Class)((Class)object));
            if (Reflection.isPrimitiveOrVoid((de.grogra.reflect.Type)(type = Reflection.getBinaryType((de.grogra.reflect.Type)type)))) {
                this.mv.visitFieldInsn(178, Reflection.getWrapperClass((int)type.getTypeId()).getName().replace('.', '/'), "TYPE", "Ljava/lang/Class;");
            } else if (this.supportsVersion(49)) {
                this.mv.visitLdcInsn((Object)Type.getType((String)type.getDescriptor()));
            } else if ("<clinit>".equals(this.currentMethod.getSimpleName())) {
                this.visitClassFromArray(type);
            } else {
                assert ((this.currentType.getModifiers() & 0x200) == 0);
                Field field = this.classConstants.get(type.getBinaryName());
                if (field == null) {
                    field = this.currentType.declareAuxField("class$", 8, de.grogra.reflect.Type.CLASS);
                    this.classConstants.put(type.getBinaryName(), field);
                }
                Label label = new Label();
                this.visitFieldInsn(178, field, null);
                this.mv.visitInsn(89);
                this.mv.visitJumpInsn(199, label);
                this.mv.visitInsn(87);
                this.visitClassFromArray(type);
                this.mv.visitInsn(89);
                this.visitFieldInsn(179, field, null);
                this.mv.visitLabel(label);
            }
        } else {
            throw new IllegalArgumentException(String.valueOf(object));
        }
    }

    public MemoryFileSystem createFileSystemFor(CompilationUnitScope[] compilationUnitScopeArray) {
        MemoryFileSystem memoryFileSystem = new MemoryFileSystem("classes");
        for (int i = 0; i < compilationUnitScopeArray.length; ++i) {
            try {
                this.write(compilationUnitScopeArray[i], (FileSystem)memoryFileSystem, memoryFileSystem.getRoot());
                continue;
            }
            catch (IOException iOException) {
                throw new WrapException((Throwable)iOException);
            }
        }
        return memoryFileSystem;
    }

    public void write(CompilationUnitScope compilationUnitScope, FileSystem fileSystem, Object object) throws IOException {
        int n;
        de.grogra.reflect.Type[] typeArray = compilationUnitScope.getDeclaredTypes();
        for (n = 0; n < typeArray.length; ++n) {
            this.writeType(typeArray[n], compilationUnitScope.getSource(), fileSystem, object);
        }
        typeArray = compilationUnitScope.getLocalClasses();
        for (n = 0; n < typeArray.length; ++n) {
            this.writeType(typeArray[n], compilationUnitScope.getSource(), fileSystem, object);
        }
    }

    private void writeType(de.grogra.reflect.Type type, String string, FileSystem fileSystem, Object object) throws IOException {
        Object object2;
        Object object3;
        int n;
        Object object4 = object;
        String string2 = type.getBinaryName();
        while ((n = string2.indexOf(46)) >= 0) {
            object3 = string2.substring(0, n);
            object2 = fileSystem.getFile(object4, (String)object3);
            if (object2 != null) {
                if (fileSystem.isLeaf(object2)) {
                    throw new IOException(fileSystem.getPath(object2) + " exists, but is not a directory");
                }
            } else {
                object2 = fileSystem.create(object4, (String)object3, true);
            }
            object4 = object2;
            string2 = string2.substring(n + 1);
        }
        object3 = fileSystem.create(object4, string2 + ".class", false);
        object2 = fileSystem.getOutputStream(object3, false);
        ((OutputStream)object2).write(this.toByteArray(string, (CClass)type));
        ((OutputStream)object2).flush();
        ((OutputStream)object2).close();
        for (int i = 0; i < type.getDeclaredTypeCount(); ++i) {
            this.writeType(type.getDeclaredType(i), string, fileSystem, object);
        }
    }
}

