/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler.pattern;

import antlr.collections.AST;
import de.grogra.xl.compiler.Compiler;
import de.grogra.xl.compiler.pattern.Place;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.GetLocal;

public final class ArgumentDescription {
    public final AST ast;
    public final Expression expr;
    public final Local local;
    public final Place place;

    public ArgumentDescription(AST aST, Expression expression) {
        expression.getClass();
        this.ast = aST != null ? aST : Compiler.getAST(expression);
        this.expr = expression;
        this.local = expression instanceof GetLocal ? ((GetLocal)expression).getLocal(0) : null;
        this.place = null;
    }

    public ArgumentDescription(AST aST, Local local) {
        local.getClass();
        this.ast = aST;
        this.expr = null;
        this.local = local;
        this.place = null;
    }

    public ArgumentDescription(AST aST, Place place) {
        place.getClass();
        this.ast = aST;
        this.expr = null;
        this.local = null;
        this.place = place;
    }

    public static ArgumentDescription[] create(Expression[] expressionArray) {
        ArgumentDescription[] argumentDescriptionArray = new ArgumentDescription[expressionArray.length];
        for (int i = 0; i < expressionArray.length; ++i) {
            argumentDescriptionArray[i] = expressionArray[i] != null ? new ArgumentDescription(null, expressionArray[i]) : null;
        }
        return argumentDescriptionArray;
    }
}

