/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler.pattern;

import antlr.collections.AST;
import de.grogra.reflect.Type;
import de.grogra.xl.compiler.pattern.Argument;
import de.grogra.xl.compiler.pattern.ArgumentDescription;
import de.grogra.xl.compiler.pattern.Component;
import de.grogra.xl.compiler.pattern.PatternBuilder;
import de.grogra.xl.compiler.pattern.Place;
import de.grogra.xl.compiler.pattern.SimplePatternData;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.expr.Block;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.ObjectConst;
import de.grogra.xl.query.Pattern;
import de.grogra.xl.util.ObjectList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PatternData
extends Component {
    final AST label;
    final AST pos;
    final PatternBuilder builder;
    final int dataId;
    final int textualPosition;
    final int level;
    final int inKind;
    final int outKind;
    boolean context;
    PatternData prev;
    PatternData next;
    int index;
    ObjectConst targetTypeExpr;
    HashSet uses;
    HashSet assigns;
    boolean atomic;
    private final ObjectList<PatternData> followers = new ObjectList();
    private Block block;

    PatternData(AST aST, int n, int n2, AST aST2, int n3, int n4, PatternBuilder patternBuilder) {
        super(patternBuilder.problems);
        this.label = aST;
        this.pos = aST2;
        this.dataId = patternBuilder.nextPatternId();
        this.builder = patternBuilder;
        this.inKind = n;
        this.outKind = n2;
        this.textualPosition = n3;
        this.level = n4;
    }

    abstract boolean hasInPlace();

    abstract boolean hasOutPlace();

    abstract Place getInPlace(boolean var1);

    abstract Place getOutPlace(boolean var1);

    abstract int getLabelArgument();

    abstract Type getLastNodeType();

    public abstract Pattern getPattern();

    boolean isOutClosed() {
        return this.outKind == 1;
    }

    boolean isInClosed() {
        return this.inKind == 1;
    }

    void addFollower(PatternData patternData) {
        patternData.addDependency(this);
        if (!this.followers.contains((Object)patternData)) {
            if (!this.followers.isEmpty()) {
                patternData.addDependency((PatternData)this.followers.peek(1));
            }
            this.followers.add((Object)patternData);
        }
        this.atomic = true;
    }

    void computeAllFollowers() {
        int n = this.followers.size();
        for (int i = 0; i < n; ++i) {
            PatternData patternData = (PatternData)this.followers.get(i);
            patternData.computeAllFollowers();
            for (int j = 0; j < patternData.followers.size(); ++j) {
                this.followers.addIfNotContained(patternData.followers.get(j));
            }
        }
    }

    void convertFollowersToDependencies() {
        while (!this.followers.isEmpty()) {
            PatternData patternData = (PatternData)this.followers.pop();
            for (int i = 0; i < patternData.dependsOn.size(); ++i) {
                PatternData patternData2 = (PatternData)patternData.dependsOn.get(i);
                if (patternData2 == this || this.followers.contains((Object)patternData2)) continue;
                this.addDependency(patternData2);
            }
        }
    }

    final void addRoutine(MethodScope methodScope) {
        if (this.block == null) {
            this.block = new Block();
        }
        this.block.add(methodScope.getMethod());
    }

    Block getSubRoutines() {
        return null;
    }

    public final Block getAllRoutines() {
        Block block = this.getSubRoutines();
        if (this.block == null) {
            return block;
        }
        if (block == null) {
            return this.block;
        }
        Block block2 = new Block();
        block2.add(block);
        block2.add(this.block);
        return block2;
    }

    abstract Place[] getPlaces();

    short[] completeArguments(ObjectList objectList) {
        Place[] placeArray = this.getPlaces();
        short[] sArray = objectList != null ? new short[placeArray.length] : null;
        for (int i = 0; i < placeArray.length; ++i) {
            Argument argument = this.getArgument(i);
            if (sArray != null) {
                sArray[i] = (short)objectList.indexOf((Object)argument);
            }
            if (this.assigns == null) {
                this.assigns = new HashSet();
            }
            this.assigns.add(argument.local);
        }
        return sArray;
    }

    void getArguments(ObjectList<? super Argument> objectList) {
        for (int i = this.getPlaces().length - 1; i >= 0; --i) {
            objectList.addIfNotContained((Object)this.getArgument(i));
        }
    }

    void computeDependenciesFromLocalAccess(ObjectList objectList) {
        PatternData patternData;
        int n;
        int n2 = objectList.size();
        if (this.assigns != null) {
            for (Local local : this.assigns) {
                if (local.isVariable(this.builder)) continue;
                for (n = 0; n < n2; ++n) {
                    patternData = (PatternData)objectList.get(n);
                    if (patternData.textualPosition >= this.textualPosition || patternData.uses == null || !patternData.uses.contains(local)) continue;
                    this.addDependency(patternData);
                }
            }
        }
        if (this.uses != null) {
            for (Local local : this.uses) {
                if (local.isVariable(this.builder)) continue;
                for (n = 0; n < n2; ++n) {
                    patternData = (PatternData)objectList.get(n);
                    if (patternData.textualPosition >= this.textualPosition || patternData.assigns == null || !patternData.assigns.contains(local)) continue;
                    this.addDependency(patternData);
                }
            }
        }
    }

    void setLocalAccess(HashSet hashSet, HashSet hashSet2) {
        if (!hashSet.isEmpty()) {
            this.uses = hashSet;
        }
        if (!hashSet2.isEmpty()) {
            this.assigns = hashSet2;
        }
    }

    void addLocalAccess(ObjectList objectList) {
        for (int i = 0; i < objectList.size(); ++i) {
            this.addLocalAccess((PatternData)objectList.get(i));
        }
    }

    void addLocalAccess(PatternData patternData) {
        if (patternData.assigns != null && !patternData.assigns.isEmpty()) {
            if (this.assigns == null) {
                this.assigns = new HashSet();
            }
            this.assigns.addAll(patternData.assigns);
        }
        if (patternData.uses != null && !patternData.uses.isEmpty()) {
            if (this.uses == null) {
                this.uses = new HashSet();
            }
            this.uses.addAll(patternData.uses);
        }
    }

    Argument getArgument(int n) {
        return this.getPlaces()[n].getMapping(this, n).getArgument();
    }

    SimplePatternData addExpression(Expression expression, Type type) {
        Local local = this.builder.declareAuxVariable(type);
        SimplePatternData simplePatternData = this.builder.addExpression(null, expression, this.pos, true, new ArgumentDescription(this.pos, local), this.textualPosition);
        this.addDependency(simplePatternData);
        return simplePatternData;
    }

    abstract void createSubPatterns();

    abstract void mapLabeledArgs();

    abstract void mapUnlabeledArgs();
}

