/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.Type;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.expr.Assignment;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.vmx.VMXState;

public final class AssignArrayComponent
extends Assignment {
    Expression container;
    Expression index;
    Expression expr;

    public AssignArrayComponent(Type type, int n) {
        super(type, n);
    }

    protected boolean evaluateBooleanImpl(VMXState vMXState) {
        boolean bl;
        boolean[] blArray = (boolean[])this.container.evaluateObject(vMXState);
        int n = this.index.evaluateInt(vMXState);
        switch (this.assignmentType) {
            case 0: {
                blArray[n] = bl = this.expr.evaluateBoolean(vMXState);
                break;
            }
            case 1: {
                vMXState.ipush(blArray[n] ? 1 : 0);
                blArray[n] = bl = this.expr.evaluateBoolean(vMXState);
                break;
            }
            case 2: {
                bl = blArray[n];
                vMXState.ipush(bl ? 1 : 0);
                blArray[n] = this.expr.evaluateBoolean(vMXState);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return bl;
    }

    protected byte evaluateByteImpl(VMXState vMXState) {
        byte by;
        byte[] byArray = (byte[])this.container.evaluateObject(vMXState);
        int n = this.index.evaluateInt(vMXState);
        switch (this.assignmentType) {
            case 0: {
                byArray[n] = by = this.expr.evaluateByte(vMXState);
                break;
            }
            case 1: {
                vMXState.ipush((int)byArray[n]);
                byArray[n] = by = this.expr.evaluateByte(vMXState);
                break;
            }
            case 2: {
                by = byArray[n];
                vMXState.ipush((int)by);
                byArray[n] = this.expr.evaluateByte(vMXState);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return by;
    }

    protected short evaluateShortImpl(VMXState vMXState) {
        short s;
        short[] sArray = (short[])this.container.evaluateObject(vMXState);
        int n = this.index.evaluateInt(vMXState);
        switch (this.assignmentType) {
            case 0: {
                sArray[n] = s = this.expr.evaluateShort(vMXState);
                break;
            }
            case 1: {
                vMXState.ipush((int)sArray[n]);
                sArray[n] = s = this.expr.evaluateShort(vMXState);
                break;
            }
            case 2: {
                s = sArray[n];
                vMXState.ipush((int)s);
                sArray[n] = this.expr.evaluateShort(vMXState);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return s;
    }

    protected char evaluateCharImpl(VMXState vMXState) {
        char c;
        char[] cArray = (char[])this.container.evaluateObject(vMXState);
        int n = this.index.evaluateInt(vMXState);
        switch (this.assignmentType) {
            case 0: {
                cArray[n] = c = this.expr.evaluateChar(vMXState);
                break;
            }
            case 1: {
                vMXState.ipush((int)cArray[n]);
                cArray[n] = c = this.expr.evaluateChar(vMXState);
                break;
            }
            case 2: {
                c = cArray[n];
                vMXState.ipush((int)c);
                cArray[n] = this.expr.evaluateChar(vMXState);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return c;
    }

    protected int evaluateIntImpl(VMXState vMXState) {
        int n;
        int[] nArray = (int[])this.container.evaluateObject(vMXState);
        int n2 = this.index.evaluateInt(vMXState);
        switch (this.assignmentType) {
            case 0: {
                nArray[n2] = n = this.expr.evaluateInt(vMXState);
                break;
            }
            case 1: {
                vMXState.ipush(nArray[n2]);
                nArray[n2] = n = this.expr.evaluateInt(vMXState);
                break;
            }
            case 2: {
                n = nArray[n2];
                vMXState.ipush(n);
                nArray[n2] = this.expr.evaluateInt(vMXState);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return n;
    }

    protected long evaluateLongImpl(VMXState vMXState) {
        long l;
        long[] lArray = (long[])this.container.evaluateObject(vMXState);
        int n = this.index.evaluateInt(vMXState);
        switch (this.assignmentType) {
            case 0: {
                lArray[n] = l = this.expr.evaluateLong(vMXState);
                break;
            }
            case 1: {
                vMXState.lpush(lArray[n]);
                lArray[n] = l = this.expr.evaluateLong(vMXState);
                break;
            }
            case 2: {
                l = lArray[n];
                vMXState.lpush(l);
                lArray[n] = this.expr.evaluateLong(vMXState);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return l;
    }

    protected float evaluateFloatImpl(VMXState vMXState) {
        float f;
        float[] fArray = (float[])this.container.evaluateObject(vMXState);
        int n = this.index.evaluateInt(vMXState);
        switch (this.assignmentType) {
            case 0: {
                fArray[n] = f = this.expr.evaluateFloat(vMXState);
                break;
            }
            case 1: {
                vMXState.fpush(fArray[n]);
                fArray[n] = f = this.expr.evaluateFloat(vMXState);
                break;
            }
            case 2: {
                f = fArray[n];
                vMXState.fpush(f);
                fArray[n] = this.expr.evaluateFloat(vMXState);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return f;
    }

    protected double evaluateDoubleImpl(VMXState vMXState) {
        double d;
        double[] dArray = (double[])this.container.evaluateObject(vMXState);
        int n = this.index.evaluateInt(vMXState);
        switch (this.assignmentType) {
            case 0: {
                dArray[n] = d = this.expr.evaluateDouble(vMXState);
                break;
            }
            case 1: {
                vMXState.dpush(dArray[n]);
                dArray[n] = d = this.expr.evaluateDouble(vMXState);
                break;
            }
            case 2: {
                d = dArray[n];
                vMXState.dpush(d);
                dArray[n] = this.expr.evaluateDouble(vMXState);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return d;
    }

    protected Object evaluateObjectImpl(VMXState vMXState) {
        Object object;
        Object[] objectArray = (Object[])this.container.evaluateObject(vMXState);
        int n = this.index.evaluateInt(vMXState);
        switch (this.assignmentType) {
            case 0: {
                objectArray[n] = object = this.expr.evaluateObject(vMXState);
                break;
            }
            case 1: {
                vMXState.apush(objectArray[n]);
                objectArray[n] = object = this.expr.evaluateObject(vMXState);
                break;
            }
            case 2: {
                object = objectArray[n];
                vMXState.apush(object);
                objectArray[n] = this.expr.evaluateObject(vMXState);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return object;
    }

    public void link(boolean bl) {
        this.checkExpressionCount(3);
        this.container = this.getExpression(0, 0, bl);
        this.index = this.getExpression(1, 6, bl);
        this.expr = this.getExpression(2, this.etype, bl);
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        this.container.write(bytecodeWriter, false);
        this.index.write(bytecodeWriter, false);
        AssignArrayComponent.write(this.etype, this.assignmentType, this.expr, bytecodeWriter, bl);
    }

    static void write(int n, int n2, Expression expression, BytecodeWriter bytecodeWriter, boolean bl) {
        switch (n2) {
            case 0: {
                expression.write(bytecodeWriter, false);
                if (!bl) {
                    bytecodeWriter.visitDupX2(n);
                }
                bytecodeWriter.visitAStore(n);
                break;
            }
            case 2: {
                if (!bl) {
                    bytecodeWriter.visitInsn(92);
                    bytecodeWriter.visitALoad(n);
                    bytecodeWriter.visitDupX2(n);
                    expression.write(bytecodeWriter, false);
                    bytecodeWriter.visitAStore(n);
                    break;
                }
            }
            case 1: {
                bytecodeWriter.visitInsn(92);
                bytecodeWriter.visitALoad(n);
                expression.write(bytecodeWriter, false);
                if (!bl) {
                    bytecodeWriter.visitDupX2(n);
                }
                bytecodeWriter.visitAStore(n);
            }
        }
    }
}

