/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.Field;
import de.grogra.reflect.Member;
import de.grogra.reflect.Reflection;
import de.grogra.xl.compiler.AccessMethod;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.CClass;
import de.grogra.xl.expr.Assignment;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.vmx.VMXState;

public final class AssignField
extends Assignment {
    Field field;
    Expression container;
    Expression expr;
    private CClass accessMethodClass;

    public AssignField(Field field, int n) {
        super(field.getType(), n);
        this.field = field;
    }

    public boolean isRequired(int n) {
        return n > 0 || !Reflection.isStatic((Member)this.field) || this.getExpressionCount() == 1;
    }

    public Field getField() {
        return this.field;
    }

    protected boolean evaluateBooleanImpl(VMXState vMXState) {
        boolean bl;
        Object object = this.container == null ? null : this.container.evaluateObject(vMXState);
        try {
            switch (this.assignmentType) {
                case 0: {
                    bl = this.expr.evaluateBoolean(vMXState);
                    this.field.setBoolean(object, bl);
                    break;
                }
                case 1: {
                    vMXState.ipush(this.field.getBoolean(object) ? 1 : 0);
                    bl = this.expr.evaluateBoolean(vMXState);
                    this.field.setBoolean(object, bl);
                    break;
                }
                case 2: {
                    bl = this.field.getBoolean(object);
                    vMXState.ipush(bl ? 1 : 0);
                    this.field.setBoolean(object, this.expr.evaluateBoolean(vMXState));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
        return bl;
    }

    protected byte evaluateByteImpl(VMXState vMXState) {
        byte by;
        Object object = this.container == null ? null : this.container.evaluateObject(vMXState);
        try {
            switch (this.assignmentType) {
                case 0: {
                    by = this.expr.evaluateByte(vMXState);
                    this.field.setByte(object, by);
                    break;
                }
                case 1: {
                    vMXState.ipush((int)this.field.getByte(object));
                    by = this.expr.evaluateByte(vMXState);
                    this.field.setByte(object, by);
                    break;
                }
                case 2: {
                    by = this.field.getByte(object);
                    vMXState.ipush((int)by);
                    this.field.setByte(object, this.expr.evaluateByte(vMXState));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
        return by;
    }

    protected short evaluateShortImpl(VMXState vMXState) {
        short s;
        Object object = this.container == null ? null : this.container.evaluateObject(vMXState);
        try {
            switch (this.assignmentType) {
                case 0: {
                    s = this.expr.evaluateShort(vMXState);
                    this.field.setShort(object, s);
                    break;
                }
                case 1: {
                    vMXState.ipush((int)this.field.getShort(object));
                    s = this.expr.evaluateShort(vMXState);
                    this.field.setShort(object, s);
                    break;
                }
                case 2: {
                    s = this.field.getShort(object);
                    vMXState.ipush((int)s);
                    this.field.setShort(object, this.expr.evaluateShort(vMXState));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
        return s;
    }

    protected char evaluateCharImpl(VMXState vMXState) {
        char c;
        Object object = this.container == null ? null : this.container.evaluateObject(vMXState);
        try {
            switch (this.assignmentType) {
                case 0: {
                    c = this.expr.evaluateChar(vMXState);
                    this.field.setChar(object, c);
                    break;
                }
                case 1: {
                    vMXState.ipush((int)this.field.getChar(object));
                    c = this.expr.evaluateChar(vMXState);
                    this.field.setChar(object, c);
                    break;
                }
                case 2: {
                    c = this.field.getChar(object);
                    vMXState.ipush((int)c);
                    this.field.setChar(object, this.expr.evaluateChar(vMXState));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
        return c;
    }

    protected int evaluateIntImpl(VMXState vMXState) {
        int n;
        Object object = this.container == null ? null : this.container.evaluateObject(vMXState);
        try {
            switch (this.assignmentType) {
                case 0: {
                    n = this.expr.evaluateInt(vMXState);
                    this.field.setInt(object, n);
                    break;
                }
                case 1: {
                    vMXState.ipush(this.field.getInt(object));
                    n = this.expr.evaluateInt(vMXState);
                    this.field.setInt(object, n);
                    break;
                }
                case 2: {
                    n = this.field.getInt(object);
                    vMXState.ipush(n);
                    this.field.setInt(object, this.expr.evaluateInt(vMXState));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
        return n;
    }

    protected long evaluateLongImpl(VMXState vMXState) {
        long l;
        Object object = this.container == null ? null : this.container.evaluateObject(vMXState);
        try {
            switch (this.assignmentType) {
                case 0: {
                    l = this.expr.evaluateLong(vMXState);
                    this.field.setLong(object, l);
                    break;
                }
                case 1: {
                    vMXState.lpush(this.field.getLong(object));
                    l = this.expr.evaluateLong(vMXState);
                    this.field.setLong(object, l);
                    break;
                }
                case 2: {
                    l = this.field.getLong(object);
                    vMXState.lpush(l);
                    this.field.setLong(object, this.expr.evaluateLong(vMXState));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
        return l;
    }

    protected float evaluateFloatImpl(VMXState vMXState) {
        float f;
        Object object = this.container == null ? null : this.container.evaluateObject(vMXState);
        try {
            switch (this.assignmentType) {
                case 0: {
                    f = this.expr.evaluateFloat(vMXState);
                    this.field.setFloat(object, f);
                    break;
                }
                case 1: {
                    vMXState.fpush(this.field.getFloat(object));
                    f = this.expr.evaluateFloat(vMXState);
                    this.field.setFloat(object, f);
                    break;
                }
                case 2: {
                    f = this.field.getFloat(object);
                    vMXState.fpush(f);
                    this.field.setFloat(object, this.expr.evaluateFloat(vMXState));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
        return f;
    }

    protected double evaluateDoubleImpl(VMXState vMXState) {
        double d;
        Object object = this.container == null ? null : this.container.evaluateObject(vMXState);
        try {
            switch (this.assignmentType) {
                case 0: {
                    d = this.expr.evaluateDouble(vMXState);
                    this.field.setDouble(object, d);
                    break;
                }
                case 1: {
                    vMXState.dpush(this.field.getDouble(object));
                    d = this.expr.evaluateDouble(vMXState);
                    this.field.setDouble(object, d);
                    break;
                }
                case 2: {
                    d = this.field.getDouble(object);
                    vMXState.dpush(d);
                    this.field.setDouble(object, this.expr.evaluateDouble(vMXState));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
        return d;
    }

    protected Object evaluateObjectImpl(VMXState vMXState) {
        Object object;
        Object object2 = this.container == null ? null : this.container.evaluateObject(vMXState);
        try {
            switch (this.assignmentType) {
                case 0: {
                    object = this.expr.evaluateObject(vMXState);
                    this.field.setObject(object2, object);
                    break;
                }
                case 1: {
                    vMXState.apush(this.field.getObject(object2));
                    object = this.expr.evaluateObject(vMXState);
                    this.field.setObject(object2, object);
                    break;
                }
                case 2: {
                    object = this.field.getObject(object2);
                    vMXState.apush(object);
                    this.field.setObject(object2, this.expr.evaluateObject(vMXState));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
        return object;
    }

    public void link(boolean bl) {
        if (Reflection.isStatic((Member)this.field)) {
            if (this.getExpressionCount() == 2) {
                this.container = this.getObjectExpression(0, this.field.getDeclaringType(), bl);
                this.expr = this.getExpression(1, this.etype, bl);
            } else {
                this.checkExpressionCount(1);
                this.container = null;
                this.expr = this.getExpression(0, this.etype, bl);
            }
        } else {
            this.checkExpressionCount(2);
            this.container = this.getObjectExpression(0, this.field.getDeclaringType(), bl);
            this.expr = this.getExpression(1, this.etype, bl);
        }
    }

    protected String paramString() {
        return super.paramString() + ',' + this.field;
    }

    void useAccessMethod(CClass cClass) {
        cClass.getAccessMethodFor((Member)this.field, true);
        this.accessMethodClass = cClass;
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        boolean bl2 = Reflection.isStatic((Member)this.field);
        if (this.container != null) {
            this.container.write(bytecodeWriter, bl2);
        }
        AccessMethod accessMethod = this.accessMethodClass != null ? this.accessMethodClass.getAccessMethodFor((Member)this.field, false) : null;
        AccessMethod accessMethod2 = this.accessMethodClass != null ? this.accessMethodClass.getAccessMethodFor((Member)this.field, true) : null;
        switch (this.assignmentType) {
            case 0: {
                this.expr.write(bytecodeWriter, false);
                if (!bl) {
                    if (bl2) {
                        bytecodeWriter.visitDup(this.etype);
                    } else {
                        bytecodeWriter.visitDupX1(this.etype);
                    }
                }
                bytecodeWriter.visitFieldInsn(bl2 ? 179 : 181, this.field, accessMethod2);
                break;
            }
            case 2: {
                if (!bl) {
                    if (bl2) {
                        bytecodeWriter.visitFieldInsn(178, this.field, accessMethod);
                        bytecodeWriter.visitDup(this.etype);
                        this.expr.write(bytecodeWriter, false);
                        bytecodeWriter.visitFieldInsn(179, this.field, accessMethod2);
                        break;
                    }
                    bytecodeWriter.visitInsn(89);
                    bytecodeWriter.visitFieldInsn(180, this.field, accessMethod);
                    bytecodeWriter.visitDupX1(this.etype);
                    this.expr.write(bytecodeWriter, false);
                    bytecodeWriter.visitFieldInsn(181, this.field, accessMethod2);
                    break;
                }
            }
            case 1: {
                if (bl2) {
                    bytecodeWriter.visitFieldInsn(178, this.field, accessMethod);
                    this.expr.write(bytecodeWriter, false);
                    if (!bl) {
                        bytecodeWriter.visitDup(this.etype);
                    }
                    bytecodeWriter.visitFieldInsn(179, this.field, accessMethod2);
                    break;
                }
                bytecodeWriter.visitInsn(89);
                bytecodeWriter.visitFieldInsn(180, this.field, accessMethod);
                this.expr.write(bytecodeWriter, false);
                if (!bl) {
                    bytecodeWriter.visitDupX1(this.etype);
                }
                bytecodeWriter.visitFieldInsn(181, this.field, accessMethod2);
            }
        }
    }
}

