/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.scope.Scope;
import de.grogra.xl.expr.ConstExpression;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.IllegalOperandTypeException;

public abstract class BinaryExpression
extends ConstExpression {
    protected Expression expr1;
    protected Expression expr2;

    public BinaryExpression(Type type) {
        super(type);
    }

    public BinaryExpression() {
    }

    public abstract int getSupportedTypes();

    public int getSupportedTypes(int n) {
        return n == 0 || n == 1 ? this.getSupportedTypes() : 0;
    }

    public void link(boolean bl) {
        this.checkExpressionCount(2);
        this.expr1 = this.getExpression(0, this.etype, bl);
        this.expr2 = this.getExpression(1, this.etype, bl);
    }

    public Expression compile(Scope scope, Expression expression, Expression expression2) {
        int n = this.getPromotedType(expression, expression2);
        int n2 = this.getSupportedTypes();
        if (n >= 0 && n != 0) {
            int n3 = n;
            while (Reflection.isWideningConversion((int)n, (int)n3)) {
                if ((1 << n3 & n2) != 0) {
                    Type type = Reflection.getType((int)n3);
                    if (this.getType() == null) {
                        this.setType(type);
                    }
                    this.add(expression.unboxingConversion().implicitConversion(scope, type));
                    this.add(expression2.unboxingConversion().implicitConversion(scope, type));
                    return this;
                }
                ++n3;
            }
        }
        throw new IllegalOperandTypeException(I18N.msg("expr.illegal-optype", (Object)this.getClass().getName()));
    }

    protected void writeOperator(BytecodeWriter bytecodeWriter) {
        bytecodeWriter.visitInsn(this.opcode(this.getOpcodes()));
    }

    protected int[] getOpcodes() {
        throw new AssertionError((Object)("Method not implemented in " + this.getClass()));
    }
}

