/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.Compiler;
import de.grogra.xl.expr.Constant;
import de.grogra.xl.expr.EvalExpression;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.ObjectConst;
import de.grogra.xl.vmx.VMXState;

public strictfp final class Cast
extends EvalExpression {
    private Expression expr;
    private static final int[] X2L = new int[]{133, 0, 140, 143};
    private static final int[] X2F = new int[]{134, 137, 0, 144};
    private static final int[] X2D = new int[]{135, 138, 141, 0};

    public Cast(Type type) {
        super(type);
    }

    protected boolean evaluateBooleanImpl(VMXState vMXState) {
        switch (this.expr.etype) {
            case 2: {
                return this.expr.evaluateBoolean(vMXState);
            }
            case 3: {
                return this.expr.evaluateByte(vMXState) != 0;
            }
            case 4: {
                return this.expr.evaluateShort(vMXState) != 0;
            }
            case 5: {
                return this.expr.evaluateChar(vMXState) != '\u0000';
            }
            case 6: {
                return this.expr.evaluateInt(vMXState) != 0;
            }
            case 7: {
                return this.expr.evaluateLong(vMXState) != 0L;
            }
            case 8: {
                return this.expr.evaluateFloat(vMXState) != 0.0f;
            }
            case 9: {
                return this.expr.evaluateDouble(vMXState) != 0.0;
            }
        }
        throw new AssertionError((Object)"Unsupported cast");
    }

    protected byte evaluateByteImpl(VMXState vMXState) {
        switch (this.expr.etype) {
            case 2: {
                return (byte)(this.expr.evaluateBoolean(vMXState) ? 1 : 0);
            }
            case 3: {
                return this.expr.evaluateByte(vMXState);
            }
            case 4: {
                return (byte)this.expr.evaluateShort(vMXState);
            }
            case 5: {
                return (byte)this.expr.evaluateChar(vMXState);
            }
            case 6: {
                return (byte)this.expr.evaluateInt(vMXState);
            }
            case 7: {
                return (byte)this.expr.evaluateLong(vMXState);
            }
            case 8: {
                return (byte)this.expr.evaluateFloat(vMXState);
            }
            case 9: {
                return (byte)this.expr.evaluateDouble(vMXState);
            }
        }
        throw new AssertionError((Object)"Unsupported cast");
    }

    protected short evaluateShortImpl(VMXState vMXState) {
        switch (this.expr.etype) {
            case 2: {
                return (short)(this.expr.evaluateBoolean(vMXState) ? 1 : 0);
            }
            case 3: {
                return this.expr.evaluateByte(vMXState);
            }
            case 4: {
                return this.expr.evaluateShort(vMXState);
            }
            case 5: {
                return (short)this.expr.evaluateChar(vMXState);
            }
            case 6: {
                return (short)this.expr.evaluateInt(vMXState);
            }
            case 7: {
                return (short)this.expr.evaluateLong(vMXState);
            }
            case 8: {
                return (short)this.expr.evaluateFloat(vMXState);
            }
            case 9: {
                return (short)this.expr.evaluateDouble(vMXState);
            }
        }
        throw new AssertionError((Object)"Unsupported cast");
    }

    protected char evaluateCharImpl(VMXState vMXState) {
        switch (this.expr.etype) {
            case 2: {
                return (char)(this.expr.evaluateBoolean(vMXState) ? 1 : 0);
            }
            case 3: {
                return (char)this.expr.evaluateByte(vMXState);
            }
            case 4: {
                return (char)this.expr.evaluateShort(vMXState);
            }
            case 5: {
                return this.expr.evaluateChar(vMXState);
            }
            case 6: {
                return (char)this.expr.evaluateInt(vMXState);
            }
            case 7: {
                return (char)this.expr.evaluateLong(vMXState);
            }
            case 8: {
                return (char)this.expr.evaluateFloat(vMXState);
            }
            case 9: {
                return (char)this.expr.evaluateDouble(vMXState);
            }
        }
        throw new AssertionError((Object)"Unsupported cast");
    }

    protected int evaluateIntImpl(VMXState vMXState) {
        switch (this.expr.etype) {
            case 2: {
                return this.expr.evaluateBoolean(vMXState) ? 1 : 0;
            }
            case 3: {
                return this.expr.evaluateByte(vMXState);
            }
            case 4: {
                return this.expr.evaluateShort(vMXState);
            }
            case 5: {
                return this.expr.evaluateChar(vMXState);
            }
            case 6: {
                return this.expr.evaluateInt(vMXState);
            }
            case 7: {
                return (int)this.expr.evaluateLong(vMXState);
            }
            case 8: {
                return (int)this.expr.evaluateFloat(vMXState);
            }
            case 9: {
                return (int)this.expr.evaluateDouble(vMXState);
            }
        }
        throw new AssertionError((Object)"Unsupported cast");
    }

    protected long evaluateLongImpl(VMXState vMXState) {
        switch (this.expr.etype) {
            case 2: {
                return this.expr.evaluateBoolean(vMXState) ? 1 : 0;
            }
            case 3: {
                return this.expr.evaluateByte(vMXState);
            }
            case 4: {
                return this.expr.evaluateShort(vMXState);
            }
            case 5: {
                return this.expr.evaluateChar(vMXState);
            }
            case 6: {
                return this.expr.evaluateInt(vMXState);
            }
            case 7: {
                return this.expr.evaluateLong(vMXState);
            }
            case 8: {
                return (long)this.expr.evaluateFloat(vMXState);
            }
            case 9: {
                return (long)this.expr.evaluateDouble(vMXState);
            }
        }
        throw new AssertionError((Object)"Unsupported cast");
    }

    protected float evaluateFloatImpl(VMXState vMXState) {
        switch (this.expr.etype) {
            case 2: {
                return this.expr.evaluateBoolean(vMXState) ? 1 : 0;
            }
            case 3: {
                return this.expr.evaluateByte(vMXState);
            }
            case 4: {
                return this.expr.evaluateShort(vMXState);
            }
            case 5: {
                return this.expr.evaluateChar(vMXState);
            }
            case 6: {
                return this.expr.evaluateInt(vMXState);
            }
            case 7: {
                return this.expr.evaluateLong(vMXState);
            }
            case 8: {
                return this.expr.evaluateFloat(vMXState);
            }
            case 9: {
                return (float)this.expr.evaluateDouble(vMXState);
            }
        }
        throw new AssertionError((Object)"Unsupported cast");
    }

    protected double evaluateDoubleImpl(VMXState vMXState) {
        switch (this.expr.etype) {
            case 2: {
                return this.expr.evaluateBoolean(vMXState) ? 1 : 0;
            }
            case 3: {
                return this.expr.evaluateByte(vMXState);
            }
            case 4: {
                return this.expr.evaluateShort(vMXState);
            }
            case 5: {
                return this.expr.evaluateChar(vMXState);
            }
            case 6: {
                return this.expr.evaluateInt(vMXState);
            }
            case 7: {
                return this.expr.evaluateLong(vMXState);
            }
            case 8: {
                return this.expr.evaluateFloat(vMXState);
            }
            case 9: {
                return this.expr.evaluateDouble(vMXState);
            }
        }
        throw new AssertionError((Object)"Unsupported cast");
    }

    protected Object evaluateObjectImpl(VMXState vMXState) {
        Object object = this.expr.evaluateObject(vMXState);
        if (object != null && !this.getType().isInstance(object)) {
            throw new ClassCastException(object + " " + this.getType());
        }
        return object;
    }

    protected void evaluateVoidImpl(VMXState vMXState) {
        this.expr.evaluateAsVoid(vMXState);
    }

    public void link(boolean bl) {
        this.checkExpressionCount(1);
        this.expr = this.getExpression(0);
    }

    public boolean discards(int n) {
        return this.etype == 1;
    }

    public Expression toConst() {
        Expression expression = this.getFirstExpression();
        if (this.etype == 0 && expression instanceof ObjectConst && ((ObjectConst)expression).value == null) {
            ObjectConst objectConst = new ObjectConst(null, this.getType());
            Compiler.copyInfo(this, objectConst);
            return objectConst;
        }
        if ((1 << this.etype & 0x3F8) != 0 && expression instanceof Constant) {
            return this.toConstImpl();
        }
        return this;
    }

    protected void writeOperator(BytecodeWriter bytecodeWriter) {
        int n = this.expr.etype;
        if ((1 << this.etype & 0x7C) != 0) {
            switch (n) {
                case 7: {
                    bytecodeWriter.visitInsn(136);
                    n = 6;
                    break;
                }
                case 8: {
                    bytecodeWriter.visitInsn(139);
                    n = 6;
                    break;
                }
                case 9: {
                    bytecodeWriter.visitInsn(142);
                    n = 6;
                }
            }
            switch (this.etype) {
                case 2: {
                    if (n == 2) break;
                    bytecodeWriter.visitVM2T(2);
                    break;
                }
                case 3: {
                    if (n <= 3) break;
                    bytecodeWriter.visitInsn(145);
                    break;
                }
                case 4: {
                    if (n <= 4) break;
                    bytecodeWriter.visitInsn(147);
                    break;
                }
                case 5: {
                    if (n == 5 || n == 2) break;
                    bytecodeWriter.visitInsn(146);
                }
            }
        } else {
            int n2;
            switch (this.etype) {
                case 7: {
                    n2 = Cast.opcode(n, X2L);
                    break;
                }
                case 8: {
                    n2 = Cast.opcode(n, X2F);
                    break;
                }
                case 9: {
                    n2 = Cast.opcode(n, X2D);
                    break;
                }
                case 0: {
                    if (!Reflection.isAssignableFrom((Type)this.getType(), (Type)this.expr.getType())) {
                        bytecodeWriter.visitCheckCast(this.getType());
                    }
                    return;
                }
                case 1: {
                    return;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (n2 != 0) {
                bytecodeWriter.visitInsn(n2);
            }
        }
    }
}

