/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.scope.Scope;
import de.grogra.xl.expr.ConstExpression;
import de.grogra.xl.expr.Constant;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.IllegalOperandTypeException;
import de.grogra.xl.vmx.VMXState;
import org.objectweb.asm.Label;

public final class Conditional
extends ConstExpression {
    private Expression cond;
    private Expression expr1;
    private Expression expr2;

    public Conditional(Type type) {
        super(type);
    }

    public Conditional() {
    }

    public boolean allowsIteration(int n) {
        return n == 0;
    }

    protected boolean evaluateBooleanImpl(VMXState vMXState) {
        return this.cond.evaluateBoolean(vMXState) ? this.expr1.evaluateBoolean(vMXState) : this.expr2.evaluateBoolean(vMXState);
    }

    protected byte evaluateByteImpl(VMXState vMXState) {
        return this.cond.evaluateBoolean(vMXState) ? this.expr1.evaluateByte(vMXState) : this.expr2.evaluateByte(vMXState);
    }

    protected short evaluateShortImpl(VMXState vMXState) {
        return this.cond.evaluateBoolean(vMXState) ? this.expr1.evaluateShort(vMXState) : this.expr2.evaluateShort(vMXState);
    }

    protected char evaluateCharImpl(VMXState vMXState) {
        return this.cond.evaluateBoolean(vMXState) ? this.expr1.evaluateChar(vMXState) : this.expr2.evaluateChar(vMXState);
    }

    protected int evaluateIntImpl(VMXState vMXState) {
        return this.cond.evaluateBoolean(vMXState) ? this.expr1.evaluateInt(vMXState) : this.expr2.evaluateInt(vMXState);
    }

    protected long evaluateLongImpl(VMXState vMXState) {
        return this.cond.evaluateBoolean(vMXState) ? this.expr1.evaluateLong(vMXState) : this.expr2.evaluateLong(vMXState);
    }

    protected float evaluateFloatImpl(VMXState vMXState) {
        return this.cond.evaluateBoolean(vMXState) ? this.expr1.evaluateFloat(vMXState) : this.expr2.evaluateFloat(vMXState);
    }

    protected double evaluateDoubleImpl(VMXState vMXState) {
        return this.cond.evaluateBoolean(vMXState) ? this.expr1.evaluateDouble(vMXState) : this.expr2.evaluateDouble(vMXState);
    }

    protected Object evaluateObjectImpl(VMXState vMXState) {
        return this.cond.evaluateBoolean(vMXState) ? this.expr1.evaluateObject(vMXState) : this.expr2.evaluateObject(vMXState);
    }

    public void link(boolean bl) {
        this.checkExpressionCount(3);
        this.cond = this.getExpression(0, 2, bl);
        this.expr1 = this.cond.getNextExpression();
        this.expr2 = this.expr1.getNextExpression();
    }

    public Expression compile(Scope scope, Expression expression, Expression expression2, Expression expression3) {
        Object object;
        int n;
        if (expression.etype != 2) {
            throw new IllegalOperandTypeException(I18N.msg("expr.unexpected-type", (Object)expression.getType(), (Object)Type.BOOLEAN));
        }
        int n2 = expression2.etype;
        int n3 = expression3.etype;
        if (n2 == n3) {
            n = n2;
        } else {
            int n4 = 1 << n2 | 1 << n3;
            if ((n4 & 0xFFFFFC07) == 0) {
                Expression expression4;
                boolean bl;
                boolean bl2 = bl = n2 < n3;
                if (bl) {
                    n = n2;
                    n2 = n3;
                    n3 = n;
                    expression4 = expression2;
                    expression2 = expression3;
                    expression3 = expression4;
                }
                if (n2 != 6) {
                    n = n2 == 5 ? 6 : n2;
                } else if (expression2 instanceof Constant) {
                    expression2.linkGraph(true);
                    n2 = expression2.evaluateInt(null);
                    n = 6;
                    switch (n3) {
                        case 3: {
                            if (-128 > n2 || n2 > 127) break;
                            n = 3;
                            break;
                        }
                        case 4: {
                            if (Short.MIN_VALUE > n2 || n2 > Short.MAX_VALUE) break;
                            n = 4;
                            break;
                        }
                        case 5: {
                            if (0 > n2 || n2 > 65535) break;
                            n = 5;
                        }
                    }
                } else {
                    n = 6;
                }
                if (bl) {
                    expression4 = expression2;
                    expression2 = expression3;
                    expression3 = expression4;
                }
            } else {
                n = -1;
            }
        }
        if (n == 0) {
            object = expression2.getType();
            if (!Reflection.isAssignableFrom((Type)object, (Type)expression3.getType())) {
                if (Reflection.isAssignableFrom((Type)expression3.getType(), (Type)object)) {
                    object = expression3.getType();
                } else {
                    n = -1;
                }
            }
        } else {
            object = n >= 0 ? Reflection.getType((int)n) : null;
        }
        if (n < 0) {
            throw new IllegalOperandTypeException(I18N.msg("expr.conditional-incompatible-types", (Object)expression2.getType(), (Object)expression3.getType()));
        }
        if (n != 0) {
            expression2 = expression2.cast(Reflection.getType((int)n));
            expression3 = expression3.cast(Reflection.getType((int)n));
        }
        return this.setType((Type)object).add(expression).add(expression2).add(expression3);
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        Label label = new Label();
        int n = this.cond.writeConditional(bytecodeWriter, label, null);
        switch (n) {
            case 1: {
                this.expr1.write(bytecodeWriter, bl);
                return;
            }
            case -1: {
                bytecodeWriter.visitLabel(label);
                this.expr2.write(bytecodeWriter, bl);
                return;
            }
        }
        this.expr1.write(bytecodeWriter, bl);
        Label label2 = new Label();
        bytecodeWriter.visitJumpInsn(167, label2);
        bytecodeWriter.visitLabel(label);
        this.expr2.write(bytecodeWriter, bl);
        bytecodeWriter.visitLabel(label2);
    }

    public boolean isConditional() {
        return true;
    }

    public int writeConditional(BytecodeWriter bytecodeWriter, Label label, Label label2) {
        boolean bl;
        Label label3 = new Label();
        int n = this.cond.writeConditional(bytecodeWriter, label3, null);
        switch (n) {
            case 1: {
                return this.expr1.writeConditional(bytecodeWriter, label, label2);
            }
            case -1: {
                bytecodeWriter.visitLabel(label3);
                return this.expr2.writeConditional(bytecodeWriter, label, label2);
            }
        }
        boolean bl2 = label == null;
        boolean bl3 = bl = label2 == null;
        if (bl2) {
            label = new Label();
        }
        if (bl) {
            label2 = new Label();
        }
        n = this.expr1.writeConditional(bytecodeWriter, label, label2);
        bytecodeWriter.visitLabel(label3);
        int n2 = this.expr2.writeConditional(bytecodeWriter, bl2 ? null : label, bl ? null : label2);
        if (bl2) {
            bytecodeWriter.visitLabel(label);
        }
        if (bl) {
            bytecodeWriter.visitLabel(label2);
        }
        return n == n2 ? n : 0;
    }
}

