/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.Field;
import de.grogra.reflect.Member;
import de.grogra.reflect.Reflection;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.CClass;
import de.grogra.xl.expr.AssignField;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.Variable;
import de.grogra.xl.vmx.VMXState;

public class GetField
extends Variable {
    final Field field;
    Expression expr;
    private CClass accessMethodClass;

    public GetField(Field field) {
        super(field.getType());
        this.field = field;
    }

    public Field getField() {
        return this.field;
    }

    public boolean isRequired(int n) {
        return !Reflection.isStatic((Member)this.field);
    }

    protected boolean evaluateBooleanImpl(VMXState vMXState) {
        try {
            return this.field.getBoolean(this.expr != null ? this.expr.evaluateObject(vMXState) : null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
    }

    protected byte evaluateByteImpl(VMXState vMXState) {
        try {
            return this.field.getByte(this.expr != null ? this.expr.evaluateObject(vMXState) : null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
    }

    protected short evaluateShortImpl(VMXState vMXState) {
        try {
            return this.field.getShort(this.expr != null ? this.expr.evaluateObject(vMXState) : null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
    }

    protected char evaluateCharImpl(VMXState vMXState) {
        try {
            return this.field.getChar(this.expr != null ? this.expr.evaluateObject(vMXState) : null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
    }

    protected int evaluateIntImpl(VMXState vMXState) {
        try {
            return this.field.getInt(this.expr != null ? this.expr.evaluateObject(vMXState) : null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
    }

    protected long evaluateLongImpl(VMXState vMXState) {
        try {
            return this.field.getLong(this.expr != null ? this.expr.evaluateObject(vMXState) : null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
    }

    protected float evaluateFloatImpl(VMXState vMXState) {
        try {
            return this.field.getFloat(this.expr != null ? this.expr.evaluateObject(vMXState) : null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
    }

    protected double evaluateDoubleImpl(VMXState vMXState) {
        try {
            return this.field.getDouble(this.expr != null ? this.expr.evaluateObject(vMXState) : null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
    }

    protected Object evaluateObjectImpl(VMXState vMXState) {
        try {
            return this.field.getObject(this.expr != null ? this.expr.evaluateObject(vMXState) : null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
    }

    public void link(boolean bl) {
        if (Reflection.isStatic((Member)this.field)) {
            this.expr = this.getFirstExpression();
        } else {
            this.checkExpressionCount(1);
            this.expr = this.getExpression(0, 0, bl);
        }
    }

    public Expression toAssignment(int n) {
        AssignField assignField = new AssignField(this.field, n);
        if (this.accessMethodClass != null) {
            assignField.useAccessMethod(this.accessMethodClass);
        }
        assignField.receiveChildren(this);
        return assignField;
    }

    protected String paramString() {
        return super.paramString() + ',' + this.field;
    }

    public void useAccessMethod(CClass cClass) {
        cClass.getAccessMethodFor((Member)this.field, false);
        this.accessMethodClass = cClass;
    }

    protected void writeOperator(BytecodeWriter bytecodeWriter) {
        bytecodeWriter.visitFieldInsn(Reflection.isStatic((Member)this.field) ? 178 : 180, this.field, this.accessMethodClass == null ? null : this.accessMethodClass.getAccessMethodFor((Member)this.field, false));
    }
}

