/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.Type;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.expr.AssignLocal;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.LocalValue;
import de.grogra.xl.expr.Variable;
import de.grogra.xl.vmx.VMXState;

public class GetLocal
extends Variable
implements LocalValue {
    private VMXState.Local local;
    private Local clocal;

    public GetLocal(VMXState.Local local, Type type) {
        super(type);
        this.local = local;
    }

    public GetLocal(Local local) {
        super(local.getType());
        this.clocal = local;
    }

    protected boolean evaluateBooleanImpl(VMXState vMXState) {
        return vMXState.iget(this.local, null) != 0;
    }

    protected byte evaluateByteImpl(VMXState vMXState) {
        return (byte)vMXState.iget(this.local, null);
    }

    protected short evaluateShortImpl(VMXState vMXState) {
        return (short)vMXState.iget(this.local, null);
    }

    protected char evaluateCharImpl(VMXState vMXState) {
        return (char)vMXState.iget(this.local, null);
    }

    protected int evaluateIntImpl(VMXState vMXState) {
        return vMXState.iget(this.local, null);
    }

    protected long evaluateLongImpl(VMXState vMXState) {
        return vMXState.lget(this.local, null);
    }

    protected float evaluateFloatImpl(VMXState vMXState) {
        return vMXState.fget(this.local, null);
    }

    protected double evaluateDoubleImpl(VMXState vMXState) {
        return vMXState.dget(this.local, null);
    }

    protected Object evaluateObjectImpl(VMXState vMXState) {
        assert (vMXState.aget(this.local, null) == null || this.getType().isInstance(vMXState.aget(this.local, null)) || vMXState.aget(this.local, null) instanceof Type) : vMXState.aget(this.local, null) + " " + this.getType();
        return vMXState.aget(this.local, null);
    }

    public Expression toAssignment(int n) {
        return this.clocal != null ? new AssignLocal(this.clocal, n) : new AssignLocal(this.local, this.getType(), n);
    }

    public int getLocalCount() {
        return 1;
    }

    public int getAccessType(int n) {
        return 2;
    }

    public Local getLocal(int n) {
        return this.clocal;
    }

    public void setLocal(int n, Local local) {
        this.clocal = local;
    }

    public void complete(MethodScope methodScope) {
        this.local = this.clocal.createVMXLocal();
    }

    protected String paramString() {
        return super.paramString() + ',' + this.local + ',' + this.clocal;
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        if (!bl) {
            bytecodeWriter.visitLoad(this.local, this.getType());
        }
    }
}

