/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.IntersectionType;
import de.grogra.reflect.Member;
import de.grogra.reflect.Method;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Signature;
import de.grogra.reflect.Type;
import de.grogra.util.Int2ObjectMap;
import de.grogra.xl.compiler.AccessMethod;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.CClass;
import de.grogra.xl.compiler.XMethod;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.compiler.scope.TypeScope;
import de.grogra.xl.expr.Break;
import de.grogra.xl.expr.BreakTarget;
import de.grogra.xl.expr.Completable;
import de.grogra.xl.expr.ControlTransfer;
import de.grogra.xl.expr.EvalExpression;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.MethodExpression;
import de.grogra.xl.expr.NonlocalGenerator;
import de.grogra.xl.expr.Return;
import de.grogra.xl.vmx.AbruptCompletion;
import de.grogra.xl.vmx.Routine;
import de.grogra.xl.vmx.VMXState;
import org.objectweb.asm.Label;

public abstract class Invoke
extends EvalExpression
implements NonlocalGenerator,
Completable {
    protected final Type targetType;
    protected String descriptor;
    final int size;
    private final boolean isStatic;
    private boolean generator;
    private final Method method;
    private AccessMethod accessMethod;
    private XMethod invokeMethod;
    private Int2ObjectMap transfers;

    public Invoke(Method method) {
        super("<init>".equals(method.getSimpleName()) ? method.getDeclaringType() : method.getReturnType());
        this.targetType = method.getDeclaringType();
        this.method = method;
        this.isStatic = Reflection.isStatic((Member)method);
        this.size = Reflection.getJVMStackSize((Type[])Reflection.getParameterTypes((Signature)method)) + ((method.getModifiers() & 8) == 0 ? 1 : 0);
    }

    public Method getOriginalMethod() {
        return this.method;
    }

    public void complete(MethodScope methodScope) {
        this.descriptor = this.method.getDescriptor();
    }

    protected abstract Method getMethod(VMXState var1);

    protected void pushParameters(VMXState vMXState) {
        for (Expression expression = this.getFirstExpression(); expression != null; expression = expression.getNextExpression()) {
            expression.push(vMXState);
        }
    }

    public AbruptCompletion.Return evaluateRet(VMXState vMXState) {
        this.pushParameters(vMXState);
        Method method = this.getMethod(vMXState);
        if (method instanceof MethodExpression) {
            ((MethodExpression)method).linkGraph(true);
        }
        if (this.generator) {
            try {
                if (method instanceof MethodExpression) {
                    return vMXState.invoke((Routine)((MethodExpression)method), -1, null);
                }
                return vMXState.invoke(method);
            }
            catch (AbruptCompletion.Nonlocal nonlocal) {
                throw nonlocal.getReason(null);
            }
        }
        if (method instanceof MethodExpression) {
            return vMXState.invoke((Routine)((MethodExpression)method), -1, null);
        }
        return vMXState.invoke(method);
    }

    protected final boolean evaluateBooleanImpl(VMXState vMXState) {
        return this.evaluateRet(vMXState).iget() != 0;
    }

    protected final byte evaluateByteImpl(VMXState vMXState) {
        return (byte)this.evaluateRet(vMXState).iget();
    }

    protected final short evaluateShortImpl(VMXState vMXState) {
        return (short)this.evaluateRet(vMXState).iget();
    }

    protected final char evaluateCharImpl(VMXState vMXState) {
        return (char)this.evaluateRet(vMXState).iget();
    }

    protected final int evaluateIntImpl(VMXState vMXState) {
        return this.evaluateRet(vMXState).iget();
    }

    protected final long evaluateLongImpl(VMXState vMXState) {
        return this.evaluateRet(vMXState).lget();
    }

    protected final float evaluateFloatImpl(VMXState vMXState) {
        return this.evaluateRet(vMXState).fget();
    }

    protected final double evaluateDoubleImpl(VMXState vMXState) {
        return this.evaluateRet(vMXState).dget();
    }

    protected final Object evaluateObjectImpl(VMXState vMXState) {
        return this.evaluateRet(vMXState).aget();
    }

    protected final void evaluateVoidImpl(VMXState vMXState) {
        this.evaluateRet(vMXState);
    }

    public void setGenerator() {
        this.generator = true;
        this.transfers = new Int2ObjectMap();
        this.transfers.put(-2, null);
        this.setType(XMethod.getGeneratorType(this.method));
    }

    protected void checkSetType(Type type) {
        if (!this.generator) {
            super.checkSetType(type);
        }
    }

    public int getGeneratorType() {
        return this.generator ? 2 : 0;
    }

    public void receiveRoutine(TypeScope typeScope, Expression expression) {
        CClass cClass = typeScope.getDeclaredType().getCallbackClass();
        int n = Reflection.isStatic((Member)this.method) ? 0 : 1;
        final Type[] typeArray = new Type[this.method.getParameterCount() + n];
        for (int i = this.method.getParameterCount() - 1; i >= 0; --i) {
            typeArray[i + n] = this.method.getParameterType(i);
        }
        if (n > 0) {
            typeArray[0] = Reflection.getBinaryType((Type)this.getExpression(0).getType());
        }
        this.invokeMethod = new XMethod(Reflection.getSyntheticName((Member[])Reflection.getDeclaredMethods((Type)cClass), (String)("invoke$" + this.method.getSimpleName())), 4120L, cClass, typeArray, ABRUPT_COMPLETION_TYPE, new Expression(){

            protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
                int n = 0;
                for (int i = 0; i < typeArray.length; ++i) {
                    bytecodeWriter.visitLoad(n, typeArray[i].getTypeId());
                    n += Reflection.getJVMStackSize((Type)typeArray[i]);
                }
                Label label = new Label();
                bytecodeWriter.visitLabel(label);
                Invoke.this.writeInvocation(bytecodeWriter, false);
                bytecodeWriter.visitPop(Invoke.this.method.getReturnType().getTypeId());
                Label label2 = new Label();
                bytecodeWriter.visitLabel(label2);
                bytecodeWriter.visitInsn(1);
                bytecodeWriter.visitInsn(176);
                Label label3 = new Label();
                bytecodeWriter.visitLabel(label3);
                bytecodeWriter.visitTryCatchBlock(label, label2, label3, bytecodeWriter.toName(NONLOCAL_TYPE));
                bytecodeWriter.visitaconst(null);
                bytecodeWriter.visitMethodInsn(NONLOCAL_TYPE, "getReason");
                bytecodeWriter.visitInsn(176);
            }
        });
        this.insertBranchNode(this.isStatic ? 0 : 1, expression);
    }

    public void addTransfer(ControlTransfer controlTransfer) {
        if (controlTransfer instanceof Return) {
            this.transfers.put(-1, (Object)controlTransfer);
        } else {
            this.transfers.put(((Break)controlTransfer).getLabel(), (Object)controlTransfer);
        }
    }

    public void receiveConsumer(Expression expression) {
        assert (this.generator);
        this.setType(this.method.getReturnType());
        this.generator = false;
        this.insertBranchNode(this.isStatic ? 0 : 1, expression);
    }

    public void setBreakTarget(BreakTarget breakTarget) {
    }

    protected String paramString() {
        return super.paramString() + ',' + this.method.getDescriptor() + ',' + this.method.getDeclaringType().getBinaryName();
    }

    public void useAccessMethod(CClass cClass) {
        this.accessMethod = cClass.getAccessMethodFor((Member)this.method, false);
    }

    protected abstract int getOpcode();

    void writeInvocation(BytecodeWriter bytecodeWriter, boolean bl) {
        if (this.accessMethod != null) {
            for (int i = this.accessMethod.getAdditionalArgumentCount(); i > 0; --i) {
                bytecodeWriter.visitInsn(1);
            }
            String string = this.accessMethod.getName();
            bytecodeWriter.visitMethodInsn("<init>".equals(string) ? 183 : 184, bytecodeWriter.toName((Type)this.accessMethod.getDeclaringClass()), string, this.accessMethod.getDescriptor());
        } else {
            bytecodeWriter.visitMethodInsn(this.getOpcode(), this.method);
        }
        if (bl) {
            bytecodeWriter.visitPop(this.etype);
        }
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        int n;
        Expression expression;
        boolean bl2 = this.getOpcode() == 185;
        for (expression = this.getFirstExpression(); expression != null; expression = expression.getNextExpression()) {
            expression.write(bytecodeWriter, false);
            if (!bl2) continue;
            bl2 = false;
            if (!(expression.getType() instanceof IntersectionType)) continue;
            bytecodeWriter.visitCheckCast(this.method.getDeclaringType());
        }
        if (!this.generator) {
            this.writeInvocation(bytecodeWriter, bl);
            return;
        }
        assert (bl);
        bytecodeWriter.visitMethodInsn(184, this.invokeMethod);
        bytecodeWriter.visitInsn(89);
        expression = new Label();
        bytecodeWriter.visitJumpInsn(198, (Label)expression);
        bytecodeWriter.visitInsn(89);
        bytecodeWriter.visitMethodInsn(ABRUPT_COMPLETION_TYPE, "getLabel");
        Label label = new Label();
        int[] nArray = this.transfers.getKeys(null);
        Label[] labelArray = new Label[nArray.length];
        for (n = 0; n < labelArray.length; ++n) {
            labelArray[n] = new Label();
        }
        bytecodeWriter.visitLookupSwitchInsn(label, nArray, labelArray);
        block6: for (n = 0; n < labelArray.length; ++n) {
            bytecodeWriter.visitLabel(labelArray[n]);
            ControlTransfer controlTransfer = (ControlTransfer)this.transfers.getValueAt(n);
            switch (nArray[n]) {
                case -2: {
                    bytecodeWriter.visitTypeInsn(192, bytecodeWriter.toName(THROW_TYPE));
                    bytecodeWriter.visitMethodInsn(THROW_TYPE, "getCauseAndDispose");
                    bytecodeWriter.visitInsn(191);
                    continue block6;
                }
                case -1: {
                    bytecodeWriter.visitTypeInsn(192, bytecodeWriter.toName(RETURN_TYPE));
                    Type type = ((Return)controlTransfer).getScope().getMethod().getReturnType();
                    bytecodeWriter.visitMethodInsn(RETURN_TYPE, Reflection.getJVMPrefix((Type)type) + "get");
                    bytecodeWriter.visitCheckCast(type);
                    controlTransfer.writeLocal(bytecodeWriter, this);
                    continue block6;
                }
                default: {
                    bytecodeWriter.visitMethodInsn(182, bytecodeWriter.toName(ABRUPT_COMPLETION_TYPE), "dispose", "()V");
                    controlTransfer.writeLocal(bytecodeWriter, this);
                }
            }
        }
        bytecodeWriter.visitLabel(label);
        bytecodeWriter.visitTypeInsn(187, "java/lang/AssertionError");
        bytecodeWriter.visitInsn(90);
        bytecodeWriter.visitInsn(95);
        bytecodeWriter.visitMethodInsn(183, "java/lang/AssertionError", "<init>", "(Ljava/lang/Object;)V");
        bytecodeWriter.visitInsn(191);
        bytecodeWriter.visitLabel((Label)expression);
        bytecodeWriter.visitInsn(87);
    }
}

