/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.expr.BreakTarget;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.Generator;
import de.grogra.xl.expr.LocalAccess;
import de.grogra.xl.vmx.VMXState;
import java.util.Iterator;
import org.objectweb.asm.Label;

public final class IterableGenerator
extends Expression
implements Generator,
LocalAccess {
    private Expression iterator;
    private Expression statement;
    private Local iter;
    private VMXState.Local vmxIter;
    private static final Type ITERATOR_TYPE = ClassAdapter.wrap(Iterator.class);

    public IterableGenerator(Type type, Local local) {
        super(type);
        this.iter = local;
    }

    protected Object evaluateObjectImpl(VMXState vMXState) {
        Iterator iterator = (Iterator)this.iterator.evaluateObject(vMXState);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e != null && !this.getType().isInstance(e)) {
                throw new ClassCastException(e + " " + this.getType());
            }
            vMXState.apush(e);
            this.statement.evaluateAsVoid(vMXState);
        }
        return null;
    }

    public int getLocalCount() {
        return 1;
    }

    public int getAccessType(int n) {
        return 10;
    }

    public Local getLocal(int n) {
        return this.iter;
    }

    public void setLocal(int n, Local local) {
        this.iter = local;
    }

    public void complete(MethodScope methodScope) {
        this.vmxIter = this.iter.createVMXLocal();
    }

    public int getGeneratorType() {
        return 1;
    }

    public void setBreakTarget(BreakTarget breakTarget) {
    }

    public void link(boolean bl) {
        this.checkExpressionCount(2);
        this.iterator = this.getObjectExpression(0, ITERATOR_TYPE, bl);
        this.statement = this.iterator.getNextExpression();
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        assert (bl);
        this.iterator.write(bytecodeWriter, false);
        bytecodeWriter.visitStore(this.vmxIter, ITERATOR_TYPE);
        Label label = new Label();
        Label label2 = new Label();
        bytecodeWriter.visitJumpInsn(167, label2);
        bytecodeWriter.visitLabel(label);
        bytecodeWriter.visitLoad(this.vmxIter, ITERATOR_TYPE);
        bytecodeWriter.visitMethodInsn(Iterator.class, "next");
        bytecodeWriter.visitCheckCast(this.getType());
        this.statement.write(bytecodeWriter, true);
        bytecodeWriter.visitLabel(label2);
        bytecodeWriter.visitLoad(this.vmxIter, ITERATOR_TYPE);
        bytecodeWriter.visitMethodInsn(Iterator.class, "hasNext");
        bytecodeWriter.visitJumpInsn(154, label);
    }
}

