/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.data;

import de.grogra.pf.data.Datacell;
import de.grogra.pf.data.Dataset;
import de.grogra.pf.data.DatasetAdapterBase;
import java.util.ArrayList;
import org.jfree.data.statistics.HistogramBin;
import org.jfree.data.xy.IntervalXYDataset;

public final class HistogramAdapter
extends DatasetAdapterBase
implements IntervalXYDataset {
    public HistogramAdapter(Dataset dataset) {
        super(dataset);
    }

    public double getXValue(int n, int n2) {
        ArrayList<HistogramBin> arrayList = this.dataset.getBins(n);
        HistogramBin histogramBin = arrayList.get(n2);
        return 0.5 * (histogramBin.getStartBoundary() + histogramBin.getEndBoundary());
    }

    public double getStartXValue(int n, int n2) {
        ArrayList<HistogramBin> arrayList = this.dataset.getBins(n);
        return arrayList.get(n2).getStartBoundary();
    }

    public double getEndXValue(int n, int n2) {
        ArrayList<HistogramBin> arrayList = this.dataset.getBins(n);
        return arrayList.get(n2).getEndBoundary();
    }

    public double getYValue(int n, int n2) {
        HistogramBin histogramBin = this.dataset.getBins(n).get(n2);
        double d = 0.0;
        int n3 = 0;
        while (this.dataset.hasCell0(n3, n)) {
            double d2;
            Datacell datacell = this.dataset.getCell0(n3, n);
            if (!datacell.isXNull() && (d2 = datacell.getX()) <= histogramBin.getEndBoundary() && (n2 == 0 ? d2 >= histogramBin.getStartBoundary() : d2 > histogramBin.getStartBoundary())) {
                if (datacell.isScalar()) {
                    d += 1.0;
                } else if (!datacell.isYNull()) {
                    d += datacell.getY();
                }
            }
            ++n3;
        }
        return d;
    }

    public int getItemCount(int n) {
        ArrayList<HistogramBin> arrayList = this.dataset.getBins(n);
        return arrayList.size();
    }

    public Number getEndX(int n, int n2) {
        return this.getEndXValue(n, n2);
    }

    public Number getEndY(int n, int n2) {
        return this.getY(n, n2);
    }

    public double getEndYValue(int n, int n2) {
        return this.getYValue(n, n2);
    }

    public Number getStartX(int n, int n2) {
        return this.getStartXValue(n, n2);
    }

    public Number getStartY(int n, int n2) {
        return this.getY(n, n2);
    }

    public double getStartYValue(int n, int n2) {
        return this.getYValue(n, n2);
    }

    public Number getX(int n, int n2) {
        return this.getXValue(n, n2);
    }

    public Number getY(int n, int n2) {
        return this.getYValue(n, n2);
    }
}

