/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.edit;

import de.grogra.icon.IconSource;
import de.grogra.pf.ui.ComponentWrapper;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.UIProperty;
import de.grogra.pf.ui.Widget;
import de.grogra.pf.ui.edit.Property;
import de.grogra.pf.ui.edit.Selection;
import de.grogra.pf.ui.event.ActionEditEvent;
import de.grogra.pf.ui.registry.PanelFactory;
import de.grogra.pf.ui.tree.UITree;
import de.grogra.pf.ui.util.WidgetAdapter;
import de.grogra.util.Described;
import de.grogra.util.MutableTree;
import de.grogra.util.Tree;
import de.grogra.util.Utils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.tree.TreePath;

public abstract class PropertyEditorTree
extends MutableTree
implements UITree {
    private final Context context;
    private boolean menu;

    public PropertyEditorTree(Context context) {
        super((Tree.Node)new Node());
        this.context = context;
    }

    public void setMenu() {
        this.menu = true;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isMenu() {
        return this.menu;
    }

    protected void fireChanged(Object object) {
        ((Node)this.root).fireChanged(object);
    }

    protected abstract boolean isNodeAffectedBy(PropertyNode var1, Object var2);

    public Object getDescription(Object object, String string) {
        Node node = (Node)((Object)object);
        return node.described != null ? node.described.getDescription(string) : (Utils.isStringDescription((String)string) ? node.text : ("Icon".equals(string) ? node.icon : null));
    }

    public boolean nodesEqual(Object object, Object object2) {
        return object == object2;
    }

    public int getType(Object object) {
        return ((Node)((Object)object)).children == null ? 2 : 17;
    }

    public String getName(Object object) {
        return (String)this.getDescription(object, "Name");
    }

    public boolean isAvailable(Object object) {
        return true;
    }

    public boolean isEnabled(Object object) {
        return ((Node)((Object)object)).isEnabled();
    }

    public Object resolveLink(Object object) {
        return object;
    }

    public void eventOccured(Object object, EventObject eventObject) {
        if (object instanceof SelectionNode && eventObject instanceof ActionEditEvent) {
            PanelFactory.getAndShowPanel((Context)((Object)eventObject), "/ui/panels/attributeeditor", null);
            UIProperty.WORKBENCH_SELECTION.setValue(this.context, ((SelectionNode)((Object)object)).sel);
        }
    }

    public Object invoke(Object object, String string, Object object2) {
        if ("createComponentWrapper".equals(string)) {
            return ((Node)((Object)object)).createComponent();
        }
        if ("updateComponentWrapper".equals(string)) {
            ((Node)((Object)object)).updateComponent((ComponentWrapper)object2);
        }
        return null;
    }

    public void update() {
    }

    public class PropertyNode
    extends Node
    implements PropertyChangeListener {
        private final Property property;
        private final Widget widget;

        public PropertyNode(Property property, Widget widget, String string) {
            this.widget = widget != null ? new WidgetAdapter(widget, property.getContext()) : null;
            this.property = property;
            this.text = string;
        }

        public Property getProperty() {
            return this.property;
        }

        protected ComponentWrapper createComponent() {
            this.widget.addPropertyChangeListener(this);
            this.updateComponent(this.widget);
            return this.widget;
        }

        protected void updateComponent(ComponentWrapper componentWrapper) {
            ((Widget)componentWrapper).updateValue(this.toWidget(this.property.getValue()));
        }

        protected Object toWidget(Object object) {
            return object;
        }

        protected Object fromWidget(Object object) {
            return object;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            try {
                this.property.setValue(this.fromWidget(propertyChangeEvent.getNewValue()));
            }
            catch (InterruptedException interruptedException) {
                System.err.println(interruptedException);
            }
        }

        protected boolean isEnabled() {
            return this.property.isWritable();
        }

        void fireChanged(Object object) {
            if (PropertyEditorTree.this.isNodeAffectedBy(this, object)) {
                PropertyEditorTree.this.valueForPathChanged(this.getTreePath(), object);
                super.fireChanged(object);
            }
        }

        public String toString() {
            return "PropertyNode[" + this.property + ']';
        }
    }

    public static class SelectionNode
    extends Node {
        final Selection sel;

        public SelectionNode(Selection selection) {
            this.sel = selection;
            this.described = UI.I18N.keyToDescribed("selection.edit");
        }
    }

    public static class Node
    extends Tree.Node {
        String text;
        IconSource icon;
        Described described;
        private TreePath path;

        public void setDecription(Described described) {
            this.described = described;
        }

        public void setText(String string) {
            this.text = string;
        }

        protected boolean isEnabled() {
            return true;
        }

        public TreePath getTreePath() {
            if (this.path == null) {
                this.path = this.parent == null ? new TreePath((Object)this) : this.parent.getTreePath().pathByAddingChild((Object)this);
            }
            return this.path;
        }

        protected ComponentWrapper createComponent() {
            return null;
        }

        protected void updateComponent(ComponentWrapper componentWrapper) {
        }

        void fireChanged(Object object) {
            Node node = (Node)this.children;
            while (node != null) {
                node.fireChanged(object);
                node = (Node)node.next;
            }
        }
    }
}

