/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.edit;

import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ItemCriterion;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.ComponentWrapper;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.UIProperty;
import de.grogra.pf.ui.UIToolkit;
import de.grogra.pf.ui.edit.Property;
import de.grogra.pf.ui.edit.PropertyEditor;
import de.grogra.pf.ui.edit.PropertyEditorTree;
import de.grogra.pf.ui.edit.Selection;
import de.grogra.pf.ui.tree.UITree;
import de.grogra.util.MutableTreeModel;
import de.grogra.util.TreeBuilder;
import java.awt.datatransfer.Transferable;
import java.util.List;
import javax.swing.tree.TreeModel;

public abstract class SelectionBase
implements Selection {
    protected final Context context;

    public SelectionBase(Context context) {
        this.context = context;
    }

    public void remove() {
        UIProperty.WORKBENCH_SELECTION.setValue(this.context, null);
    }

    public int getCapabilities() {
        return 0;
    }

    public Context getContext() {
        return this.context;
    }

    protected PropertyEditor getEditorFor(Property property, Item item) {
        PropertyEditor propertyEditor = property.getEditor();
        if (propertyEditor == null && item != null) {
            propertyEditor = (PropertyEditor)item.findFirst(ItemCriterion.INSTANCE_OF, PropertyEditor.class, true);
        }
        if (propertyEditor == null) {
            propertyEditor = PropertyEditor.findEditor((RegistryContext)UI.getRegistry(this.context), property.getType(), true);
        }
        return propertyEditor;
    }

    protected PropertyEditorTree.Node createPropertyNodes(PropertyEditorTree propertyEditorTree, Property property, Item item) {
        PropertyEditor propertyEditor = this.getEditorFor(property, item);
        return propertyEditor != null ? propertyEditor.createNodes(propertyEditorTree, property, this.getLabelFor(property)) : null;
    }

    protected abstract String getLabelFor(Property var1);

    protected abstract List getProperties(PropertyEditorTree var1);

    protected abstract PropertyEditorTree.Node createPropertyNodes(PropertyEditorTree var1, Property var2, UITree var3, Object var4);

    protected abstract PropertyEditorTree.Node createPropertyNodesInGroup(PropertyEditorTree var1, Property var2, UITree var3, Object var4);

    protected abstract UITree getHierarchySource();

    protected abstract Object getHierarchySourceRoot(UITree var1);

    protected abstract PropertyEditorTree createTree();

    public ComponentWrapper createPropertyEditorComponent() {
        return this.createPropertyEditorComponent(false);
    }

    public ComponentWrapper createPropertyEditorMenu() {
        return this.createPropertyEditorComponent(true);
    }

    private ComponentWrapper createPropertyEditorComponent(boolean bl) {
        final PropertyEditorTree propertyEditorTree = this.createTree();
        if (bl) {
            propertyEditorTree.setMenu();
        }
        List list = this.getProperties(propertyEditorTree);
        UITree uITree = this.getHierarchySource();
        new TreeBuilder(){

            protected Object createNodes(Object object, Object object2) {
                return SelectionBase.this.createPropertyNodes(propertyEditorTree, (Property)object, (UITree)this.source, object2);
            }

            protected Object createGroup(Object object) {
                PropertyEditorTree.Node node = new PropertyEditorTree.Node();
                node.described = UI.nodeToDescribed((UITree)this.source, object);
                return node;
            }

            protected Object createNodesInGroup(Object object, Object object2) {
                return SelectionBase.this.createPropertyNodesInGroup(propertyEditorTree, (Property)object, (UITree)this.source, object2);
            }
        }.buildTree((TreeModel)uITree, this.getHierarchySourceRoot(uITree), (MutableTreeModel)propertyEditorTree, list);
        if (bl) {
            propertyEditorTree.insert(propertyEditorTree.getRoot(), 0, (Object)new PropertyEditorTree.SelectionNode(this), null);
            return UIToolkit.get(this.context).createComponentMenu(propertyEditorTree);
        }
        final ComponentWrapper componentWrapper = UIToolkit.get(this.context).createComponentTree(propertyEditorTree);
        final Object object = UIToolkit.get(this.context).createScrollPane(componentWrapper.getComponent());
        return new ComponentWrapper(){

            public void dispose() {
                componentWrapper.dispose();
            }

            public Object getComponent() {
                return object;
            }
        };
    }

    public Transferable toTransferable(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void delete(boolean bl) {
        throw new UnsupportedOperationException();
    }
}

