/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.registry;

import de.grogra.graph.impl.Node;
import de.grogra.graph.impl.SharedObjectNode;
import de.grogra.icon.IconSource;
import de.grogra.persistence.IndirectField;
import de.grogra.persistence.Manageable;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceField;
import de.grogra.persistence.Shareable;
import de.grogra.persistence.SharedObjectProvider;
import de.grogra.pf.registry.Directory;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ObjectItem;
import de.grogra.pf.registry.PluginDescriptor;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.expr.Resource;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.ComponentWrapper;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.Showable;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.UIProperty;
import de.grogra.pf.ui.UIToolkit;
import de.grogra.pf.ui.edit.NodeSelection;
import de.grogra.pf.ui.edit.PropertyEditor;
import de.grogra.pf.ui.edit.Selectable;
import de.grogra.pf.ui.edit.Selection;
import de.grogra.pf.ui.event.ActionEditEvent;
import de.grogra.pf.ui.registry.PanelFactory;
import de.grogra.pf.ui.tree.RegistryAdapter;
import de.grogra.pf.ui.tree.UISubTree;
import de.grogra.pf.ui.tree.UITree;
import de.grogra.pf.ui.util.ComponentWrapperImpl;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.util.Lockable;
import de.grogra.util.Map;
import de.grogra.util.StringMap;
import de.grogra.xl.util.ObjectList;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.EventObject;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import javax.swing.tree.TreePath;

public class ExplorerFactory
extends PanelFactory {
    private static final int OBJ_DESCRIBES_MASK = 4096;
    public static final int USED_BITS = 13;
    String baseName;
    String objectDir;
    String factoryDir;
    public static final Node.NType $TYPE = new Node.NType((Node)new ExplorerFactory());
    public static final Node.NType.Field objDescribes$FIELD = new Node.NType.BitField($TYPE, "objDescribes", 0x200000, Type.BOOLEAN, 4096);
    public static final Node.NType.Field baseName$FIELD;
    public static final Node.NType.Field objectDir$FIELD;
    public static final Node.NType.Field factoryDir$FIELD;

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new ExplorerFactory();
    }

    ExplorerFactory() {
        this(null, null, null, null);
    }

    ExplorerFactory(String string, String string2, String string3, String string4) {
        super(string, null);
        this.baseName = string2;
        this.factoryDir = string3;
        this.objectDir = string4;
        this.bits |= 0x1000;
    }

    public static UITree createExplorerTree(UITree uITree, TreePath treePath) {
        return new ExplorerTree(uITree, treePath);
    }

    public static Panel createHelpExplorer(Context context, Map map) {
        final UIToolkit uIToolkit = UIToolkit.get(context);
        final Object object = uIToolkit.createTextViewer(null, null, null, null, true);
        Panel panel = uIToolkit.createPanel(context, null, map);
        Item item = Item.resolveItem((RegistryContext)context.getWorkbench(), (String)"/help");
        RegistryAdapter registryAdapter = new RegistryAdapter(context, context.getWorkbench().getRegistry()){

            public Object invoke(Object object3, String string, Object object2) {
                if ("explore".equals(string) && object3 instanceof Resource) {
                    uIToolkit.setContent(object, (URL)((Resource)object3).evaluate((RegistryContext)this, new StringMap().putBoolean("pluginURL", true)));
                    UI.consume(object2);
                    return null;
                }
                return super.invoke(object3, string, object2);
            }
        };
        ComponentWrapper componentWrapper = uIToolkit.createTree(ExplorerFactory.createExplorerTree(registryAdapter, new TreePath(item.getPath())));
        Object object2 = uIToolkit.createSplitContainer(1);
        uIToolkit.addComponent(object2, uIToolkit.createScrollPane(componentWrapper.getComponent()), null);
        uIToolkit.addComponent(object2, object, null);
        panel.setContent(new ComponentWrapperImpl(object2, componentWrapper));
        return panel;
    }

    public static void installHelpTOCs(Registry registry) {
        for (Node node = registry.getPluginDirectory().getBranch(); node != null; node = node.getSuccessor()) {
            URL uRL;
            if (!(node instanceof PluginDescriptor) || (uRL = ((PluginDescriptor)node).getPluginClassLoader().getPluginResource("doc/toc.hhc")) == null) continue;
            try {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.connect();
                InputStreamReader inputStreamReader = new InputStreamReader(uRLConnection.getInputStream(), "ISO-8859-1");
                ExplorerFactory.installHelpTOC(inputStreamReader, (PluginDescriptor)node);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static void installHelpTOC(Reader reader, final PluginDescriptor pluginDescriptor) throws IOException {
        final Item item = pluginDescriptor.getRegistry().getItem("/help");
        new ParserDelegator().parse(reader, new HTMLEditorKit.ParserCallback(){
            final ObjectList stack = new ObjectList();
            private String name;
            private String address;
            private Item current;
            private boolean sitemap;

            public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
                if (tag == HTML.Tag.PARAM) {
                    if (mutableAttributeSet.containsAttribute(HTML.Attribute.NAME, "Name")) {
                        this.name = String.valueOf(mutableAttributeSet.getAttribute(HTML.Attribute.VALUE));
                    } else if (mutableAttributeSet.containsAttribute(HTML.Attribute.NAME, "Local")) {
                        this.address = String.valueOf(mutableAttributeSet.getAttribute(HTML.Attribute.VALUE));
                    }
                }
            }

            public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
                if (tag == HTML.Tag.UL) {
                    if (this.current != null) {
                        Directory directory = new Directory(null, true);
                        directory.initPluginDescriptor(pluginDescriptor);
                        directory.setDescription("Name", this.current.getDescription("Name"));
                        if (this.current.getPredecessor() != null) {
                            this.current.getPredecessor().setSuccessor((Node)directory);
                        } else {
                            this.current.getAxisParent().setBranch((Node)directory);
                        }
                        directory.setBranch((Node)this.current);
                        this.stack.push((Object)directory);
                    } else {
                        this.stack.push((Object)this.current);
                    }
                } else if (tag == HTML.Tag.OBJECT) {
                    this.name = null;
                    this.address = null;
                    this.sitemap = mutableAttributeSet.containsAttribute(HTML.Attribute.TYPE, "text/sitemap");
                }
            }

            public void handleEndTag(HTML.Tag tag, int n) {
                if (tag == HTML.Tag.UL) {
                    this.current = (Item)this.stack.pop();
                } else if (tag == HTML.Tag.OBJECT && this.sitemap) {
                    Resource resource = new Resource("doc/" + this.address);
                    resource.initPluginDescriptor(pluginDescriptor);
                    resource.setDescription("Name", (Object)this.name);
                    resource.setDescription("Icon", UI.I18N.getObject("registry.file.Icon"));
                    if (this.current == null) {
                        item.add((Item)resource);
                    } else {
                        this.current.setSuccessor((Node)resource);
                    }
                    this.current = resource;
                }
            }
        }, true);
    }

    protected Panel configure(Context context, Panel panel, Item item) {
        if (panel == null) {
            Item item2 = Item.resolveItem((RegistryContext)context.getWorkbench(), (String)this.objectDir);
            if (item2 == null) {
                throw new NullPointerException(this.objectDir + " cannot be resolved");
            }
            panel = UIToolkit.get(context).createPanel(context, null, (Map)this);
            ComponentWrapper componentWrapper = UIToolkit.get(context).createTree(ExplorerFactory.createExplorerTree(new RegistryAdapter(context, item2.getRegistry()), new TreePath(item2.getPath())));
            panel.setContent(new ComponentWrapperImpl(UIToolkit.get(context).createScrollPane(componentWrapper.getComponent()), componentWrapper));
        }
        if (item != null) {
            UI.setMenu(panel, item, (Map)this);
        }
        return panel;
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)objDescribes$FIELD);
        baseName$FIELD = new _Field("baseName", 0x200000, (Type)ClassAdapter.wrap(String.class), null, 0);
        $TYPE.addManagedField((ManageableType.Field)baseName$FIELD);
        objectDir$FIELD = new _Field("objectDir", 0x200000, (Type)ClassAdapter.wrap(String.class), null, 1);
        $TYPE.addManagedField((ManageableType.Field)objectDir$FIELD);
        factoryDir$FIELD = new _Field("factoryDir", 0x200000, (Type)ClassAdapter.wrap(String.class), null, 2);
        $TYPE.addManagedField((ManageableType.Field)factoryDir$FIELD);
        $TYPE.validate();
    }

    private static class ExplorerTree
    extends UISubTree
    implements Command {
        ExplorerTree(UITree uITree, TreePath treePath) {
            super(uITree, treePath);
        }

        public void eventOccured(Object object, EventObject eventObject) {
            if (!(eventObject instanceof ActionEditEvent)) {
                super.eventOccured(object, eventObject);
                return;
            }
            ActionEditEvent actionEditEvent = (ActionEditEvent)eventObject;
            this.uiTree.invoke(object, "explore", eventObject);
            if (actionEditEvent.isConsumed()) {
                return;
            }
            if ("delete".equals(actionEditEvent.getName()) && object instanceof Item && ((Item)object).isUserItem()) {
                actionEditEvent.consume();
                this.delete((Item)object);
            } else if ("open".equals(actionEditEvent.getName())) {
                if (object instanceof Showable) {
                    actionEditEvent.consume();
                    ((Showable)object).show(actionEditEvent);
                } else if (object instanceof ObjectItem) {
                    actionEditEvent.consume();
                    this.select((ObjectItem)object);
                }
            } else if ("rename".equals(actionEditEvent.getName()) && object instanceof ObjectItem && ((Item)object).isUserItem()) {
                actionEditEvent.consume();
                Object object2 = actionEditEvent.getParameter();
                if (object2 instanceof String && ((String)object2).length() > 0) {
                    this.rename((Item)object, (String)object2);
                }
            }
        }

        private void rename(Item item, String string) {
            UI.executeLockedly((Lockable)item.getRegistry().getProjectGraph(), true, this, new Object[]{item, string}, this.getContext(), 10000);
        }

        private void delete(Item item) {
            UI.executeLockedly((Lockable)item.getRegistry().getProjectGraph(), true, this, item, this.getContext(), 10000);
        }

        public String getCommandName() {
            return null;
        }

        public void run(Object object, Context context) {
            if (object instanceof Item) {
                Item item = (Item)object;
                if (item.getBranch() == null) {
                    item.deactivate();
                    item.remove();
                }
            } else {
                Object[] objectArray = (Object[])object;
                Item item = (Item)objectArray[0];
                String string = (String)objectArray[1];
                Node.name$FIELD.setObject((Object)item, null, (Object)string, item.getTransaction());
            }
        }

        private void select(ObjectItem objectItem) {
            SharedObjectProvider sharedObjectProvider;
            Selection selection;
            Object object = objectItem.getObject();
            if (object instanceof Showable) {
                ((Showable)object).show(this.getContext());
                return;
            }
            if (object instanceof Selectable) {
                selection = ((Selectable)object).toSelection(this.getContext());
            } else if (object instanceof Node && ((Node)object).getPersistenceManager() != null) {
                selection = new NodeSelection(this.getContext(), (Node)object, new PersistenceField[]{new IndirectField((Type)((Node)object).getNType())}, null, null, null, (Item)objectItem, object instanceof IconSource);
            } else if (object instanceof Shareable && (sharedObjectProvider = ((Shareable)object).getProvider()) instanceof SharedObjectNode) {
                selection = new NodeSelection(this.getContext(), (Node)sharedObjectProvider, new PersistenceField[]{SharedObjectNode.object$FIELD}, null, new PropertyEditor[]{PropertyEditor.findEditor(this.getContext().getWorkbench(), (Type)(object instanceof Manageable ? ((Manageable)object).getManageableType() : ClassAdapter.wrap(object.getClass())), false)}, null, (Item)objectItem, object instanceof IconSource);
            } else {
                return;
            }
            UIProperty.WORKBENCH_SELECTION.setValue(this.getContext(), selection);
        }
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    ((ExplorerFactory)object).baseName = (String)object2;
                    return;
                }
                case 1: {
                    ((ExplorerFactory)object).objectDir = (String)object2;
                    return;
                }
                case 2: {
                    ((ExplorerFactory)object).factoryDir = (String)object2;
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((ExplorerFactory)object).baseName;
                }
                case 1: {
                    return ((ExplorerFactory)object).objectDir;
                }
                case 2: {
                    return ((ExplorerFactory)object).factoryDir;
                }
            }
            return super.getObject(object);
        }
    }
}

