/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class Statistics {
    public static double calculateMean(Number[] numberArray) {
        double d = Double.NaN;
        if (numberArray != null && numberArray.length > 0) {
            int n;
            double d2 = 0.0;
            for (n = 0; n < numberArray.length; ++n) {
                d2 += numberArray[n].doubleValue();
            }
            d = d2 / (double)n;
        }
        return d;
    }

    public static double calculateMean(Collection collection) {
        double d = Double.NaN;
        int n = 0;
        double d2 = 0.0;
        for (Object e : collection) {
            if (e == null || !(e instanceof Number)) continue;
            Number number = (Number)e;
            d2 += number.doubleValue();
            ++n;
        }
        if (n > 0) {
            d = d2 / (double)n;
        }
        return d;
    }

    public static double calculateMedian(List list) {
        return Statistics.calculateMedian(list, true);
    }

    public static double calculateMedian(List arrayList, boolean bl) {
        double d = Double.NaN;
        if (arrayList != null) {
            Serializable serializable;
            int n;
            if (bl) {
                n = arrayList.size();
                serializable = new ArrayList(n);
                for (int i = 0; i < n; ++i) {
                    serializable.add(i, arrayList.get(i));
                }
                Collections.sort(serializable);
                arrayList = serializable;
            }
            if ((n = arrayList.size()) > 0) {
                if (n % 2 == 1) {
                    if (n > 1) {
                        serializable = (Number)arrayList.get((n - 1) / 2);
                        d = ((Number)serializable).doubleValue();
                    } else {
                        serializable = (Number)arrayList.get(0);
                        d = ((Number)serializable).doubleValue();
                    }
                } else {
                    serializable = (Number)arrayList.get(n / 2 - 1);
                    Number number = (Number)arrayList.get(n / 2);
                    d = (((Number)serializable).doubleValue() + number.doubleValue()) / 2.0;
                }
            }
        }
        return d;
    }

    public static double calculateMedian(List list, int n, int n2) {
        return Statistics.calculateMedian(list, n, n2, true);
    }

    public static double calculateMedian(List list, int n, int n2, boolean bl) {
        double d = Double.NaN;
        if (bl) {
            ArrayList arrayList = new ArrayList(n2 - n + 1);
            for (int i = n; i <= n2; ++i) {
                arrayList.add(list.get(i));
            }
            Collections.sort(arrayList);
            d = Statistics.calculateMedian(arrayList, false);
        } else {
            int n3 = n2 - n + 1;
            if (n3 > 0) {
                if (n3 % 2 == 1) {
                    if (n3 > 1) {
                        Number number = (Number)list.get(n + (n3 - 1) / 2);
                        d = number.doubleValue();
                    } else {
                        Number number = (Number)list.get(n);
                        d = number.doubleValue();
                    }
                } else {
                    Number number = (Number)list.get(n + n3 / 2 - 1);
                    Number number2 = (Number)list.get(n + n3 / 2);
                    d = (number.doubleValue() + number2.doubleValue()) / 2.0;
                }
            }
        }
        return d;
    }

    public static double getStdDev(Number[] numberArray) {
        double d = Statistics.calculateMean(numberArray);
        double d2 = 0.0;
        for (int i = 0; i < numberArray.length; ++i) {
            double d3 = numberArray[i].doubleValue() - d;
            d2 += d3 * d3;
        }
        return Math.sqrt(d2 / (double)(numberArray.length - 1));
    }

    public static double[] getLinearFit(Number[] numberArray, Number[] numberArray2) {
        if (numberArray.length != numberArray2.length) {
            throw new IllegalArgumentException("Statistics.getLinearFit(): array lengths must be equal.");
        }
        double[] dArray = new double[2];
        dArray[1] = Statistics.getSlope(numberArray, numberArray2);
        dArray[0] = Statistics.calculateMean(numberArray2) - dArray[1] * Statistics.calculateMean(numberArray);
        return dArray;
    }

    public static double getSlope(Number[] numberArray, Number[] numberArray2) {
        int n;
        if (numberArray.length != numberArray2.length) {
            throw new IllegalArgumentException("Array lengths must be equal.");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n = 0; n < numberArray.length; ++n) {
            d += numberArray[n].doubleValue();
            d2 += Math.pow(numberArray[n].doubleValue(), 2.0);
            d3 += numberArray2[n].doubleValue() * numberArray[n].doubleValue();
            d4 += numberArray2[n].doubleValue();
        }
        return (d3 - d * d4 / (double)n) / (d2 - d * d / (double)n);
    }

    public static double getCorrelation(Number[] numberArray, Number[] numberArray2) {
        if (numberArray == null) {
            throw new IllegalArgumentException("Null 'data1' argument.");
        }
        if (numberArray2 == null) {
            throw new IllegalArgumentException("Null 'data2' argument.");
        }
        if (numberArray.length != numberArray2.length) {
            throw new IllegalArgumentException("'data1' and 'data2' arrays must have same length.");
        }
        int n = numberArray.length;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d6 = 0.0;
            if (numberArray[i] != null) {
                d6 = numberArray[i].doubleValue();
            }
            double d7 = 0.0;
            if (numberArray2[i] != null) {
                d7 = numberArray2[i].doubleValue();
            }
            d += d6;
            d2 += d7;
            d5 += d6 * d7;
            d3 += d6 * d6;
            d4 += d7 * d7;
        }
        return ((double)n * d5 - d * d2) / Math.pow(((double)n * d3 - d * d) * ((double)n * d4 - d2 * d2), 0.5);
    }

    public static double[][] getMovingAverage(Number[] numberArray, Number[] numberArray2, int n) {
        if (numberArray.length != numberArray2.length) {
            throw new IllegalArgumentException("Array lengths must be equal.");
        }
        if (n > numberArray.length) {
            throw new IllegalArgumentException("Period can't be longer than dataset.");
        }
        double[][] dArray = new double[numberArray.length - n][2];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i][0] = numberArray[i + n].doubleValue();
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += numberArray2[i + j].doubleValue();
            }
            dArray[i][1] = d /= (double)n;
        }
        return dArray;
    }
}

