/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.WindDataItem;
import org.jfree.data.xy.WindDataset;

public class DefaultWindDataset
extends AbstractXYDataset
implements WindDataset {
    private List seriesKeys;
    private List allSeriesData;

    public DefaultWindDataset() {
        this.seriesKeys = new ArrayList();
        this.allSeriesData = new ArrayList();
    }

    public DefaultWindDataset(Object[][][] objectArray) {
        this(DefaultWindDataset.seriesNameListFromDataArray((Object[][])objectArray), objectArray);
    }

    public DefaultWindDataset(String[] stringArray, Object[][][] objectArray) {
        this(Arrays.asList(stringArray), objectArray);
    }

    public DefaultWindDataset(List list, Object[][][] objectArray) {
        this.seriesKeys = list;
        int n = objectArray.length;
        this.allSeriesData = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            ArrayList<WindDataItem> arrayList = new ArrayList<WindDataItem>();
            int n2 = objectArray[i].length;
            for (int j = 0; j < n2; ++j) {
                Serializable serializable;
                Number number;
                Object object = objectArray[i][j][0];
                if (object == null) continue;
                if (object instanceof Number) {
                    number = (Number)object;
                } else if (object instanceof Date) {
                    serializable = (Date)object;
                    number = new Long(serializable.getTime());
                } else {
                    number = new Integer(0);
                }
                serializable = (Number)objectArray[i][j][1];
                Number number2 = (Number)objectArray[i][j][2];
                arrayList.add(new WindDataItem(number, (Number)serializable, number2));
            }
            Collections.sort(arrayList);
            this.allSeriesData.add(i, arrayList);
        }
    }

    public int getSeriesCount() {
        return this.allSeriesData.size();
    }

    public int getItemCount(int n) {
        List list = (List)this.allSeriesData.get(n);
        return list.size();
    }

    public Comparable getSeriesKey(int n) {
        return this.seriesKeys.get(n).toString();
    }

    public Number getX(int n, int n2) {
        List list = (List)this.allSeriesData.get(n);
        WindDataItem windDataItem = (WindDataItem)list.get(n2);
        return windDataItem.getX();
    }

    public Number getY(int n, int n2) {
        return this.getWindForce(n, n2);
    }

    public Number getWindDirection(int n, int n2) {
        List list = (List)this.allSeriesData.get(n);
        WindDataItem windDataItem = (WindDataItem)list.get(n2);
        return windDataItem.getWindDirection();
    }

    public Number getWindForce(int n, int n2) {
        List list = (List)this.allSeriesData.get(n);
        WindDataItem windDataItem = (WindDataItem)list.get(n2);
        return windDataItem.getWindForce();
    }

    public static List seriesNameListFromDataArray(Object[][] objectArray) {
        int n = objectArray.length;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add("Series " + (i + 1));
        }
        return arrayList;
    }
}

