/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.data.xy.AbstractXYZDataset;
import org.jfree.data.xy.MatrixSeries;
import org.jfree.data.xy.XYZDataset;
import org.jfree.util.ObjectUtilities;

public class MatrixSeriesCollection
extends AbstractXYZDataset
implements XYZDataset,
Serializable {
    private static final long serialVersionUID = -3197705779242543945L;
    private List seriesList = new ArrayList();

    public MatrixSeriesCollection() {
        this(null);
    }

    public MatrixSeriesCollection(MatrixSeries matrixSeries) {
        if (matrixSeries != null) {
            this.seriesList.add(matrixSeries);
            matrixSeries.addChangeListener(this);
        }
    }

    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    public MatrixSeries getSeries(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("Index outside valid range.");
        }
        MatrixSeries matrixSeries = (MatrixSeries)this.seriesList.get(n);
        return matrixSeries;
    }

    public int getSeriesCount() {
        return this.seriesList.size();
    }

    public Comparable getSeriesKey(int n) {
        return this.getSeries(n).getKey();
    }

    public Number getX(int n, int n2) {
        MatrixSeries matrixSeries = (MatrixSeries)this.seriesList.get(n);
        int n3 = matrixSeries.getItemColumn(n2);
        return new Integer(n3);
    }

    public Number getY(int n, int n2) {
        MatrixSeries matrixSeries = (MatrixSeries)this.seriesList.get(n);
        int n3 = matrixSeries.getItemRow(n2);
        return new Integer(n3);
    }

    public Number getZ(int n, int n2) {
        MatrixSeries matrixSeries = (MatrixSeries)this.seriesList.get(n);
        Number number = matrixSeries.getItem(n2);
        return number;
    }

    public void addSeries(MatrixSeries matrixSeries) {
        if (matrixSeries == null) {
            throw new IllegalArgumentException("Cannot add null series.");
        }
        this.seriesList.add(matrixSeries);
        matrixSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof MatrixSeriesCollection) {
            MatrixSeriesCollection matrixSeriesCollection = (MatrixSeriesCollection)object;
            return ObjectUtilities.equal(this.seriesList, matrixSeriesCollection.seriesList);
        }
        return false;
    }

    public int hashCode() {
        return this.seriesList != null ? ((Object)this.seriesList).hashCode() : 0;
    }

    public void removeAllSeries() {
        for (int i = 0; i < this.seriesList.size(); ++i) {
            MatrixSeries matrixSeries = (MatrixSeries)this.seriesList.get(i);
            matrixSeries.removeChangeListener(this);
        }
        this.seriesList.clear();
        this.fireDatasetChanged();
    }

    public void removeSeries(MatrixSeries matrixSeries) {
        if (matrixSeries == null) {
            throw new IllegalArgumentException("Cannot remove null series.");
        }
        if (this.seriesList.contains(matrixSeries)) {
            matrixSeries.removeChangeListener(this);
            this.seriesList.remove(matrixSeries);
            this.fireDatasetChanged();
        }
    }

    public void removeSeries(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("Index outside valid range.");
        }
        MatrixSeries matrixSeries = (MatrixSeries)this.seriesList.get(n);
        matrixSeries.removeChangeListener(this);
        this.seriesList.remove(n);
        this.fireDatasetChanged();
    }
}

