/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jfree.date.SerialDate;

public class DateChooserPanel
extends JPanel
implements ActionListener {
    private Calendar chosenDate;
    private Color chosenDateButtonColor;
    private Color chosenMonthButtonColor;
    private Color chosenOtherButtonColor;
    private int firstDayOfWeek;
    private int yearSelectionRange = 20;
    private Font dateFont = new Font("SansSerif", 0, 10);
    private JComboBox monthSelector;
    private JComboBox yearSelector;
    private JButton todayButton;
    private JButton[] buttons;
    private boolean refreshing = false;
    private int[] WEEK_DAYS;

    public DateChooserPanel() {
        this(Calendar.getInstance(), false);
    }

    public DateChooserPanel(Calendar calendar, boolean bl) {
        super(new BorderLayout());
        this.chosenDateButtonColor = UIManager.getColor("textHighlight");
        this.chosenMonthButtonColor = UIManager.getColor("control");
        this.chosenOtherButtonColor = UIManager.getColor("controlShadow");
        this.chosenDate = calendar;
        this.firstDayOfWeek = calendar.getFirstDayOfWeek();
        this.WEEK_DAYS = new int[7];
        for (int i = 0; i < 7; ++i) {
            this.WEEK_DAYS[i] = (this.firstDayOfWeek + i - 1) % 7 + 1;
        }
        this.add((Component)this.constructSelectionPanel(), "North");
        this.add((Component)this.getCalendarPanel(), "Center");
        if (bl) {
            this.add((Component)this.constructControlPanel(), "South");
        }
        this.setDate(calendar.getTime());
    }

    public void setDate(Date date) {
        this.chosenDate.setTime(date);
        this.monthSelector.setSelectedIndex(this.chosenDate.get(2));
        this.refreshYearSelector();
        this.refreshButtons();
    }

    public Date getDate() {
        return this.chosenDate.getTime();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("monthSelectionChanged")) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            int n = this.chosenDate.get(5);
            this.chosenDate.set(5, 1);
            this.chosenDate.set(2, jComboBox.getSelectedIndex());
            int n2 = this.chosenDate.getActualMaximum(5);
            this.chosenDate.set(5, Math.min(n, n2));
            this.refreshButtons();
        } else if (actionEvent.getActionCommand().equals("yearSelectionChanged")) {
            if (!this.refreshing) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Integer n = (Integer)jComboBox.getSelectedItem();
                int n3 = this.chosenDate.get(5);
                this.chosenDate.set(5, 1);
                this.chosenDate.set(1, n);
                int n4 = this.chosenDate.getActualMaximum(5);
                this.chosenDate.set(5, Math.min(n3, n4));
                this.refreshYearSelector();
                this.refreshButtons();
            }
        } else if (actionEvent.getActionCommand().equals("todayButtonClicked")) {
            this.setDate(new Date());
        } else if (actionEvent.getActionCommand().equals("dateButtonClicked")) {
            JButton jButton = (JButton)actionEvent.getSource();
            int n = Integer.parseInt(jButton.getName());
            Calendar calendar = this.getFirstVisibleDate();
            calendar.add(5, n);
            this.setDate(calendar.getTime());
        }
    }

    private JPanel getCalendarPanel() {
        int n;
        JPanel jPanel = new JPanel(new GridLayout(7, 7));
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
        String[] stringArray = dateFormatSymbols.getShortWeekdays();
        for (n = 0; n < this.WEEK_DAYS.length; ++n) {
            jPanel.add(new JLabel(stringArray[this.WEEK_DAYS[n]], 0));
        }
        this.buttons = new JButton[42];
        for (n = 0; n < 42; ++n) {
            JButton jButton = new JButton("");
            jButton.setMargin(new Insets(1, 1, 1, 1));
            jButton.setName(Integer.toString(n));
            jButton.setFont(this.dateFont);
            jButton.setFocusPainted(false);
            jButton.setActionCommand("dateButtonClicked");
            jButton.addActionListener(this);
            this.buttons[n] = jButton;
            jPanel.add(jButton);
        }
        return jPanel;
    }

    private Color getButtonColor(Calendar calendar) {
        if (this.equalDates(calendar, this.chosenDate)) {
            return this.chosenDateButtonColor;
        }
        if (calendar.get(2) == this.chosenDate.get(2)) {
            return this.chosenMonthButtonColor;
        }
        return this.chosenOtherButtonColor;
    }

    private boolean equalDates(Calendar calendar, Calendar calendar2) {
        return calendar.get(5) == calendar2.get(5) && calendar.get(2) == calendar2.get(2) && calendar.get(1) == calendar2.get(1);
    }

    private Calendar getFirstVisibleDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.chosenDate.get(1), this.chosenDate.get(2), 1);
        calendar.add(5, -1);
        while (calendar.get(7) != this.getFirstDayOfWeek()) {
            calendar.add(5, -1);
        }
        return calendar;
    }

    private int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    private void refreshButtons() {
        Calendar calendar = this.getFirstVisibleDate();
        for (int i = 0; i < 42; ++i) {
            JButton jButton = this.buttons[i];
            jButton.setText(Integer.toString(calendar.get(5)));
            jButton.setBackground(this.getButtonColor(calendar));
            calendar.add(5, 1);
        }
    }

    private void refreshYearSelector() {
        if (!this.refreshing) {
            this.refreshing = true;
            this.yearSelector.removeAllItems();
            Integer[] integerArray = this.getYears(this.chosenDate.get(1));
            for (int i = 0; i < integerArray.length; ++i) {
                this.yearSelector.addItem(integerArray[i]);
            }
            this.yearSelector.setSelectedItem(new Integer(this.chosenDate.get(1)));
            this.refreshing = false;
        }
    }

    private Integer[] getYears(int n) {
        int n2 = this.yearSelectionRange * 2 + 1;
        int n3 = n - this.yearSelectionRange;
        Integer[] integerArray = new Integer[n2];
        for (int i = 0; i < n2; ++i) {
            integerArray[i] = new Integer(i + n3);
        }
        return integerArray;
    }

    private JPanel constructSelectionPanel() {
        JPanel jPanel = new JPanel();
        int n = this.chosenDate.getMinimum(2);
        int n2 = this.chosenDate.getMaximum(2);
        String[] stringArray = new String[n2 - n + 1];
        System.arraycopy(SerialDate.getMonths(), n, stringArray, 0, stringArray.length);
        this.monthSelector = new JComboBox<String>(stringArray);
        this.monthSelector.addActionListener(this);
        this.monthSelector.setActionCommand("monthSelectionChanged");
        jPanel.add(this.monthSelector);
        this.yearSelector = new JComboBox<Integer>(this.getYears(0));
        this.yearSelector.addActionListener(this);
        this.yearSelector.setActionCommand("yearSelectionChanged");
        jPanel.add(this.yearSelector);
        return jPanel;
    }

    private JPanel constructControlPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.todayButton = new JButton("Today");
        this.todayButton.addActionListener(this);
        this.todayButton.setActionCommand("todayButtonClicked");
        jPanel.add(this.todayButton);
        return jPanel;
    }

    public Color getChosenDateButtonColor() {
        return this.chosenDateButtonColor;
    }

    public void setChosenDateButtonColor(Color color) {
        if (color == null) {
            throw new NullPointerException("UIColor must not be null.");
        }
        Color color2 = this.chosenDateButtonColor;
        this.chosenDateButtonColor = color;
        this.refreshButtons();
        this.firePropertyChange("chosenDateButtonColor", color2, color);
    }

    public Color getChosenMonthButtonColor() {
        return this.chosenMonthButtonColor;
    }

    public void setChosenMonthButtonColor(Color color) {
        if (color == null) {
            throw new NullPointerException("UIColor must not be null.");
        }
        Color color2 = this.chosenMonthButtonColor;
        this.chosenMonthButtonColor = color;
        this.refreshButtons();
        this.firePropertyChange("chosenMonthButtonColor", color2, color);
    }

    public Color getChosenOtherButtonColor() {
        return this.chosenOtherButtonColor;
    }

    public void setChosenOtherButtonColor(Color color) {
        if (color == null) {
            throw new NullPointerException("UIColor must not be null.");
        }
        Color color2 = this.chosenOtherButtonColor;
        this.chosenOtherButtonColor = color;
        this.refreshButtons();
        this.firePropertyChange("chosenOtherButtonColor", color2, color);
    }

    public int getYearSelectionRange() {
        return this.yearSelectionRange;
    }

    public void setYearSelectionRange(int n) {
        int n2 = this.yearSelectionRange;
        this.yearSelectionRange = n;
        this.refreshYearSelector();
        this.firePropertyChange("yearSelectionRange", n2, n);
    }
}

