/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.GradientPaint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.util.PublicCloneable;

public class StandardGradientPaintTransformer
implements GradientPaintTransformer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -8155025776964678320L;
    private GradientPaintTransformType type;

    public StandardGradientPaintTransformer() {
        this(GradientPaintTransformType.VERTICAL);
    }

    public StandardGradientPaintTransformer(GradientPaintTransformType gradientPaintTransformType) {
        this.type = gradientPaintTransformType;
    }

    public GradientPaint transform(GradientPaint gradientPaint, Shape shape) {
        GradientPaint gradientPaint2 = gradientPaint;
        Rectangle2D rectangle2D = shape.getBounds2D();
        if (this.type.equals(GradientPaintTransformType.VERTICAL)) {
            gradientPaint2 = new GradientPaint((float)rectangle2D.getCenterX(), (float)rectangle2D.getMinY(), gradientPaint.getColor1(), (float)rectangle2D.getCenterX(), (float)rectangle2D.getMaxY(), gradientPaint.getColor2());
        } else if (this.type.equals(GradientPaintTransformType.HORIZONTAL)) {
            gradientPaint2 = new GradientPaint((float)rectangle2D.getMinX(), (float)rectangle2D.getCenterY(), gradientPaint.getColor1(), (float)rectangle2D.getMaxX(), (float)rectangle2D.getCenterY(), gradientPaint.getColor2());
        } else if (this.type.equals(GradientPaintTransformType.CENTER_HORIZONTAL)) {
            gradientPaint2 = new GradientPaint((float)rectangle2D.getCenterX(), (float)rectangle2D.getCenterY(), gradientPaint.getColor1(), (float)rectangle2D.getMaxX(), (float)rectangle2D.getCenterY(), gradientPaint.getColor2(), true);
        } else if (this.type.equals(GradientPaintTransformType.CENTER_VERTICAL)) {
            gradientPaint2 = new GradientPaint((float)rectangle2D.getCenterX(), (float)rectangle2D.getMinY(), gradientPaint.getColor1(), (float)rectangle2D.getCenterX(), (float)rectangle2D.getCenterY(), gradientPaint.getColor2(), true);
        }
        return gradientPaint2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardGradientPaintTransformer)) {
            return false;
        }
        StandardGradientPaintTransformer standardGradientPaintTransformer = (StandardGradientPaintTransformer)object;
        return this.type == standardGradientPaintTransformer.type;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int hashCode() {
        return this.type != null ? this.type.hashCode() : 0;
    }
}

