/*
 * Decompiled with CFR 0.152.
 */
package de.onyxbits.giftedmotion;

import de.onyxbits.giftedmotion.FrameSequenceListener;
import de.onyxbits.giftedmotion.SingleFrame;
import java.awt.Dimension;
import java.util.Vector;

public class FrameSequence {
    protected SingleFrame[] frames;
    protected SingleFrame selected;
    private Vector listeners = new Vector();

    public FrameSequence(SingleFrame[] singleFrameArray) {
        this.frames = singleFrameArray;
        this.selected = singleFrameArray[0];
    }

    public void add(SingleFrame singleFrame, int n) {
        SingleFrame[] singleFrameArray;
        if (n >= 0 && n <= this.frames.length) {
            int n2;
            singleFrameArray = new SingleFrame[this.frames.length + 1];
            for (n2 = 0; n2 < n; ++n2) {
                singleFrameArray[n2] = this.frames[n2];
            }
            singleFrameArray[n] = singleFrame;
            for (n2 = n + 1; n2 < singleFrameArray.length; ++n2) {
                singleFrameArray[n2] = this.frames[n2 - 1];
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
        this.frames = singleFrameArray;
        this.fireDataChanged();
    }

    public int getSelectedIndex() {
        for (int i = 0; i < this.frames.length; ++i) {
            if (this.frames[i] != this.selected) continue;
            return i;
        }
        return -1;
    }

    public void remove(SingleFrame singleFrame) {
        if (this.frames.length == 1 && singleFrame == this.frames[0]) {
            this.frames = new SingleFrame[0];
            this.fireDataChanged();
            return;
        }
        if (this.frames.length == 0) {
            return;
        }
        Vector<SingleFrame> vector = new Vector<SingleFrame>();
        for (int i = 0; i < this.frames.length; ++i) {
            vector.add(this.frames[i]);
        }
        vector.remove(singleFrame);
        this.frames = new SingleFrame[vector.size()];
        vector.copyInto(this.frames);
        this.selected = this.frames.length > 0 ? this.frames[0] : null;
        this.fireDataChanged();
    }

    public Dimension getExpansion() {
        Dimension dimension = new Dimension(1, 1);
        for (int i = 0; i < this.frames.length; ++i) {
            Dimension dimension2 = this.frames[i].getSize();
            if (dimension2.width > dimension.width) {
                dimension.width = dimension2.width;
            }
            if (dimension2.height <= dimension.height) continue;
            dimension.height = dimension2.height;
        }
        return dimension;
    }

    public void move(SingleFrame singleFrame, boolean bl) {
        try {
            int n = 0;
            while (this.frames[n] != singleFrame) {
                ++n;
            }
            if (bl) {
                SingleFrame singleFrame2 = this.frames[n - 1];
                this.frames[n - 1] = this.frames[n];
                this.frames[n] = singleFrame2;
            } else {
                SingleFrame singleFrame3 = this.frames[n + 1];
                this.frames[n + 1] = this.frames[n];
                this.frames[n] = singleFrame3;
            }
            this.fireDataChanged();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addFrameSequenceListener(FrameSequenceListener frameSequenceListener) {
        this.listeners.add(frameSequenceListener);
    }

    public void removeFrameSequenceListener(FrameSequenceListener frameSequenceListener) {
        this.listeners.remove(frameSequenceListener);
    }

    protected void fireDataChanged() {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            ((FrameSequenceListener)this.listeners.get(i)).dataChanged(this);
        }
    }
}

