/*
 * Decompiled with CFR 0.152.
 */
package de.onyxbits.giftedmotion;

import de.onyxbits.giftedmotion.AnimatedGifEncoder;
import de.onyxbits.giftedmotion.FrameSequence;
import de.onyxbits.giftedmotion.Settings;
import de.onyxbits.giftedmotion.SingleFrame;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.swing.ImageIcon;
import org.w3c.dom.NodeList;

public class IO {
    private IO() {
    }

    public static SingleFrame[] load(File[] fileArray) throws IOException, FileNotFoundException, IllegalArgumentException {
        Vector<SingleFrame> vector = new Vector<SingleFrame>();
        for (int i = 0; i < fileArray.length; ++i) {
            Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(IO.getSuffix(fileArray[i]));
            if (!iterator.hasNext()) {
                throw new IllegalArgumentException(fileArray[i].getPath());
            }
            ImageReader imageReader = iterator.next();
            imageReader.setInput(ImageIO.createImageInputStream(new FileInputStream(fileArray[i])));
            int n = imageReader.getNumImages(true);
            for (int j = 0; j < n; ++j) {
                BufferedImage bufferedImage = imageReader.read(j);
                if (n == 1) {
                    vector.add(new SingleFrame(bufferedImage, fileArray[i].getName()));
                    continue;
                }
                SingleFrame singleFrame = new SingleFrame(bufferedImage, j + "_" + fileArray[i].getName());
                try {
                    IIOMetadata iIOMetadata = imageReader.getImageMetadata(j);
                    NodeList nodeList = iIOMetadata.getAsTree("javax_imageio_gif_image_1.0").getChildNodes();
                    for (int k = 0; k < nodeList.getLength(); ++k) {
                        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)nodeList.item(k);
                        if (iIOMetadataNode.getNodeName().equals("GraphicControlExtension")) {
                            singleFrame.showtime = 10 * Integer.parseInt(iIOMetadataNode.getAttribute("delayTime"));
                            String string = iIOMetadataNode.getAttribute("disposalMethod");
                            if (string.equals("none")) {
                                singleFrame.dispose = 0;
                            }
                            if (string.equals("doNotDispose")) {
                                singleFrame.dispose = 1;
                            }
                            if (string.equals("restoreToBackgroundColor")) {
                                singleFrame.dispose = 2;
                            }
                            if (string.equals("restoreToPrevious")) {
                                singleFrame.dispose = 3;
                            }
                        }
                        if (!iIOMetadataNode.getNodeName().equals("ImageDescriptor")) continue;
                        int n2 = Integer.parseInt(iIOMetadataNode.getAttribute("imageLeftPosition"));
                        int n3 = Integer.parseInt(iIOMetadataNode.getAttribute("imageTopPosition"));
                        singleFrame.position = new Point(n2, n3);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                vector.add(singleFrame);
            }
        }
        Object[] objectArray = new SingleFrame[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void export(File file, FrameSequence frameSequence, Dimension dimension, Settings settings) throws IOException {
        AnimatedGifEncoder animatedGifEncoder = new AnimatedGifEncoder();
        animatedGifEncoder.start(new FileOutputStream(file));
        animatedGifEncoder.setRepeat(settings.repeat);
        animatedGifEncoder.setQuality(settings.quality);
        animatedGifEncoder.setTransparent(settings.transparent);
        for (int i = 0; i < frameSequence.frames.length; ++i) {
            animatedGifEncoder.setDelay(frameSequence.frames[i].showtime);
            animatedGifEncoder.setDispose(frameSequence.frames[i].dispose);
            animatedGifEncoder.addFrame(frameSequence.frames[i].exportFrame(dimension, settings.transparent));
        }
        animatedGifEncoder.finish();
    }

    public static void extract(FrameSequence frameSequence, File file) throws IOException {
        for (int i = 0; i < frameSequence.frames.length; ++i) {
            File file2 = new File(file, frameSequence.frames[i].toString());
            String[] stringArray = frameSequence.frames[i].toString().split("\\.");
            String string = stringArray[stringArray.length - 1].toLowerCase();
            ImageIO.write((RenderedImage)frameSequence.frames[i].raw, string, file2);
        }
    }

    public static ImageIcon createIcon(String string, String string2) {
        URL uRL = new Object().getClass().getResource("/resources/icons/" + string);
        return new ImageIcon(uRL, string2);
    }

    private static String getSuffix(File file) {
        String[] stringArray = file.getName().split("\\.");
        return stringArray[stringArray.length - 1].toLowerCase();
    }
}

