/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.disy.commons.core.collection.NullIterator;

public class MultipleValueHashMap<K, V> {
    private final Map<K, List<V>> map = new LinkedHashMap<K, List<V>>();

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MultipleValueHashMap)) {
            return false;
        }
        return ((Object)this.map).equals(((MultipleValueHashMap)obj).map);
    }

    public Iterator<V> getIterator(K key) {
        List<V> list = this.map.get(key);
        if (list != null) {
            return list.iterator();
        }
        return new NullIterator();
    }

    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public void add(K key, V value) {
        List<V> list = this.map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            this.map.put(key, list);
        }
        list.add(value);
    }

    public List<V> remove(K key) {
        return this.map.remove(key);
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    public <T> T[] getArray(K key, Class<T> clazz) {
        List<V> list = this.getList(key);
        Object[] array = (Object[])Array.newInstance(clazz, list.size());
        return list.toArray(array);
    }

    public List<V> getList(K key) {
        List<V> list = this.map.get(key);
        if (list != null) {
            return list;
        }
        return new ArrayList(0);
    }

    public Iterable<V> getValues(K key) {
        return this.getList(key);
    }

    public Object[] getArray(K key) {
        return this.getArray(key, Object.class);
    }

    public LinkedHashSet<V> getSet(K key) {
        return new LinkedHashSet<V>(this.getList(key));
    }

    public void addAll(K key, Collection<V> values) {
        for (V value : values) {
            this.add(key, value);
        }
    }

    public void addAll(MultipleValueHashMap<K, V> other) {
        for (K key : other.keySet()) {
            this.addAll(key, other.getList(key));
        }
    }
}

