/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.thread;

import java.util.LinkedList;
import net.disy.commons.core.logging.ILogger;
import net.disy.commons.core.model.BooleanModel;
import net.disy.commons.core.model.listener.ListenerList;
import net.disy.commons.core.thread.Condition;
import net.disy.commons.core.thread.IWorkQueue;
import net.disy.commons.core.thread.IWorkQueueListener;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.core.util.IClosure;

public class WorkQueue
implements IWorkQueue {
    private final ILogger logger;
    private static final String SHUTDOWN_MESSAGE = "Shutting down, will not accept any more work.";
    private final LinkedList<Runnable> queue;
    private final String queueName;
    private final int priority;
    private final boolean asDaemon;
    private final int threadCount;
    private ThreadGroup threadGroup;
    private boolean acceptingWork = true;
    private int activeWorkersCount;
    private final Condition workQueueFinished;
    private final BooleanModel busyModel = new BooleanModel();
    private final ListenerList<IWorkQueueListener> listeners = new ListenerList();

    public WorkQueue(ILogger logger, String queueName, int threadCount) {
        this(logger, queueName, threadCount, false);
    }

    public WorkQueue(ILogger logger, String queueName, int threadCount, boolean asDaemon) {
        this(logger, queueName, threadCount, asDaemon, 5, false);
    }

    public WorkQueue(ILogger logger, String queueName, int threadCount, boolean asDaemon, int priority, boolean startLater) {
        Ensure.ensureArgumentNotNull(logger);
        this.workQueueFinished = new Condition(logger, false);
        this.logger = logger;
        this.queueName = queueName;
        this.threadCount = threadCount;
        this.asDaemon = asDaemon;
        this.priority = priority;
        this.queue = new LinkedList();
        if (startLater) {
            return;
        }
        this.start();
    }

    public void start() {
        Ensure.ensureNull("Working queue " + this.queueName + " already started.", this.threadGroup);
        this.threadGroup = new ThreadGroup(this.queueName);
        this.threadGroup.setDaemon(this.asDaemon);
        this.logger.info("WorkQueue launching : " + this.queueName + " \tThreadCount: " + this.threadCount);
        for (int i = 0; i < this.threadCount; ++i) {
            PoolWorker poolWorker = new PoolWorker(this.threadGroup, this.queueName + "-T-" + i);
            poolWorker.setPriority(this.priority);
            poolWorker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable r) throws IllegalStateException {
        if (this.acceptingWork) {
            LinkedList<Runnable> linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.addLast(r);
                int queueSize = this.queue.size();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.queueName + ": enqueued Runnable[" + r.getClass().getName() + "]. Current size of queue: " + queueSize);
                }
                this.queue.notify();
            }
        } else {
            throw new IllegalStateException(SHUTDOWN_MESSAGE);
        }
        this.fireWaitingJobsCountChangedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopAcceptingWork() {
        this.acceptingWork = false;
        this.logger.info(SHUTDOWN_MESSAGE);
        LinkedList<Runnable> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.notifyAll();
        }
    }

    public void waitForWorkQueueFinished(long timeout) throws InterruptedException {
        this.workQueueFinished.waitForTrue(timeout);
    }

    private synchronized void workStarted() {
        ++this.activeWorkersCount;
        this.updateBusyModel();
        this.fireWaitingJobsCountChangedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWaitingJobsCountChangedEvent() {
        LinkedList<Runnable> linkedList = this.queue;
        synchronized (linkedList) {
            this.listeners.forAllDo(new IClosure<IWorkQueueListener>(){

                @Override
                public void execute(IWorkQueueListener listener) {
                    listener.waitingJobsCountChanged(WorkQueue.this.queue.size());
                }
            });
        }
    }

    private synchronized void workStopped() {
        --this.activeWorkersCount;
        this.updateBusyModel();
        this.checkWorkQueueFinished();
    }

    private synchronized void checkWorkQueueFinished() {
        if (!this.acceptingWork && this.activeWorkersCount == 0 && this.queue.isEmpty()) {
            this.workQueueFinished.setTrue();
        }
    }

    private synchronized void updateBusyModel() {
        this.busyModel.setValue(this.activeWorkersCount > 0);
        this.listeners.forAllDo(new IClosure<IWorkQueueListener>(){

            @Override
            public void execute(IWorkQueueListener listener) {
                listener.activeWorkersCountChanged(WorkQueue.this.activeWorkersCount);
            }
        });
    }

    public BooleanModel getBusyModel() {
        return this.busyModel;
    }

    public void addListener(IWorkQueueListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IWorkQueueListener listener) {
        this.listeners.remove(listener);
    }

    private class PoolWorker
    extends Thread {
        private PoolWorker(ThreadGroup threadGroup, String threadName) {
            super(threadGroup, threadName);
            boolean asDeamon = threadGroup.isDaemon();
            this.setDaemon(asDeamon);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Runnable r;
                LinkedList linkedList = WorkQueue.this.queue;
                synchronized (linkedList) {
                    while (WorkQueue.this.queue.isEmpty()) {
                        try {
                            if (WorkQueue.this.acceptingWork) {
                                WorkQueue.this.queue.wait();
                                continue;
                            }
                            WorkQueue.this.logger.debug(this.getName() + ": Ending PoolWorker");
                            WorkQueue.this.checkWorkQueueFinished();
                            return;
                        }
                        catch (InterruptedException ignored) {
                        }
                    }
                    r = (Runnable)WorkQueue.this.queue.removeFirst();
                    int queueSize = WorkQueue.this.queue.size();
                    if (WorkQueue.this.logger.isDebugEnabled()) {
                        WorkQueue.this.logger.debug(this.getName() + ": dequeued Runnable[" + r.getClass().getName() + "]. Current size of queue: " + queueSize);
                    }
                }
                try {
                    WorkQueue.this.workStarted();
                    r.run();
                    continue;
                }
                catch (Throwable e) {
                    WorkQueue.this.logger.error(e);
                    continue;
                }
                finally {
                    WorkQueue.this.workStopped();
                    continue;
                }
                break;
            }
        }
    }
}

