/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.input.text.component;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.exception.ConfigurationException;
import net.disy.commons.core.message.Message;
import net.disy.commons.swing.dialog.input.text.IAttributeContext;
import net.disy.commons.swing.dialog.input.text.IPresetValueListFactory;
import net.disy.commons.swing.dialog.input.text.component.IStringInputComponent;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;

public class StringComboBox
implements IStringInputComponent<JComboBox> {
    final JComboBox comboBox;
    private final IPresetValueListFactory valueListFactory;
    private final IAttributeContext attributeContext;

    public StringComboBox(IPresetValueListFactory valueListFactory, IAttributeContext attributeContext) {
        this.valueListFactory = valueListFactory;
        this.attributeContext = attributeContext;
        this.comboBox = this.createComboBox();
    }

    protected JComboBox createComboBox() {
        DefaultComboBoxModel comboBoxModel = this.createComboBoxModel();
        return new JComboBox(comboBoxModel);
    }

    @Override
    public void addChangeListener(final ChangeListener changeListener) {
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                changeListener.stateChanged(new ChangeEvent(StringComboBox.this.comboBox));
            }
        });
    }

    @Override
    public void setValue(String value) {
        this.comboBox.setSelectedItem(value);
    }

    @Override
    public String getValue() {
        return (String)this.comboBox.getSelectedItem();
    }

    @Override
    public JComboBox getComponent() {
        return this.comboBox;
    }

    @Override
    public boolean isEditable() {
        return this.comboBox.isEditable();
    }

    @Override
    public void setEditable(boolean editable) {
        this.comboBox.setEditable(editable);
    }

    @Override
    public void selectAll() {
    }

    @Override
    public void requestFocus() {
        this.comboBox.requestFocus();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.comboBox.setEnabled(enabled);
    }

    @Override
    public void update() {
    }

    private DefaultComboBoxModel createComboBoxModel() {
        List<Object> valueList = new ArrayList();
        try {
            valueList = this.valueListFactory.createList(this.attributeContext);
        }
        catch (ConfigurationException e) {
            MessageDialogFactory.createMessageDialog(this.comboBox, new Message(e.getMessage(), e)).show();
        }
        if (valueList == null) {
            return new DefaultComboBoxModel();
        }
        return new DefaultComboBoxModel<Object>(valueList.toArray());
    }
}

