/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.input.text.suggest;

import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.disy.commons.core.asynchronous.AsynchronousDroppingJobProcessor;
import net.disy.commons.core.asynchronous.IJobProcessor;
import net.disy.commons.core.exception.IExceptionHandler;
import net.disy.commons.core.model.BooleanModel;
import net.disy.commons.core.model.listener.IChangeListener;
import net.disy.commons.core.progress.ICancelable;
import net.disy.commons.core.progress.ProgressUtilities;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.component.IComponentContainer;
import net.disy.commons.swing.dialog.input.text.suggest.ISuggestionActionHandler;
import net.disy.commons.swing.dialog.input.text.suggest.ISuggestionConfiguration;
import net.disy.commons.swing.dialog.input.text.suggest.ISuggestionsProvider;
import net.disy.commons.swing.dialog.input.text.suggest.ISwingIOExceptionHandler;
import net.disy.commons.swing.dialog.input.text.suggest.internal.SuggestionWindow;
import net.disy.commons.swing.events.AbstractDocumentChangeListener;

public class SuggestionTextField<T>
implements IComponentContainer {
    private final JTextField textField = new JTextField(14);
    private final SuggestionWindow<T> window;
    private final ISuggestionConfiguration<T> configuration;
    private final AbstractDocumentChangeListener documentListener;

    public SuggestionTextField(final ISuggestionsProvider<T> provider, final ISwingIOExceptionHandler errorHandler, ISuggestionConfiguration<T> configuration) {
        Ensure.ensureArgumentNotNull(provider);
        Ensure.ensureArgumentNotNull(errorHandler);
        Ensure.ensureArgumentNotNull(configuration);
        this.configuration = configuration;
        this.window = new SuggestionWindow<T>(this.textField, configuration);
        IExceptionHandler exceptionHandler = new IExceptionHandler(){

            @Override
            public void handle(Throwable exception) {
                if (exception instanceof Error) {
                    throw (Error)exception;
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RuntimeException(exception);
            }
        };
        IJobProcessor<String> textUpdateHandler = new IJobProcessor<String>(){

            @Override
            public void process(ICancelable cancelable, String text) throws InterruptedException {
                List suggestions;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SuggestionTextField.this.window.showWithQueryStarted();
                        SuggestionTextField.this.textField.requestFocus();
                    }
                });
                try {
                    suggestions = provider.querySuggestions(text, cancelable);
                }
                catch (IOException e) {
                    ProgressUtilities.checkInterrupted(cancelable);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SuggestionTextField.this.window.dispose();
                            errorHandler.handleError(SuggestionTextField.this.textField, e);
                        }
                    });
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SuggestionTextField.this.window.showLoadedSuggestions(suggestions);
                        SuggestionTextField.this.textField.requestFocus();
                    }
                });
            }
        };
        final AsynchronousDroppingJobProcessor<String> textUpdateProcessor = new AsynchronousDroppingJobProcessor<String>(textUpdateHandler, exceptionHandler);
        this.connectWaitCursorForBusy(textUpdateProcessor);
        this.documentListener = new AbstractDocumentChangeListener(){

            @Override
            protected void documentChanged() {
                String text = SuggestionTextField.this.textField.getText();
                textUpdateProcessor.startJob(text);
            }
        };
        this.textField.getDocument().addDocumentListener(this.documentListener);
        this.textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    SuggestionTextField.this.confirmSelection();
                    return;
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    SuggestionTextField.this.window.dispose();
                    return;
                }
                if (e.getKeyCode() == 40) {
                    SuggestionTextField.this.window.moveSelectionDown();
                    return;
                }
                if (e.getKeyCode() == 38) {
                    SuggestionTextField.this.window.moveSelectionUp();
                    return;
                }
            }
        });
    }

    private void connectWaitCursorForBusy(AsynchronousDroppingJobProcessor<String> textUpdateProcessor) {
        final BooleanModel busyModel = textUpdateProcessor.getBusyModel();
        busyModel.addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                if (busyModel.getValue()) {
                    SuggestionTextField.this.textField.setCursor(Cursor.getPredefinedCursor(3));
                } else {
                    SuggestionTextField.this.textField.setCursor(Cursor.getPredefinedCursor(2));
                }
            }
        });
    }

    @Override
    public JComponent getContent() {
        return this.textField;
    }

    private void confirmSelection() {
        T item = this.window.getSelectedItem();
        if (item == null) {
            this.textField.getToolkit().beep();
            return;
        }
        this.textField.getDocument().removeDocumentListener(this.documentListener);
        this.textField.setText(this.configuration.getObjectUi().getLabel(item));
        this.textField.selectAll();
        this.textField.getDocument().addDocumentListener(this.documentListener);
        this.window.dispose();
        ISuggestionActionHandler<T> actionHandler = this.configuration.getActionHandler();
        actionHandler.handle(this.textField, item);
    }
}

