/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.fontchooser.view;

import java.awt.Component;
import java.awt.Font;
import net.disy.commons.core.text.font.FontDescription;
import net.disy.commons.swing.dialog.userdialog.UserDialog;
import net.disy.commons.swing.dialog.userdialog.builder.DialogConfigurationBuilder;
import net.disy.commons.swing.font.FontFactory;
import net.disy.commons.swing.fontchooser.model.FontModel;
import net.disy.commons.swing.fontchooser.resources.DisyCommonsSwingFontChooserMessages;
import net.disy.commons.swing.fontchooser.view.FontChooserDialogPage;
import net.disy.commons.swing.fontchooser.view.FontChooserPanel;

public class FontChooserDialog {
    private boolean canceled;
    private final Component parentComponent;
    private final FontModel fontModel;
    private final FontChooserPanel fontChooserPanel;

    @Deprecated
    public FontChooserDialog(Component parentComponent, Font font) {
        this(parentComponent, FontFactory.createFontDescription(font));
    }

    public FontChooserDialog(Component parentComponent, FontDescription fontDescription) {
        this(parentComponent, new FontModel(fontDescription));
    }

    public FontChooserDialog(Component parentComponent) {
        this(parentComponent, new FontModel());
    }

    public FontChooserDialog(Component parentComponent, FontModel fontModel) {
        this.fontModel = fontModel;
        this.parentComponent = parentComponent;
        this.fontChooserPanel = new FontChooserPanel(fontModel);
    }

    public FontChooserPanel getFontChooserPanel() {
        return this.fontChooserPanel;
    }

    public void show() {
        UserDialog dialog = this.createDialog();
        dialog.show();
        if (dialog.isCanceled()) {
            this.canceled = true;
        }
    }

    public void show(String title) {
        UserDialog dialog = this.createDialog(title);
        dialog.show();
        if (dialog.isCanceled()) {
            this.canceled = true;
        }
    }

    public UserDialog createDialog() {
        return this.createDialog(DisyCommonsSwingFontChooserMessages.getString("FontChooserDialog.title"));
    }

    private UserDialog createDialog(String title) {
        FontChooserDialogPage page = new FontChooserDialogPage(this.fontChooserPanel, title);
        UserDialog dialog = new UserDialog(this.parentComponent, new DialogConfigurationBuilder().invisibleHeaderPanel().create(page));
        return dialog;
    }

    public FontModel getFontModel() {
        return this.fontModel;
    }

    public Font getFont() {
        return this.getFontModel().getFont();
    }

    @Deprecated
    public final boolean isCancelled() {
        return this.isCanceled();
    }

    public final boolean isCanceled() {
        return this.canceled;
    }

    public void setFont(FontDescription fontDescription) {
        this.fontModel.setFont(fontDescription);
    }

    @Deprecated
    public void setFont(Font font) {
        this.fontModel.setFont(font);
    }
}

