/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.toolbar;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JToolBar;
import net.disy.commons.swing.toolbar.IToolBarItem;
import net.disy.commons.swing.toolbar.ToolBarUtilities;

public class ToolBarBuilder {
    private final JToolBar toolBar;

    public ToolBarBuilder() {
        this(false);
    }

    public ToolBarBuilder(boolean floatable) {
        this(ToolBarUtilities.createEmptyToolBar());
        this.toolBar.setFloatable(floatable);
    }

    public ToolBarBuilder(JToolBar toolbar) {
        this.toolBar = toolbar;
    }

    public ToolBarBuilder add(Action action) {
        ToolBarUtilities.addToolBarButton(this.toolBar, action);
        return this;
    }

    public ToolBarBuilder add(Action[] actions) {
        for (int i = 0; i < actions.length; ++i) {
            this.add(actions[i]);
        }
        return this;
    }

    public ToolBarBuilder add(Component ... components) {
        for (Component component : components) {
            if (component instanceof AbstractButton) {
                ToolBarUtilities.configureToolBarButton((AbstractButton)component);
            }
            this.toolBar.add(component);
        }
        return this;
    }

    public ToolBarBuilder add(IToolBarItem item) {
        item.addTo(this);
        return this;
    }

    public ToolBarBuilder addSeparator() {
        this.toolBar.addSeparator();
        return this;
    }

    public ToolBarBuilder addSeparator(Dimension size) {
        this.toolBar.addSeparator(size);
        return this;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }
}

