/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.undo;

import java.util.ArrayList;
import java.util.List;
import net.disy.commons.core.model.AbstractChangeableModel;
import net.disy.commons.swing.undo.IUndoStateManager;

public class UndoManager<T>
extends AbstractChangeableModel {
    private final IUndoStateManager<T> stateManager;
    private T actualState;
    private final List<T> undoStates = new ArrayList<T>();
    private final List<T> redoStates = new ArrayList<T>();

    public UndoManager(IUndoStateManager<T> stateManager) {
        this.stateManager = stateManager;
        this.reset();
    }

    public void reset() {
        this.actualState = this.stateManager.getState();
        this.undoStates.clear();
        this.redoStates.clear();
    }

    public boolean isUndoPossible() {
        return !this.undoStates.isEmpty();
    }

    public boolean isRedoPossible() {
        return !this.redoStates.isEmpty();
    }

    public void addUndoPoint() {
        this.undoStates.add(this.actualState);
        this.actualState = this.stateManager.getState();
        this.redoStates.clear();
        this.fireChangeEvent();
    }

    public void undo() {
        this.moveState(this.undoStates, this.redoStates);
    }

    public void redo() {
        this.moveState(this.redoStates, this.undoStates);
    }

    private void moveState(List<T> from, List<T> to) {
        to.add(this.actualState);
        this.actualState = from.get(from.size() - 1);
        this.stateManager.setState(this.actualState);
        from.remove(from.size() - 1);
        this.fireChangeEvent();
    }
}

