/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.widgets.internal;

import java.util.ArrayList;
import java.util.List;
import net.disy.commons.swing.widgets.internal.TextBlock;
import net.disy.commons.swing.widgets.internal.TextBlockDelimiter;
import net.disy.commons.swing.widgets.internal.TextPosition;

public class TextContent {
    private final List<TextBlock> textBlocks = new ArrayList<TextBlock>();

    public void setTextBlocks(List<TextBlock> textBlocks) {
        this.textBlocks.clear();
        this.textBlocks.addAll(textBlocks);
    }

    public TextPosition getLastTextPosition() {
        if (this.isEmpty()) {
            return null;
        }
        int lastBlockIndex = this.textBlocks.size() - 1;
        return new TextPosition(lastBlockIndex, this.textBlocks.get(lastBlockIndex).getText().length());
    }

    public int getBlockCount() {
        return this.textBlocks.size();
    }

    public TextBlock getBlock(int blockIndex) {
        return this.textBlocks.get(blockIndex);
    }

    public boolean isEmpty() {
        return this.textBlocks.isEmpty();
    }

    public String getText(TextPosition start, TextPosition end) {
        StringBuilder builder = new StringBuilder();
        for (int blockIndex = start.getBlockIndex(); blockIndex <= end.getBlockIndex(); ++blockIndex) {
            TextBlock block = this.getBlock(blockIndex);
            if (blockIndex == start.getBlockIndex() && blockIndex == end.getBlockIndex()) {
                builder.append(block.getText().subSequence(start.getIndexInBlock(), end.getIndexInBlock()));
                continue;
            }
            if (blockIndex == start.getBlockIndex()) {
                builder.append(block.getText().substring(start.getIndexInBlock()));
                TextContent.appendDelimiter(builder, block);
                continue;
            }
            if (blockIndex == end.getBlockIndex()) {
                builder.append(block.getText().subSequence(0, end.getIndexInBlock()));
                continue;
            }
            builder.append(block.getText());
            TextContent.appendDelimiter(builder, block);
        }
        String text = builder.toString();
        return text;
    }

    private static void appendDelimiter(StringBuilder builder, TextBlock block) {
        TextBlockDelimiter delimiter = block.getDelimiter();
        switch (delimiter) {
            case END_OF_TEXT: {
                break;
            }
            case NEWLINE: {
                builder.append('\n');
                break;
            }
            case TAB: {
                builder.append('\t');
                break;
            }
            case SPACE: {
                builder.append(' ');
            }
        }
    }
}

