/*
 * Decompiled with CFR 0.152.
 */
package de.jave.ascii.plate.textareabased;

import de.jave.ascii.IAsciiGuiConstants;
import de.jave.ascii.plate.ruler.AsciiRulerProperties;
import java.awt.Color;
import java.awt.Font;
import net.disy.commons.core.model.AbstractChangeableModel;
import net.disy.commons.core.model.listener.IChangeListener;
import net.disy.commons.swing.fontchooser.model.FontModel;

public class AsciiTextAreaProperties
extends AbstractChangeableModel {
    private boolean editable = true;
    private final FontModel fontModel;
    private Color backgroundColor = Color.WHITE;
    private Color foregroundColor = Color.BLACK;
    private final AsciiRulerProperties rulerProperties;

    public AsciiTextAreaProperties() {
        this(new FontModel(IAsciiGuiConstants.DEFAULT_ASCII_FONT));
    }

    public AsciiTextAreaProperties(FontModel fontModel) {
        fontModel.addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                AsciiTextAreaProperties.this.fireChangeEvent();
            }
        });
        this.fontModel = fontModel;
        this.rulerProperties = new AsciiRulerProperties(fontModel);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        if (this.editable == editable) {
            return;
        }
        this.editable = editable;
        this.fireChangeEvent();
    }

    public Font getFont() {
        return this.fontModel.getFont();
    }

    public AsciiRulerProperties getRulerProperties() {
        return this.rulerProperties;
    }

    public void setBackground(Color backgroundColor) {
        if (this.backgroundColor.equals(backgroundColor)) {
            return;
        }
        this.backgroundColor = backgroundColor;
        this.fireChangeEvent();
    }

    public void setForeground(Color foregroundColor) {
        if (this.foregroundColor.equals(foregroundColor)) {
            return;
        }
        this.foregroundColor = foregroundColor;
        this.fireChangeEvent();
    }
}

