/*
 * Decompiled with CFR 0.152.
 */
package de.jave.awt.clipboard;

import de.jave.awt.clipboard.DefaultClipboardOwner;
import de.jave.awt.clipboard.JaveClipboardSelection;
import de.jave.lib.CharacterPlate;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class ClipboardTransferer {
    public static final void setClipboardContent(JaveClipboardSelection sel) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(sel, DefaultClipboardOwner.getInstance());
    }

    public static final JaveClipboardSelection getClipboardContent() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            Transferable o = clipboard.getContents(null);
            if (o == null) {
                return null;
            }
            if (o instanceof JaveClipboardSelection) {
                return (JaveClipboardSelection)o;
            }
            String sel = (String)o.getTransferData(DataFlavor.stringFlavor);
            if (sel.indexOf(9) != -1) {
                return new JaveClipboardSelection(CharacterPlate.tabelize(sel));
            }
            return new JaveClipboardSelection(sel);
        }
        catch (UnsupportedFlavorException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

