/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.file;

import de.jave.figlet.file.FigFileName;
import de.jave.figlet.file.IFigFileResource;
import de.jave.figlet.util.FigException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import net.disy.commons.core.io.IOUtilities;

public abstract class AbstractFigFileResource
implements IFigFileResource {
    protected final FigFileName[] createFigFileNames(String[] names) {
        FigFileName[] figFileNames = new FigFileName[names.length];
        for (int i = 0; i < figFileNames.length; ++i) {
            figFileNames[i] = new FigFileName(names[i]);
        }
        return figFileNames;
    }

    protected final FigFileName[] loadFigletFileNames(InputStream inputStream) throws FigException {
        ArrayList<FigFileName> filenames = new ArrayList<FigFileName>();
        BufferedReader reader = null;
        try {
            if (inputStream == null) {
                throw new FigException("Unable to load font list (" + this.getRourceBaseDescription() + ")", 7);
            }
            reader = new BufferedReader(new InputStreamReader(inputStream));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                FigFileName fontDescription = new FigFileName(line);
                filenames.add(fontDescription);
            }
        }
        catch (IOException e) {
            try {
                throw new FigException("Unable to load index file containing a list of all font/control files (" + this.getRourceBaseDescription() + ")", e, 1);
            }
            catch (Throwable throwable) {
                IOUtilities.close(reader);
                IOUtilities.close(inputStream);
                throw throwable;
            }
        }
        IOUtilities.close(reader);
        IOUtilities.close(inputStream);
        return filenames.toArray(new FigFileName[filenames.size()]);
    }

    protected final long getLastModifiedDate(URL url) throws FigException {
        try {
            URLConnection connection = url.openConnection();
            return connection.getLastModified();
        }
        catch (IOException e) {
            throw new FigException("Unable to connect to url", e);
        }
    }
}

