/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.file;

import de.jave.figlet.file.FigFontCategory;
import de.jave.figlet.file.IFigFontCategorization;
import de.jave.figlet.file.IFigFontCategory;
import de.jave.figlet.file.IFigFontCategoryContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.disy.commons.core.util.Ensure;

public class FigFontCategorization
implements IFigFontCategorization {
    public static final String ALL_CATEGORY_NAME = "All fonts";
    private String defaultCategoryName = "All fonts";
    private List categories = new ArrayList();
    private Map categoriesByName = new HashMap();

    public static FigFontCategorization createFallBackCategorization(String[] fontNames) {
        String name = ALL_CATEGORY_NAME;
        FigFontCategory singleCategory = new FigFontCategory(name);
        singleCategory.addFontNames(fontNames);
        FigFontCategorization categorization = new FigFontCategorization();
        categorization.addChild(singleCategory);
        categorization.setDefaultCategoryName(name);
        return categorization;
    }

    @Override
    public Object clone() {
        FigFontCategorization clone = new FigFontCategorization();
        clone.setDefaultCategoryName(this.defaultCategoryName);
        IFigFontCategory[] childCategories = this.getChildCategories();
        for (int i = 0; i < this.getChildCategoryCount(); ++i) {
            clone.addChild((IFigFontCategory)childCategories[i].clone());
        }
        return clone;
    }

    public void setDefaultCategoryName(String name) {
        Ensure.ensureArgumentNotNull(name);
        this.defaultCategoryName = name;
    }

    @Override
    public IFigFontCategory[] getAllNonEmptyCategories() {
        ArrayList<IFigFontCategory> nonEmpty = new ArrayList<IFigFontCategory>();
        for (int i = 0; i < this.categories.size(); ++i) {
            IFigFontCategory category = (IFigFontCategory)this.categories.get(i);
            if (category.getFontCount() <= 0) continue;
            nonEmpty.add(category);
        }
        return nonEmpty.toArray(new IFigFontCategory[nonEmpty.size()]);
    }

    @Override
    public IFigFontCategory getDefaultCategory() {
        return this.getCategory(this.defaultCategoryName);
    }

    public IFigFontCategory getCategory(String name) {
        return FigFontCategorization.getCategory(this, name);
    }

    private static IFigFontCategory getCategory(IFigFontCategoryContainer container, String name) {
        if (container instanceof IFigFontCategory && ((IFigFontCategory)container).getName().equals(name)) {
            return (IFigFontCategory)container;
        }
        IFigFontCategory[] childCategories = container.getChildCategories();
        for (int i = 0; i < childCategories.length; ++i) {
            IFigFontCategory category = FigFontCategorization.getCategory(childCategories[i], name);
            if (category == null) continue;
            return category;
        }
        return null;
    }

    public int getCategoryCount() {
        return this.categories.size();
    }

    @Override
    public int getChildCategoryCount() {
        return this.categories.size();
    }

    @Override
    public IFigFontCategory[] getChildCategories() {
        return this.categories.toArray(new IFigFontCategory[this.categories.size()]);
    }

    @Override
    public void addChild(IFigFontCategory child) {
        this.categories.add(child);
        this.categoriesByName.put(child.getName(), child);
    }

    @Override
    public IFigFontCategory getChildCategory(String name) {
        for (IFigFontCategory element : this.categories) {
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }
}

