/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.io;

import de.jave.core.io.zip.ZipUtilities;
import de.jave.figlet.engine.layout.PrintDirection;
import de.jave.figlet.engine.primitives.FigCharacter;
import de.jave.figlet.engine.primitives.FigFont;
import de.jave.figlet.engine.primitives.FigFontOptions;
import de.jave.figlet.engine.primitives.FigLayout;
import de.jave.figlet.engine.primitives.FigLayoutEncoder;
import de.jave.figlet.file.FigFileName;
import de.jave.figlet.file.IFigFileResource;
import de.jave.figlet.util.FigException;
import de.jave.figlet.util.FigFileFormatException;
import de.jave.figlet.util.FigUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.StringTokenizer;
import net.disy.commons.core.io.IOUtilities;

public class FigFontFileParser {
    private static final String SIGNATURE = "flf2a";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FigFont load(FigFileName fileDescription, IFigFileResource fileResource) throws FigException {
        FigFont figFont;
        InputStreamReader reader = null;
        try {
            InputStream inputStream = fileResource.openFigFileInputStream(fileDescription);
            if (inputStream == null) {
                throw new FigException("Error loading FIGlet font '" + fileDescription.getName() + "' - the resource does not seem to exist (" + fileResource.getRourceBaseDescription() + ").", 6);
            }
            reader = new InputStreamReader(ZipUtilities.openPossiblyZipped(inputStream));
            figFont = this.readFont(fileDescription, reader);
        }
        catch (FileNotFoundException e) {
            try {
                throw new FigException("Error loading FIGlet font '" + fileDescription.getName() + "' - the resource does not exist (" + fileResource.getRourceBaseDescription() + ").", e, 6);
                catch (IOException e2) {
                    throw new FigException("Error loading FIGlet font '" + fileDescription.getName() + "'", e2, 6);
                }
            }
            catch (Throwable throwable) {
                IOUtilities.close(reader);
                throw throwable;
            }
        }
        IOUtilities.close(reader);
        return figFont;
    }

    public FigFont readFont(FigFileName fileDescription, Reader reader) throws FigFileFormatException, IOException {
        return this.readFont(fileDescription, new LineNumberReader(reader));
    }

    private FigFont readFont(FigFileName fileDescription, LineNumberReader reader) throws FigFileFormatException, IOException {
        return this.readFigFont(reader, fileDescription.getPrintName());
    }

    private FigFont readFigFont(LineNumberReader reader, String fontName) throws FigFileFormatException, IOException {
        FigCharacter character;
        String line = reader.readLine();
        if (line == null) {
            throw this.createFigFileFormatException("Unexpected end of FIGlet font file in header", reader.getLineNumber());
        }
        FigFontOptions options = this.readBasicOptions(line);
        this.readCommentLines(reader, options);
        FigFont font = new FigFont(fontName, options);
        for (int j = 0; j < options.getCodetagCount() + 102 && (character = this.loadCharacter(reader, j, options)) != null; ++j) {
            font.addCharacter(character);
            int width = character.getWidth();
            if (width <= font.getOptions().getActualMaxLineWidth()) continue;
            font.getOptions().setActualMaxLineWidth(width);
        }
        return font;
    }

    private void readCommentLines(LineNumberReader reader, FigFontOptions options) throws IOException, FigFileFormatException {
        if (options.getCommentLineCount() == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < options.getCommentLineCount(); ++i) {
            String line;
            if (i > 0) {
                sb.append("\n");
            }
            if ((line = reader.readLine()) == null) {
                throw this.createFigFileFormatException("Unexpected end of FIGlet font file in comment line", reader.getLineNumber());
            }
            sb.append(line);
        }
        options.setComments(sb.toString());
    }

    private FigCharacter loadCharacter(LineNumberReader reader, int count, FigFontOptions options) throws IOException, FigFileFormatException {
        int characterCode = count;
        if (count <= 94) {
            characterCode = count + 32;
        } else if (count == 95) {
            characterCode = 196;
        } else if (count == 96) {
            characterCode = 214;
        } else if (count == 97) {
            characterCode = 220;
        } else if (count == 98) {
            characterCode = 228;
        } else if (count == 99) {
            characterCode = 246;
        } else if (count == 100) {
            characterCode = 252;
        } else if (count == 101) {
            characterCode = 223;
        } else {
            String info = reader.readLine();
            if (info == null || info.equals("")) {
                return null;
            }
            try {
                characterCode = this.readCharacterCode(info);
            }
            catch (NumberFormatException e) {
                throw this.createFigFileFormatException("Error reading character code. Expected numeric value, was '" + info + "'", reader.getLineNumber());
            }
        }
        String[] lines = new String[options.getHeight()];
        for (int i = 0; i < lines.length; ++i) {
            String line = reader.readLine();
            if (line == null || line.length() == 0) {
                throw this.createFigFileFormatException("Unexpected end of FIGlet font file in character code='" + characterCode + "'", reader.getLineNumber());
            }
            char eol = line.charAt(line.length() - 1);
            int cutOff = 1;
            if (line.length() > 1 && line.charAt(line.length() - 2) == eol) {
                ++cutOff;
            }
            lines[i] = line.substring(0, line.length() - cutOff).replace(options.getHardblank(), '\u007f');
        }
        return new FigCharacter(characterCode, lines);
    }

    private FigFileFormatException createFigFileFormatException(String message, int lineNumber) {
        return new FigFileFormatException(message + " at input line " + lineNumber);
    }

    private int readCharacterCode(String info) {
        int characterCode;
        boolean negative = false;
        if (info.charAt(0) == '-') {
            negative = true;
            info = info.substring(1);
        }
        if (info.charAt(0) == '0') {
            if (info.length() < 2) {
                characterCode = 0;
            } else if (info.charAt(1) == 'x' || info.charAt(1) == 'X') {
                int i = info.indexOf(" ");
                if (i == -1) {
                    i = info.length();
                }
                characterCode = Integer.parseInt(info.substring(2, i), 16);
            } else {
                int i = info.indexOf(" ");
                if (i == -1) {
                    i = info.length();
                }
                characterCode = Integer.parseInt(info.substring(1, i), 8);
            }
        } else {
            int i = info.indexOf(" ");
            if (i == -1) {
                i = info.length();
            }
            characterCode = Integer.parseInt(info.substring(0, i));
        }
        if (negative) {
            characterCode = -characterCode;
        }
        return characterCode;
    }

    private FigFontOptions readBasicOptions(String header) throws FigFileFormatException {
        if (header.length() < 15) {
            throw new FigFileFormatException("Unable to read header '" + header + "'");
        }
        StringTokenizer st = new StringTokenizer(header);
        if (!st.hasMoreTokens()) {
            throw new FigFileFormatException("Unable to read header '" + header + "'");
        }
        String signature = st.nextToken();
        if (!signature.startsWith(SIGNATURE) || signature.length() != 6) {
            throw new FigFileFormatException("Illegal signature, was '" + signature + "' expected '" + SIGNATURE + "' followed by a character.");
        }
        FigFontOptions options = new FigFontOptions();
        options.setHardblank(signature.charAt(5));
        options.setHeight(this.readNextInt(st, "height", header));
        options.setBaseline(this.readNextInt(st, "baseline", header));
        options.setMaxLength(this.readNextInt(st, "maxlength", header));
        int oldLayout = this.readNextInt(st, "old_layout", header);
        FigLayout layout = new FigLayoutEncoder().createFromOldLayoutValue(oldLayout);
        options.setLayout(layout);
        options.setCommentLineCount(this.readNextInt(st, "comment_lines", header));
        options.setCodetagCount(102);
        if (!st.hasMoreTokens()) {
            return options;
        }
        int printDirectionValue = this.readNextInt(st, "print_direction", header);
        PrintDirection printDirection = new FigLayoutEncoder().getPrintDirection(printDirectionValue);
        if (printDirection == null) {
            throw new FigFileFormatException("Illegal value for printDirection: " + printDirectionValue);
        }
        layout.setPrintDirection(printDirection);
        if (!st.hasMoreTokens()) {
            return options;
        }
        int fullLayout = this.readNextInt(st, "full_layout", header);
        options.setLayout(new FigLayoutEncoder().createFromCombinedLayoutValues(oldLayout, fullLayout));
        if (!st.hasMoreTokens()) {
            return options;
        }
        options.setCodetagCount(this.readNextInt(st, "codetag_count", header));
        return options;
    }

    private void checkHasNextAttribute(StringTokenizer tokenizer, String attributeName, String header) throws FigFileFormatException {
        if (!tokenizer.hasMoreTokens()) {
            throw new FigFileFormatException("Unable to read header '" + header + "' - " + attributeName + " option missing.");
        }
    }

    private int readNextInt(StringTokenizer tokenizer, String attributeName, String header) throws FigFileFormatException {
        int value;
        this.checkHasNextAttribute(tokenizer, attributeName, header);
        String attribute = tokenizer.nextToken();
        try {
            value = FigUtilities.stringToInt(attribute);
        }
        catch (NumberFormatException e) {
            throw new FigFileFormatException("Unable to read " + attributeName + " option from header ", e);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FigFont readFont(FigFileName description, File file) throws FigFileFormatException, IOException {
        FigFont figFont;
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            figFont = this.readFont(description, reader);
        }
        catch (Throwable throwable) {
            IOUtilities.close(reader);
            throw throwable;
        }
        IOUtilities.close(reader);
        return figFont;
    }
}

