/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.swing.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class Resources {
    private static final Icon errorIcon = new ErrorIcon();

    public static Icon getIconResource(String name) {
        return Resources.getIconResource(Resources.class, name);
    }

    public static URL getResourceUrl(String name) {
        return Resources.getResourceUrl(Resources.class, name);
    }

    public static URL getResourceUrl(Class clazz, String name) {
        return clazz.getResource(name);
    }

    private static Icon getIconResource(Class clazz, String name) {
        URL url = clazz.getResource(name);
        if (url == null) {
            System.err.println("Warning: could not load icon '" + name + "'.");
            return errorIcon;
        }
        try {
            return new ImageIcon(url);
        }
        catch (Exception e) {
            return new ErrorIcon();
        }
    }

    private static final class ErrorIcon
    implements Icon {
        private ErrorIcon() {
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color previousColor = g.getColor();
            g.setColor(Color.red);
            g.fillRect(x, y, 16, 16);
            g.setColor(previousColor);
        }
    }
}

