/*
 * Decompiled with CFR 0.152.
 */
package de.jave.formula.applet;

import de.jave.formula.parser.Formula;
import de.jave.formula.parser.TokenMgrError;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class FormulaApplet
extends Applet
implements TextListener {
    private static final Font FONT = new Font("Monospaced", 0, 13);
    private TextField tfInput;
    private TextField tfStatus;
    private TextArea taResult;
    private boolean initialized = false;
    private static final String TITLE = "Jave formula2 - Mathematical expressions in ASCII";
    private static final String DEMO_FORMULA = "sqrt(PI)/5*x_i+2^y";

    @Override
    public String getAppletInfo() {
        return TITLE;
    }

    @Override
    public void init() {
        if (this.initialized) {
            return;
        }
        this.tfInput = new TextField(DEMO_FORMULA);
        this.tfInput.addTextListener(this);
        this.tfInput.selectAll();
        this.taResult = new TextArea();
        this.taResult.setEditable(false);
        this.tfStatus = new TextField("Initializing...");
        this.tfStatus.setEditable(false);
        this.tfInput.setFont(FONT);
        this.taResult.setFont(FONT);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tfInput, "North");
        this.add((Component)this.taResult, "Center");
        this.add((Component)this.tfStatus, "South");
        this.initialized = true;
    }

    @Override
    public void start() {
        this.convert();
    }

    @Override
    public void stop() {
    }

    @Override
    public void textValueChanged(TextEvent evt) {
        this.convert();
    }

    public void convert() {
        String code = this.tfInput.getText();
        String result = null;
        boolean syntaxOk = true;
        String cutOff = "";
        if (code.trim().length() == 0) {
            result = "";
            syntaxOk = true;
        } else {
            while (result == null) {
                try {
                    result = Formula.toAscii(code);
                }
                catch (TokenMgrError e) {
                    syntaxOk = false;
                    result = null;
                    if (code.length() == 0) {
                        result = "";
                        continue;
                    }
                    cutOff = code.charAt(code.length() - 1) + cutOff;
                    code = code.substring(0, code.length() - 1);
                }
                catch (Exception e) {
                    syntaxOk = false;
                    result = null;
                    if (code.length() == 0) {
                        result = "";
                        continue;
                    }
                    cutOff = code.charAt(code.length() - 1) + cutOff;
                    code = code.substring(0, code.length() - 1);
                }
            }
        }
        this.taResult.setText(result + cutOff);
        String statusMessage = syntaxOk ? "Ok." : "Syntax error.";
        this.tfStatus.setText(statusMessage);
    }
}

