/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui.io;

import de.jave.gui.io.ExtensionFileFilters;
import de.jave.gui.io.FileExtension;
import de.jave.gui.io.IFileChooserConfiguration;
import de.jave.gui.io.SmartFileFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.imageio.ImageIO;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.util.CollectionUtilities;
import net.disy.commons.core.util.ITransformer;

public class ImageIOUtilities {
    public static List<FileExtension> getSupportedReaderFileFormatExtensions() {
        String[] formats = ImageIO.getReaderFormatNames();
        HashSet<String> suffixes = new HashSet<String>();
        for (int i = 0; i < formats.length; ++i) {
            suffixes.add(formats[i].toLowerCase());
        }
        ArrayList extensions = new ArrayList(suffixes);
        Collections.sort(extensions);
        return CollectionUtilities.transform(extensions, new ITransformer<String, FileExtension>(){

            @Override
            public FileExtension transform(String extension) {
                return new FileExtension(extension);
            }
        });
    }

    public static IFileChooserConfiguration createImageOpenFileChooserConfiguration(final FileModel currentDirectoryModel) {
        return new IFileChooserConfiguration(){

            @Override
            public FileModel getCurrentDirectoryModel() {
                return currentDirectoryModel;
            }

            @Override
            public String getSaveDialogTitle() {
                return null;
            }

            @Override
            public String getOpenDialogTitle() {
                return "Open Image";
            }

            @Override
            public SmartFileFilter[] getFileFilters() {
                return new SmartFileFilter[]{ExtensionFileFilters.SUPPORTED_IMAGES};
            }

            @Override
            public String getFileNameSuggestion() {
                return null;
            }

            @Override
            public boolean isMultipleOpenFileSelectionAllowed() {
                return false;
            }
        };
    }

    public static boolean hasSupportedImageFileExtension(File file) {
        FileExtension fileExtension = FileExtension.getFrom(file);
        List<FileExtension> supportedExtensions = ImageIOUtilities.getSupportedReaderFileFormatExtensions();
        return supportedExtensions.contains(fileExtension);
    }
}

